/*******************************************************************************
*    
*   Source File: tx_application_stacks.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#ifndef TX_APPLICATION_STACKS_H
#define TX_APPLICATION_STACKS_H

#include "tx_application_Api.h"

#define TX_APP_STACK_SIZE_DEFAULT	(384)

#undef  TX_APP_BYTE_POOL_BLOCK_SIZE
#define TX_APP_BYTE_POOL_BLOCK_SIZE(blockSize) TX_APP_ALIGN_4(blockSize)

/*define stack size per module*/

#ifdef TX_APP_INCLUDE_MODULE_LINK_ADAPTATION
#ifdef ENET_INC_ARCH_WAVE600
	#define TX_APP_STACK_SIZE_LINK_ADAPTATION			(TX_APP_STACK_SIZE_DEFAULT*4)
#else	
	#define TX_APP_STACK_SIZE_LINK_ADAPTATION			(TX_APP_STACK_SIZE_DEFAULT*3)
#endif
#define TX_APP_STACK_SIZE_LINK_ADAPTATION_BLOCK			TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_LINK_ADAPTATION)
#else
#define TX_APP_STACK_SIZE_LINK_ADAPTATION_BLOCK			(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_IF
#define TX_APP_STACK_SIZE_IF							(TX_APP_STACK_SIZE_DEFAULT*3)
#define TX_APP_STACK_SIZE_IF_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_IF		)
#else
#define TX_APP_STACK_SIZE_IF_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_BSS
#define TX_APP_STACK_SIZE_BSS							(TX_APP_STACK_SIZE_DEFAULT*2)
#define TX_APP_STACK_SIZE_BSS_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_BSS)
#else
#define TX_APP_STACK_SIZE_BSS_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_ENC
#define TX_APP_STACK_SIZE_ENC							(TX_APP_STACK_SIZE_DEFAULT*2)
#define TX_APP_STACK_SIZE_ENC_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_ENC)
#else
#define TX_APP_STACK_SIZE_ENC_BLOCK						(0)
#endif



#ifdef TX_APP_INCLUDE_MODULE_IPC
#ifdef ENET_INC_ARCH_WAVE600
#define TX_APP_STACK_SIZE_IPC							(TX_APP_STACK_SIZE_DEFAULT*2)
#else
#define TX_APP_STACK_SIZE_IPC							TX_APP_STACK_SIZE_DEFAULT
#endif
#define TX_APP_STACK_SIZE_IPC_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_IPC)
#else
#define TX_APP_STACK_SIZE_IPC_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_HIM
#define TX_APP_STACK_SIZE_HIM							1024
#define TX_APP_STACK_SIZE_HIM_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_HIM)
#else
#define TX_APP_STACK_SIZE_HIM_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_INTERFERER_DETECTION
#define TX_APP_STACK_SIZE_INTERFERER_DETECTION			(TX_APP_STACK_SIZE_DEFAULT*3)
#define TX_APP_STACK_SIZE_INTERFERER_DETECTION_BLOCK	TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_INTERFERER_DETECTION)
#else
#define TX_APP_STACK_SIZE_INTERFERER_DETECTION_BLOCK	(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_COC
#define TX_APP_STACK_SIZE_COC							(2*TX_APP_STACK_SIZE_DEFAULT)
#define TX_APP_STACK_SIZE_COC_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_COC)
#else
#define TX_APP_STACK_SIZE_COC_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_BSSM
#define TX_APP_STACK_SIZE_BSSM							1100
#define TX_APP_STACK_SIZE_BSSM_BLOCK					TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_BSSM)
#else
#define TX_APP_STACK_SIZE_BSSM_BLOCK					(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_LOGGER
#define TX_APP_STACK_SIZE_LOGGER						476
#define TX_APP_STACK_SIZE_LOGGER_BLOCK					TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_LOGGER)
#else
#define TX_APP_STACK_SIZE_LOGGER_BLOCK					(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_HDK
#ifdef ENET_INC_ARCH_WAVE600
#define TX_APP_STACK_SIZE_HDK							(TX_APP_STACK_SIZE_DEFAULT*5)
#else	
#define TX_APP_STACK_SIZE_HDK							1128
#endif
#define TX_APP_STACK_SIZE_HDK_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_HDK)
#else
#define TX_APP_STACK_SIZE_HDK_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_RX_MANAGER
#define TX_APP_STACK_SIZE_RX_MANAGER					(1024)	
#define TX_APP_STACK_SIZE_RX_MANAGER_BLOCK				TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_RX_MANAGER)
#else 
#define TX_APP_STACK_SIZE_RX_MANAGER_BLOCK 				(0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_TX_MANAGER
#define TX_APP_STACK_SIZE_TX_MANAGER					(1024)	
#define TX_APP_STACK_SIZE_TX_MANAGER_BLOCK				TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_TX_MANAGER)
#else 
#define TX_APP_STACK_SIZE_TX_MANAGER_BLOCK 				(0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_TS_MANAGER
#define TX_APP_STACK_SIZE_TS_MANAGER					(1024)	
#define TX_APP_STACK_SIZE_TS_MANAGER_BLOCK				TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_TS_MANAGER)
#else 
#define TX_APP_STACK_SIZE_TS_MANAGER_BLOCK 				(0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_AGER_EMULATOR
#define TX_APP_STACK_SIZE_AGER_EMULATOR					(TX_APP_STACK_SIZE_DEFAULT+400)	
#define TX_APP_STACK_SIZE_AGER_EMULATOR_BLOCK			TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_AGER_EMULATOR)
#else 
#define TX_APP_STACK_SIZE_AGER_EMULATOR_BLOCK 			(0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_QOS
#define TX_APP_STACK_SIZE_QOS							(2*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_QOS_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_QOS)
#else 
#define TX_APP_STACK_SIZE_QOS_BLOCK (0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_CHANNEL_SWITCH_MANAGER
#ifdef ENET_INC_ARCH_WAVE600
#define TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER		(2*TX_APP_STACK_SIZE_DEFAULT)
#else
#define TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER		(TX_APP_STACK_SIZE_DEFAULT + 100)
#endif
#define TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER_BLOCK	TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER)
#else
#define	TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER_BLOCK	(0)
#endif

	

#ifdef TX_APP_INCLUDE_MODULE_PAC_MANAGER 
#define TX_APP_STACK_SIZE_PAC_MANAGER					(TX_APP_STACK_SIZE_DEFAULT*4)
#define TX_APP_STACK_SIZE_PAC_MANAGER_BLOCK				TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_PAC_MANAGER)
#else
#define TX_APP_STACK_SIZE_PAC_MANAGER_BLOCK				(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_STATISTICS_MANAGER
#define TX_APP_STACK_SIZE_STATS_MANAGER					(3*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_TX_STATS_MANAGER_BLOCK		TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_STATS_MANAGER)
#else
#define TX_APP_STACK_SIZE_TX_STATS_MANAGER_BLOCK		(0)
#endif
 
#ifdef TX_APP_INCLUDE_MODULE_PROCESS_MANAGER
#define TX_APP_STACK_SIZE_PROCESS_MANAGER				(2*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_PROCESS_MANAGER_BLOCK			TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_PROCESS_MANAGER)
#else
#define TX_APP_STACK_SIZE_PROCESS_MANAGER_BLOCK			(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_DUT
#define TX_APP_STACK_SIZE_DUT							(1024 - 100)	
#define TX_APP_STACK_SIZE_DUT_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_DUT)
#else
#define TX_APP_STACK_SIZE_DUT_BLOCK						(0)
#endif

#ifdef TX_APP_INCLUDE_MODULE_GROUP_MANAGER
#define TX_APP_STACK_SIZE_GROUP_MANAGER					(1024)	
#define TX_APP_STACK_SIZE_GROUP_MANAGER_BLOCK			TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_GROUP_MANAGER)
#else 
#define TX_APP_STACK_SIZE_GROUP_MANAGER_BLOCK 			(0)
#endif 
#ifdef TX_APP_INCLUDE_HDK_CDB_MANAGER
#define TX_APP_STACK_SIZE_HDK_CDB_MANAGER				(TX_APP_STACK_SIZE_DEFAULT*2)	
#define TX_APP_STACK_SIZE_HDK_CDB_MANAGER_BLOCK			TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_HDK_CDB_MANAGER)
#else 
#define TX_APP_STACK_SIZE_HDK_CDB_MANAGER_BLOCK 		(0)
#endif 
#ifdef TX_APP_INCLUDE_PROCESS_MANAGER_CDB
#define TX_APP_STACK_SIZE_PROCESS_MANAGER_CDB			(TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_PROCESS_MANAGER_CDB_BLOCK		TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_PROCESS_MANAGER_CDB)
#else 
#define TX_APP_STACK_SIZE_PROCESS_MANAGER_CDB_BLOCK 	(0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_PTA
#ifdef PTA_BUILD_IN_PLAT
#define TX_APP_STACK_SIZE_PTA							(2*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_PTA_BLOCK						TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_PTA)
#endif
#else 
#define TX_APP_STACK_SIZE_PTA_BLOCK						(0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_ATF
#define TX_APP_STACK_SIZE_ATF					        (2*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_ATF_BLOCK			            TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_ATF)
#else 
#define TX_APP_STACK_SIZE_ATF_BLOCK 			        (0)
#endif 

#ifdef TX_APP_INCLUDE_MODULE_HE_GROUP_MANAGER
#define TX_APP_STACK_SIZE_HE_GROUP_MANAGER				(4*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_HE_GROUP_MANAGER_BLOCK		TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_HE_GROUP_MANAGER)
#else 
#define TX_APP_STACK_SIZE_HE_GROUP_MANAGER_BLOCK 			(0)
#endif 


#ifdef TX_APP_INCLUDE_MODULE_PLAN_MANAGER
#define TX_APP_STACK_SIZE_PLAN_MANAGER					(4*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_PLAN_MANAGER_BLOCK			TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_PLAN_MANAGER)
#else 
#define TX_APP_STACK_SIZE_PLAN_MANAGER_BLOCK 			(0)
#endif 


#ifdef TX_APP_INCLUDE_MODULE_TWT_MANAGER
#define TX_APP_STACK_SIZE_TWT_MANAGER					(4*TX_APP_STACK_SIZE_DEFAULT)	
#define TX_APP_STACK_SIZE_TWT_MANAGER_BLOCK			    TX_APP_BYTE_POOL_BLOCK_SIZE(TX_APP_STACK_SIZE_TWT_MANAGER)
#else 
#define TX_APP_STACK_SIZE_TWT_MANAGER_BLOCK 			(0)
#endif 




#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT
#ifdef ENET_INC_ARCH_WAVE600

#define TX_APP_STACK_SIZE_IDLE							(2*TX_APP_STACK_SIZE_DEFAULT)
#else
#define TX_APP_STACK_SIZE_IDLE							(TX_APP_STACK_SIZE_DEFAULT)

#endif
#else 
#define TX_APP_STACK_SIZE_IDLE							(0)	
#endif

/*define total size of byte pool for stacks*/
#define TX_APP_POOL_STACK_WORD_SIZE \
	((\
 	TX_APP_STACK_SIZE_IF_BLOCK				         +\
	TX_APP_STACK_SIZE_BSS_BLOCK				         +\
 	TX_APP_STACK_SIZE_IPC_BLOCK						 +\
	TX_APP_STACK_SIZE_HIM_BLOCK				         +\
	TX_APP_STACK_SIZE_INTERFERER_DETECTION_BLOCK	 +\
	TX_APP_STACK_SIZE_COC_BLOCK 					 +\
	TX_APP_STACK_SIZE_BSSM_BLOCK			         +\
 	TX_APP_STACK_SIZE_LOGGER_BLOCK			         +\
	TX_APP_STACK_SIZE_HDK_BLOCK				         +\
	TX_APP_STACK_SIZE_RX_MANAGER_BLOCK               +\
	TX_APP_STACK_SIZE_TX_MANAGER_BLOCK               +\
	TX_APP_STACK_SIZE_TS_MANAGER_BLOCK               +\
	TX_APP_STACK_SIZE_AGER_EMULATOR_BLOCK            +\
	TX_APP_STACK_SIZE_QOS_BLOCK                      +\
	TX_APP_STACK_SIZE_ENC_BLOCK				         +\
	TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER_BLOCK	 +\
	TX_APP_STACK_SIZE_TX_STATS_MANAGER_BLOCK         +\
	TX_APP_STACK_SIZE_PROCESS_MANAGER_BLOCK          +\
	TX_APP_STACK_SIZE_PAC_MANAGER_BLOCK 	         +\
	TX_APP_STACK_SIZE_DUT_BLOCK 			         +\
	TX_APP_STACK_SIZE_GROUP_MANAGER_BLOCK            +\
	TX_APP_STACK_SIZE_PTA_BLOCK						 +\
	TX_APP_STACK_SIZE_ATF_BLOCK                      +\
	TX_APP_STACK_SIZE_HE_GROUP_MANAGER_BLOCK		 +\
	TX_APP_STACK_SIZE_PLAN_MANAGER_BLOCK			 +\
	TX_APP_STACK_SIZE_TWT_MANAGER_BLOCK              +\
	TX_APP_STACK_SIZE_LINK_ADAPTATION_BLOCK          +\
	TX_APP_STACK_SIZE_HDK_CDB_MANAGER_BLOCK			 +\
	TX_APP_STACK_SIZE_PROCESS_MANAGER_CDB_BLOCK		 +\
	TX_APP_STACK_SIZE_IDLE\
	)/4)


#endif //TX_APPLICATION_STACKS_H
