/*******************************************************************************
*    
*   Source File: tx_application_trace.h
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#ifndef TX_APPLICATION_TRACE_H
#define TX_APPLICATION_TRACE_H

#include "tx_application_Api.h"
#include "loggerAPI.h"
#include "tx_application_thread_list.h"
#include "tx_trace.h"
#include "Pac_Api.h"


#if defined (ENET_INC_ARCH_WAVE600)
#define THREADX_DEBUG_ON		 1
#else
#define THREADX_DEBUG_ON		 0
#endif

#define SIZE_OF_TRACEX_DUMP		 64000


typedef enum
{
	THREADX_SEND,
	THREADX_SEND_RESUME,
	THREADX_QUEUE_WAIT,
	THREADX_QUEUE_RECEIVED,
	THREADX_TIMER_MUTEX_WAIT,
	THREADX_TIMER_MUTEX_RECEIVED,
	THREADX_GET_FAST_MSG_WAIT,
	THREADX_GET_FAST_MSG_RESUME,
	THREADX_GET_DEFAULT_MSG_WAIT,
	THREADX_GET_DEFAULT_MSG_RESUME,
	THREADX_FREE_FAST_MSG_WAIT,
	THREADX_FREE_FAST_MSG_RESUME,
	THREADX_FREE_DEFAULT_MSG_WAIT,
	THREADX_FREE_DEFAULT_MSG_RESUME,
	THREADX_THREAD_RELINQUISH,
	THREADX_NUM_DEBUG

} ThreadxDebug_e;

#if (THREADX_DEBUG_ON)

#define THREADX_DEBUG_ARRAY_SIZE 256

#define TX_EVENT_WIDTH 	8
#define TX_TASK_WIDTH	8
#define TX_MSG_WIDTH	16

typedef struct  
{
	uint32			tsf;
	uint32			txEvent:TX_EVENT_WIDTH;
	uint32			from:TX_TASK_WIDTH;
	uint32			toORmsg:TX_MSG_WIDTH;	/*to is used to store message ID in some cases*/
} ThreadxDebug_t;


extern ThreadxDebug_t	ThreadxDebugArray[THREADX_DEBUG_ARRAY_SIZE];
extern uint32			ThreadxDebugArrayCicles;
extern uint32			ThreadxDebugArrayIdx;
 
#define THREADX_TRACE(_txEvent,_from,_to)										\
		OSAL_DISABLE_INTERRUPTS(&interrupt_save);								\
		if (ThreadxDebugArrayIdx > (THREADX_DEBUG_ARRAY_SIZE-1))				\
		{																		\
			ThreadxDebugArrayIdx = 0;											\
			ThreadxDebugArrayCicles++; 											\
		}																		\
		ThreadxDebugArray[ThreadxDebugArrayIdx].txEvent = _txEvent; 			\
		ThreadxDebugArray[ThreadxDebugArrayIdx].tsf = Pac_TimGetTsfLow();		\
		ThreadxDebugArray[ThreadxDebugArrayIdx].from = _from;					\
		ThreadxDebugArray[ThreadxDebugArrayIdx].toORmsg = _to;					\
		ThreadxDebugArrayIdx++; 												\
		OSAL_ENABLE_INTERRUPTS(interrupt_save);
#else
#define THREADX_TRACE(txEvent,from,to)	{}
#endif

#ifdef TX_ENABLE_EVENT_TRACE
extern	UCHAR	tracexDumpFile[SIZE_OF_TRACEX_DUMP];
#endif

#endif //TX_APPLICATION_TRACE_H

