/*******************************************************************************
*    
*   Source File: fw_utils_queue.c
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "tx_application_Api.h"
#include "fw_utils_queue.h"
#include "stringLibApi.h"
#include "tx_application_trace.h"
#include "tx_application_define.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_TX_APP
#define LOG_LOCAL_FID 0



/******************************************************************************
 **
 ** Name:		FwUtils_Enqueue
 **
 ** Purpose:	service routine which enqueues node in mutex-protected queue
 **				
 ** Input:		FwUtils_queue_t* 		pQueue
 ** 			K_MSG* 					pNode 
 **
 ** Output:		None
 **
 ******************************************************************************/
void FwUtils_Enqueue(FwUtils_queue_t* pQueue, K_MSG* pNode)
{
	TX_INTERRUPT_SAVE_AREA;

	TxApp_IncMsgRefCount(pNode);

	/* Critical Section */	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	pNode->header.psNext= NULL;

	if (pQueue->tail == NULL)
	{/* list is empty */
		pQueue->tail = pQueue->head = pNode;
	}
	else
	{/* list is not empty */
		pQueue->tail->header.psNext = pNode;
		pQueue->tail = pNode;
	}

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

/******************************************************************************
 **
 ** Name:		FwUtils_EnqueueToHead
 **
 ** Purpose:	service routine which enqueues node in mutex-protected queue to
 				the head of the queue
 **				
 ** Input:		FwUtils_queue_t* 		pQueue
 ** 			K_MSG* 					pNode 
 **
 ** Output:		None
 **
 ******************************************************************************/
void FwUtils_EnqueueToHead(FwUtils_queue_t* pQueue, K_MSG* pNode)
{
	TX_INTERRUPT_SAVE_AREA;

	TxApp_IncMsgRefCount(pNode);

	/* Critical Section */	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);


	if (pQueue->head == NULL)
	{/* list is empty */
		pQueue->tail = pQueue->head = pNode;
		pNode->header.psNext= NULL;
	}
	else
	{/* list is not empty */
		pNode->header.psNext = pQueue->head;
		pQueue->head		 = pNode;
	}

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}


/******************************************************************************
 **
 ** Name:		FwUtils_Dequeue
 **
 ** Purpose:	service routine which dequeues node from mutex-protected queue
 **				
 ** Input:		FwUtils_queue_t* pQueue
 **
 ** Output:		K_MSG*
 **
 ******************************************************************************/
K_MSG* FwUtils_Dequeue(FwUtils_queue_t* pQueue)
{
	TX_INTERRUPT_SAVE_AREA;
	K_MSG *pTmp = NULL;

	/* Critical Section */	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	if (pQueue->head)
    { 
		pTmp = pQueue->head;

		TxApp_DecMsgRefCount(pQueue->head);

		pQueue->head = pQueue->head->header.psNext;
		if (pQueue->head == NULL)
		{
			pQueue->tail = NULL;
		}
    }

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
	
	return pTmp;
}


/******************************************************************************
 **
 ** Name:		FwUtils_InitQueue
 **
 ** Purpose:	service routine which inits queue
 **				
 ** Input:		FwUtils_queue_t* pQueue
 **
 ** Output:		void
 **
 ******************************************************************************/
void FwUtils_InitQueue(FwUtils_queue_t* pQueue)
{
	pQueue->head = NULL;
	pQueue->tail = NULL;
}





//*******v******* old queues methodology *******v************/

bool FwUtils_IsQueueEmpty( FwUtils_queue_t *psQueue )
{
    if (psQueue->head != K_MSG_NULL)
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

//******^******** old queues methodology *************^******/

