/*******************************************************************************
*    
*   Source File: tx_application_IdleCount.c
*	
*	AUTHOR: Omer Gazit	
*
*   Description: 
				This thread is assigned with the system's lowest priority, and be run when system is Idle. 
				COUNTS_PER_10MS  is the number which the thread can count (without prreemprion) in 10 miliseconds. 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "Pac_Api.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "performanceCounters_api.h"
#endif
#ifdef ARC_SIM
#include "arc_reg.h"
#endif


#define LOG_LOCAL_GID GLOBAL_GID_TX_APP
#define LOG_LOCAL_FID 4

#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT


#ifndef ENET_INC_ARCH_WAVE600
volatile uint32 idleCount = 0; 
uint32 totalCountTime = 0; 
#endif

uint32 cpuLoadArrayIndex = 0; 
uint32 cpuLoadArray[CPU_LOAD_ARRAY_SIZE];  // In gen5 - each entry represent ~0.1 second,  The total array gives perspective on 1sec. In gen6 - each entry is 1 second.

#ifdef ARC_SIM
uint32 trigger_int_g = 0;
#endif

void IdleCountEntry(K_MSG* psMsg);
uint32 TxApplicationIdleCountGetUpperMacCpuLoad(void);

	/* following pragma will avoid warning of "missing-noreturn" flag */   
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wmissing-noreturn"	
void IdleCountEntry(K_MSG* psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)

	//Init the performance counters (currently used to measure idle time).
	// We do it here since we want to start measurements only now.
	UNUSED_PARAM(psMsg);
	PerformanceCounters_Init();

	while(1) //klockwork ignore Interrupt will get us out of here.
	{
		// Sleep in order to save power. Interrupt will get us out of here.
		_sleep(0);
		
		// Check asserts from host
		ErrorHadler_CheckAssertReqFromHost();
#ifdef ARC_SIM
		if (trigger_int_g != 0)
		{
			_sr(20, AUX_IRQ_HINT);// trigger interrupt 20
		}
#endif
	}

#else // not ENET_INC_ARCH_WAVE600

	uint32 initialCountTime = 0;
	uint32 currentCountTime = 0;
	uint32 finalCountTime = 0; 
 	uint32 deltatTime = 0; 

	TX_INTERRUPT_SAVE_AREA;
	UNUSED_PARAM(psMsg);
	/* Mesure how many micros takes to get to 10,000*/	
	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	initialCountTime = Pac_TimGetTsfLow();/*do nothing - just wait fot tick timer to progress  and  countIn10ms hav'nt been update*/
			
	while(idleCount < NUM_OF_COUNTS_TO_MESURE_CPU) 
	{
		idleCount++; 
		currentCountTime = Pac_TimGetTsfLow(); // Dummy operation - just to make the loops complexity eqeaul
	}
	idleCount = 0; 
	finalCountTime = Pac_TimGetTsfLow();/*do nothing - just wait fot tick timer to progress  and	countIn10ms hav'nt been update*/
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
	totalCountTime = (finalCountTime - initialCountTime)*CPU_LOAD_MESUREMANT_FACTOR; // factor  
		
	while(1)
	{
		currentCountTime = Pac_TimGetTsfLow();
		finalCountTime = currentCountTime + totalCountTime; 	

		while((currentCountTime < finalCountTime) && (idleCount < (NUM_OF_COUNTS_TO_MESURE_CPU*CPU_LOAD_MESUREMANT_FACTOR))) 
		{

			idleCount++; 
			currentCountTime = Pac_TimGetTsfLow();
		}

		deltatTime = currentCountTime - finalCountTime; 



		totalCountTime += deltatTime; 

		if (totalCountTime > 0)
		{
			idleCount = idleCount - (((deltatTime)*idleCount +1)) / totalCountTime; 
		}	
	
		if(cpuLoadArrayIndex == CPU_LOAD_ARRAY_SIZE)
		{
			cpuLoadArrayIndex = 0; 
		}
		cpuLoadArray[cpuLoadArrayIndex] = idleCount/(NUM_OF_COUNTS_TO_MESURE_CPU*CPU_LOAD_PRECENT_WITH_FACTOR);//idleCount*100 / (NUM_OF_COUNTS_TO_MESURE_CPU*1000); 
		cpuLoadArrayIndex++; 
		
		idleCount = 0; 

		ErrorHadler_CheckAssertReqFromHost();
		
	}
#endif
}
#pragma clang diagnostic pop


/***********************************************************************
* TxApplicationIdleCountGetUpperMacCpuLoad
* 
* Description:
* ------------
* API for the CPU load calculated by the TX APP
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
uint32 TxApplicationIdleCountGetUpperMacCpuLoad(void)
{
	uint32 count = 0;
	uint32 sum = 0;
	for (count = 0; count < 100; count++)
	{
		ILOG0_D("[AGER_POC] load = %d", (100 - cpuLoadArray[count]));
		sum += (100 - cpuLoadArray[count]);
	}
	ILOG0_D("[AGER_POC] average = %d", (sum/100));
	/* Load = 100% - Idle */	
	return(100 - cpuLoadArray[cpuLoadArrayIndex]);
}


#endif /*TX_APP_INCLUDE_MODULE_IDLE_COUNT*/

