/*******************************************************************************
*    
*   Source File: tx_application_define.c
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "tx_api.h"
#include "tx_application_define.h"
#include "tx_application_vars.h"
#include "tx_application_entry_func.h"
#include "fw_utils_queue.h"
#include "stringLibApi.h"
#include "System_MainApi.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_TX_APP
#define LOG_LOCAL_FID 1






uint32 QueueLocation[TX_APP_POOL_QUEUE_WORD_SIZE];
uint32 StackLocation[TX_APP_POOL_STACK_WORD_SIZE];
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif



void TxApp_OverlayStacksAndQueues(void **pQueueLocation, void **pStackLocation)
{
	/* Assumption .initialization section adjacent to .text section */
	/* the definitions of the sections are at the linker file (.ld) */
	//char* initializationSectionStartAddr = __ghsbegin_initialization;
	//char* textSectionStartAddr = __ghsbegin_text;
	//uint32 initializationSizeAddress = ((uint32)textSectionStartAddr - (uint32)initializationSectionStartAddr);
	//uint32 lastAllocationAddress = (uint32)initializationSectionStartAddr;

	//memset(initializationSectionStartAddr, 0xef, initializationSizeAddress);

	//*pQueueLocation = (byte *)(lastAllocationAddress);
	//lastAllocationAddress += (TX_APP_BYTE_POOL_QUEUE_SIZE*sizeof(byte));

	*pQueueLocation = QueueLocation;

	//*pStackLocation = (byte *)(lastAllocationAddress);
	//lastAllocationAddress += (TX_APP_BYTE_POOL_STACK_SIZE*sizeof(byte));

	*pStackLocation = StackLocation;

	//ASSERT(lastAllocationAddress < (uint32)(textSectionStartAddr));
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


/******************************************************************************
 **
 ** Name:		tx_application_define
 **
 ** Purpose:	mendatory function for threadx, called from tx_kernel_enter
 **				and defines all data structures used by threadx kernel, e.g.
 **				queues, stacks, message pools, timers and threads
 **				
 ** Input:		void *first_unused_memory - not used
 **
 ** Output:		None
 **
 ******************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization_start" 
#endif

void tx_application_define(void *first_unused_memory)
{
	uint16 status = 0;
	uint16 threadIdx;
	byte* pQueueLocation = NULL; //pointer to mem area of size TX_APP_BYTE_POOL_QUEUE_SIZE
	byte* pStackLocation = NULL; //pointer to mem area of size TX_APP_BYTE_POOL_STACK_SIZE
	UNUSED_PARAM(first_unused_memory);
//	TxApp_OverlayStacksAndQueues(&(void*)pQueueLocation, &(void*)pStackLocation);
	TxApp_OverlayStacksAndQueues((void **)&pQueueLocation, (void **)&pStackLocation);


	TxApp_TimerInitialization(); 

	/*create timer pool*/

	ASSERT(status == TX_SUCCESS);

	/*create msg pools*/
	status = tx_block_pool_create(&TxApp_blockPool_fastMsgs,			//pool_ptr
								"tx_app_fast_msg_pool",					//name
								TX_APP_BLOCK_POOL_FAST_MSG_BLOCK_SIZE,	//block_size
								TX_APP_BLOCK_POOL_FAST_MSG_POOL_ADDR,	//pool_start
								TX_APP_BLOCK_POOL_FAST_MSG_POOL_WORD_SIZE*4);	//pool_size
	ASSERT(status == TX_SUCCESS);

	/*init timer queue*/
	TxApp_timerTicksCounter=0;

	/*create queues and stacks for each thread*/
	for (threadIdx = 0; threadIdx < TX_APP_THRD_NUM; threadIdx++)
	{
		/*create queues*/
		status = tx_queue_create(&(TxApp_threadInfoArray[threadIdx].queue),
									(char *)TxApp_threadPeripheralInfoArray[threadIdx].name,
									TX_APP_QUEUE_MSG_SIZE_IN_WORDS,	
									pQueueLocation,	
									TxApp_threadPeripheralInfoArray[threadIdx].queueSize);
		ASSERT(status == TX_SUCCESS);
	
		pQueueLocation += (TxApp_threadPeripheralInfoArray[threadIdx].queueSize);

		/*create threads*/
#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT
		if(threadIdx == Tx_App_THRD_IdleCount)
		{
			status = tx_thread_create(&(TxApp_threadInfoArray[threadIdx].thread),	
									(char *)TxApp_threadPeripheralInfoArray[threadIdx].name,	
									IdleCountEntry,
									threadIdx,	
									pStackLocation,	
									TxApp_threadPeripheralInfoArray[threadIdx].stackSize,	
									TxApp_threadPeripheralInfoArray[threadIdx].priority,	
									TxApp_threadPeripheralInfoArray[threadIdx].preemptThrsld,	
									TX_APP_TIME_SLICE_NO_TIME_SLICE,	
									TX_AUTO_START);
		}
		else
#endif /*TX_APP_INCLUDE_MODULE_IDLE_COUNT*/
		{
			status = tx_thread_create(&(TxApp_threadInfoArray[threadIdx].thread),	
									(char *)TxApp_threadPeripheralInfoArray[threadIdx].name,	
									TxApp_ThrdEntryFunc_General,
									threadIdx,	
									pStackLocation,	
									TxApp_threadPeripheralInfoArray[threadIdx].stackSize,	
									TxApp_threadPeripheralInfoArray[threadIdx].priority,	
									TxApp_threadPeripheralInfoArray[threadIdx].preemptThrsld,	
									TX_APP_TIME_SLICE_NO_TIME_SLICE,	
									TX_AUTO_START);
		}

		ASSERT(status == TX_SUCCESS);
	
		pStackLocation += (TxApp_threadPeripheralInfoArray[threadIdx].stackSize);
	}

/*Create Mutexes */
	//status = tx_mutex_create(&msdu_mutex,"TS_Mngt_Mutext", TX_INHERIT); 

	//ASSERT(status == TX_SUCCESS);

	System_MainPostThreadxInit(); /* finish FW initialization, after threadX is ready */
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif




