/*******************************************************************************
*    
*   Source File: tx_application_entry_func.c
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "tx_api.h"
#include "tx_application_entry_func.h"
#include "tx_application_define.h"
#include "tx_application_vars.h"
#include "tx_application_Api.h"
#include "tx_application_trace.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_TX_APP
#define LOG_LOCAL_FID 2


/******************************************************************************
 **
 ** Name:		TxApp_ThrdEntryFunc_General
 **
 ** Purpose:	general entry function for all threads. threads loop in this 
 **				function forever, waiting on their queues
 **				
 ** Input:		uint32 thread_enum
 **
 ** Output:		None
 **
 ******************************************************************************/
 	/* following pragma will avoid warning of "missing-noreturn" flag */   
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wmissing-noreturn"	
void TxApp_ThrdEntryFunc_General(uint32 thread_enum)
{
	uint16 status;
	TxApp_interThreadMsg_t interThreadMsg;
	byte bPersistent;

#if (THREADX_DEBUG_ON)
		TX_INTERRUPT_SAVE_AREA;
#endif

	while (1)
	{
	
		ErrorHadler_CheckAssertReqFromHost(); 
		
		/*wait on relevant queue*/
#if defined (ENET_INC_HW_FPGA) && defined (ENET_INC_LMAC1)
		if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
		{
			THREADX_TRACE(THREADX_QUEUE_WAIT, thread_enum, 0);
		}

		//KW_FIX_FW_M - pragma ignore as register read  ??? License requirements on Threadx??

		ASSERT(thread_enum < TX_APP_THRD_NUM);
		status = tx_queue_receive(&(TxApp_threadInfoArray[thread_enum].queue), &interThreadMsg, TX_WAIT_FOREVER);
		
		ILOG2_D("Thread : %d  Entry func, recieved message ",thread_enum);
		ASSERT(status == TX_SUCCESS);
		
#if defined (ENET_INC_HW_FPGA) && defined (ENET_INC_LMAC1)
		if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
		{
			THREADX_TRACE(THREADX_QUEUE_RECEIVED, thread_enum, 0);
		}
		/* Take a copy of this in case task function deletes the message itself */

		ASSERT(interThreadMsg.p != PNULL);
		
		bPersistent = interThreadMsg.p->header.bPersistentMsg;
#ifdef TLOG_FLAG
		TLOG0(interThreadMsg.p, FALSE);
#endif
		/*call function according to task (same as in asAPP_TaskTable)*/
		(*(TxApp_threadPeripheralInfoArray[thread_enum].entryFunc))(interThreadMsg.p);

		/* Free message (if it's not still referenced by any tasks) */
		TxApp_FreeMessage(interThreadMsg.p, bPersistent);
	}
#pragma clang diagnostic pop
}
