/*******************************************************************************
*    
*   Source File: tx_application_timer.c
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "tx_api.h"
#include "tx_application_vars.h"
#include "tx_application_define.h"
#include "tx_application_Api.h"
#include "database.h"
#include "stringLibApi.h"
#include "fw_utils_queue.h"
#if (defined(ENET_INC_LMAC) & defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL))
#include "Bsrc.h"
#include "Bsrc_Api.h"
#endif
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#endif
#include "tx_application_trace.h"
#include "loggerAPI.h"
#if defined (CPU_ARC)
#include "System_CoreTimersApi.h"
#endif
#include "linkAdaptation_api.h"

#define LOG_LOCAL_GID GLOBAL_GID_TX_APP
#define LOG_LOCAL_FID 6


#if defined(ENET_INC_ARCH_WAVE600) || defined(ENET_INC_UMAC)
static TxApp_timerInfo_t TimerInfoArray[TX_APP_NUMBER_OF_TIMERS] = 
{
#if (defined(ENET_INC_UMAC) && defined (ENET_INC_ARCH_WAVE600))
	{{0}, TASK_HDK_CDB_MANAGER,			HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED}, 

#endif
#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_CHANNEL_SWITCH_MANAGER,		CHANNEL_SWITCH_MANAGER_CHANNEL_LOAD_TIMER_EXPIRED}, // This timer is in UM for wave500 and in LM for wave600	
#endif	
#if defined(ENET_INC_UMAC) 
	{{0}, TASK_RX_MANAGER,				RX_MANAGER_TIMER},
#endif	
#if defined(ENET_INC_UMAC) 
	{{0}, TASK_TS_MANAGER,				TS_MANAGER_TIMER_EXPIRED},
#endif	
#if defined(ENET_INC_UMAC) && defined(USE_AGER_EMULATOR)
	{{0}, TASK_AGER_EMULATOR,			AGER_EMULATOR_PERIODIC_CHECK_TIMER},
#endif
#if defined(ENET_INC_UMAC)
	{{0}, TASK_TX_MANAGER,				CTS_MANAGER_STOP_TX},
#endif	
#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_TX_MANAGER,				CTS_MANAGER_STOP_TX_B1},
#endif	
#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_CHANNEL_SWITCH_MANAGER,	CHANNEL_SWITCH_MANAGER_TIMER_EXPIRED},	// This timer is in UM for wave500 and in LM for wave600
#endif
#if defined(ENET_INC_UMAC)
	{{0}, TASK_GROUP_MANAGER,			GROUP_MANAGER_TRAINING_TIMER_EXPIRED},
#endif	

#if defined(ENET_INC_UMAC)
   	{{0}, TASK_ATF, 	            	ATF_BUFFERING_TIMER_EXPIRED},   
#endif

#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_ATF,						ATF_BUFFERING_TIMER_EXPIRED_B1},
#endif	
#if defined (TX_DATA_THREAD_PATH)
	{{0}, TASK_TX_MANAGER, 				TX_MANAGER_STARVATION_TIMER},	/*When data packets go thru UM, TX manager may cause starvation*/	   
#endif
#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600)) || (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
#if defined RADAR_DETECTION_ENABLED
	{{0}, TASK_INTERFERER_DETECTION,	INTERFERER_DETECTION_RADAR_AGING_TIMER}, // This timer is in UM for wave500 and in LM for wave600
#endif
	{{0}, TASK_HDK, 					HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER},
#endif
#if defined(ENET_INC_UMAC) && defined(PTA_BUILD_IN_PLAT)
	{{0}, TASK_PTA, 		            PTA_STARVATION_TIMER},
	{{0}, TASK_PTA,						PTA_REP_TIMER_EXPIRED}, /* emulation of repetition mode */
#endif	
#if defined(ENET_INC_UMAC)
	{{0}, TASK_QOS, 					QOS_PD_THRESOLD_TIMER},		
#endif	
#if (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_HDK, 					HDK_ERP_TIMER_EXPIRED},
#endif
#if (defined(ENET_INC_UMAC) && !defined(ENET_INC_ARCH_WAVE600))	
	{{0}, TASK_STATISTICS_MANAGER,		STATISTICS_MANAGER_CPU_LOAD_TIMER_EXPIRY},
#endif
#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600)) 
	{{0}, TASK_HE_GROUP_MANAGER,		HE_GROUP_MANAGER_TIMER_EXPIRED},	
#endif	
#if (defined(ENET_INC_LMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_HDK, 					HDK_DUTY_CYCLE_TIMER_EXPIRED},
#endif
#if defined(ENET_INC_UMAC)
	{{0}, TASK_TX_MANAGER,				CSA_MANAGER_START_TX_UC_DEAUTH},
	{{0}, TASK_TX_MANAGER,				CSA_MANAGER_START_TX_MC_DEAUTH},
#endif	
#if (defined(ENET_INC_UMAC) && defined(ENET_INC_ARCH_WAVE600))
	{{0}, TASK_TX_MANAGER,				CSA_MANAGER_START_TX_UC_DEAUTH_B1},
	{{0}, TASK_TX_MANAGER,				CSA_MANAGER_START_TX_MC_DEAUTH_B1},
#endif	

}; 

#endif //defined(ENET_INC_ARCH_WAVE600) || defined(ENET_INC_UMAC)

extern void _tx_timer_interrupt(void);
void TxApp_CreateTimer(TxApp_timerInfo_t* pTimerInfo);


/******************************************************************************
 **
 ** Name:		TxApp_TimerIsr
 **
 ** Purpose:	ISR for timer interrupt
 **				
 ** Input:		none
 **
 ** Output:		None
 **
 ******************************************************************************/
#if (defined(ENET_INC_LMAC) & defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL))
#include "Bsrc_Api.h"
extern void Bsrc_Command(uint16 stationId, uint8 tIdMask, uint32 counter, BsrcCommands_e command);
#endif

void TxApp_TimerIsr(void)
{
#if (defined(ENET_INC_LMAC) & defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL))
	uint8 vapId = 0;
#endif
	TxApp_timerTicksCounter++;
#if (defined(ENET_INC_LMAC) & defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL))
#if defined (ENET_INC_LMAC1)
	 if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	 {
		vapId = ConfigurationManager_GetFirstVapForBand(ConfigurationManager_GetMyBand());
#ifdef TF_TIMER_50MSEC
	 	Bsrc_SetTfFixedInterval(5); //TRIGGER every 50msec instead of 10msec
#endif
	 	if((TxApp_timerTicksCounter % Bsrc_GetTfInterval()) == 0) //TRIGGER every bsrcTfFrequency X 10 ms
	 	{
			OSAL_SEND_NO_DATA_MESSAGE(LINK_ADAPTATION_SET_BSRC_COUNTERS_FOR_STATIC_PLAN, TASK_LINK_ADAPTATION, vapId); 
	 	}
	 }
#endif
	_tx_timer_interrupt();
	
}

/******************************************************************************
 **
 ** Name:		TxApp_CreateTimer
 **
 ** Purpose:	
 **				
 **				
 ** Input:		K_MSG_TYPE bTimerId
 **				K_TIME wTimeOut
 **				K_TASKID bCurrentTaskId
 **
 ** Output:		None
 **
 ******************************************************************************/

void TxApp_CreateTimer(TxApp_timerInfo_t* pTimerInfo)
{
	uint16 status;

	status = tx_timer_create(&(pTimerInfo->timer), "tx_app_timer", TxApp_TimerExpirationFunc_General, 
		    				(uint32)(pTimerInfo), 0, TX_APP_TIMER_ONE_SHOT, TX_NO_ACTIVATE);

	ASSERT(status == TX_SUCCESS);
}


/******************************************************************************
 **
 ** Name:		TxApp_SetTimer
 **
 ** Purpose:	Activate specific timer 
 **				
 **				
 ** Input:		K_MSG_TYPE bTimerId
 **				K_TIME wTimeOut
 **				K_TASKID bCurrentTaskId
 **
 ** Output:		None
 **
 ******************************************************************************/
void TxApp_SetTimer(K_MSG_TYPE bTimerId, TX_TIME wTimeOut)
{
	uint8 timerIdx = 0;

	wTimeOut++; //Add one tick in order to fit to  the Timer resolution 
		
	while(timerIdx < TX_APP_NUMBER_OF_TIMERS)
	{
	
		if(TimerInfoArray[timerIdx].msgType == bTimerId) 
		{
			tx_timer_change((&(TimerInfoArray[timerIdx].timer)),wTimeOut, TX_APP_TIMER_ONE_SHOT);
			tx_timer_activate(&(TimerInfoArray[timerIdx].timer)); 
			break; 
			
		}
		timerIdx++; 
	}
}


/******************************************************************************
 **
 ** Name:		TxApp_ResetTimer
 **
 ** Purpose:	release a timer block 
 **				
 ** Input:		K_MSG_TYPE bTimerId
 **				K_TASKID bCurrentTaskId
 **
 ** Output:		None
 **
 ******************************************************************************/
void TxApp_ResetTimer(K_MSG_TYPE bTimerId, K_TASKID bCurrentTaskId)
{
	uint8 timerIdx = 0; 
	UNUSED_PARAM(bCurrentTaskId);	
	while(timerIdx < TX_APP_NUMBER_OF_TIMERS)
	{
		if(TimerInfoArray[timerIdx].msgType == bTimerId) 
		{
			tx_timer_deactivate(&(TimerInfoArray[timerIdx].timer)); 
			break; 
		}
		timerIdx++; 
	}
}

/******************************************************************************
 **
 ** Name:		TxApp_TimerExpirationFunc_General
 **
 ** Purpose:	general timer expiration handler, dequeues timer and sends msg
 **				to relevant task
 **				
 ** Input:		K_MSG_TYPE bTimerId
 **				K_TASKID bCurrentTaskId
 **
 ** Output:		None
 **
 ******************************************************************************/
void TxApp_TimerExpirationFunc_General(uint32 pointerToTimerInfo)
{
	TxApp_timerInfo_t* pTimerInfo = (TxApp_timerInfo_t*)(pointerToTimerInfo);

	TxApp_SendNoDataFastMessage(pTimerInfo->msgType, pTimerInfo->taskId, TX_NO_WAIT,VAP_ID_DO_NOT_CARE);
}


/******************************************************************************
 **
 ** Name:		TxApp_GetTimerTicks
 **
 ** Purpose:	return timer ticks counter
 **				
 ** Input:		none
 **
 ** Output:		uint32
 **
 ******************************************************************************/
uint32 TxApp_GetTimerTicks(void)
{
	return TxApp_timerTicksCounter;
}

/******************************************************************************
 **
 ** Name:		TxApp_TimerIsr
 **
 ** Purpose:	ISR for timer interrupt
 **				
 ** Input:		none
 **
 ** Output:		None
 **
 ******************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void TxApp_TimerInitialization(void)
{
	uint16 timerIdx;
#if defined (CPU_ARC)
	System_CoreTimersSetTimer(SYSTEM_CORE_TIMER_0,FALSE,TIMER_PERIOD_IN_MS,TxApp_TimerIsr);
#endif 
	
	for (timerIdx = 0; timerIdx < TX_APP_NUMBER_OF_TIMERS; timerIdx++)
		{
			TxApp_CreateTimer(&(TimerInfoArray[timerIdx])); 
		}
}
 
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif





