/*******************************************************************************
*    
*   Source File: tx_application_vars.c
*	
*	AUTHOR: Omer Modlin
*
*   Description: 
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "tx_api.h"
#include "tx_application_define.h"
#include "tx_application_vars.h"
#include "tx_application_entry_func.h"
#include "tx_application_trace.h"
#include "tx_application_msg_pools.h"
#include "OSAL_Tasks.h"
#if defined (ENET_INC_LMAC)
#include "linkAdaptation_api.h"
#endif


/******************************************************************************/
/***						timer variables									***/
/******************************************************************************/

uint32  volatile TxApp_timerTicksCounter = 0;

/******************************************************************************/
/***						thread variables								***/
/******************************************************************************/
TxApp_threadInfo_t	TxApp_threadInfoArray[TX_APP_THRD_NUM];	//holds runtime information about threads




/******************************************************************************/
/***					threadx pools locations								***/
/*******************************************************************************/

uint32 TxApp_BlockPoolFastMsg_location		[TX_APP_BLOCK_POOL_FAST_MSG_POOL_WORD_SIZE];

/******************************************************************************/
/***					threadx pools mngmnt blocks							***/
/******************************************************************************/

TX_BLOCK_POOL	TxApp_blockPool_fastMsgs;


/******************************************************************************/
/***						 mutexes									***/
/******************************************************************************/
//TX_MUTEX msdu_mutex; 

#if defined(ENET_INC_UMAC)

const TxApp_threadPeripheralInfo_t TxApp_threadPeripheralInfoArray[TX_APP_THRD_NUM] = //holds constant information about threads
{
	{&vUM_IF_Task,						TX_APP_QUEUE_SIZE_IF,						TX_APP_STACK_SIZE_IF,						TX_APP_PRIORITY_IF,						TX_APP_PREEMPT_THRSLD_IF,						"if",			TASK_UM_IF_TASK},				/* TASK_UM_IF_TASK */
	{&vBSS_Task,						TX_APP_QUEUE_SIZE_BSS,						TX_APP_STACK_SIZE_BSS,						TX_APP_PRIORITY_BSS, 					TX_APP_PREEMPT_THRSLD_BSS,						"Bss",			TASK_BSS_MANAGE},				/* TASK_RX_MANAGER */ 
	{&vIPC_TaskEntry,					TX_APP_QUEUE_SIZE_IPC,		    			TX_APP_STACK_SIZE_IPC ,						TX_APP_PRIORITY_IPC,		 	  	      TX_APP_PREEMPT_THRSLD_IPC,					  "ipc",			TASK_IPC},				   /*  TASK_IPC_1 */
#ifndef ENET_INC_ARCH_WAVE600	
	{&HDK_Task, 						TX_APP_QUEUE_SIZE_HDK,		   	    		TX_APP_STACK_SIZE_HDK,						TX_APP_PRIORITY_HDK,		 			  TX_APP_PREEMPT_THRSLD_HDK,			   		  "HDK",			TASK_HDK},         			   /*  TASK_HDK */
#endif
	{&vHIM_Task,						TX_APP_QUEUE_SIZE_HIM,						TX_APP_STACK_SIZE_HIM,						TX_APP_PRIORITY_HIM,					TX_APP_PREEMPT_THRSLD_HIM,						"him",			TASK_HIM},						/* TASK_HIM */
	{&BssManager_Task,					TX_APP_QUEUE_SIZE_BSSM,						TX_APP_STACK_SIZE_BSSM,						TX_APP_PRIORITY_BSSM,					TX_APP_PREEMPT_THRSLD_BSSM,						"BssMngr",		TASK_BSS_MANAGER},				/* TASK_BSS_MANAGER */
#ifndef ENET_INC_ARCH_WAVE600	
	{&InterfererDetection_TaskEntry,	TX_APP_QUEUE_SIZE_INTERFERER_DETECTION,		TX_APP_STACK_SIZE_INTERFERER_DETECTION,		TX_APP_PRIORITY_INTERFERER_DETECTION,	TX_APP_PREEMPT_THRSLD_INTERFERER_DETECTION,		"Interferer",	TASK_INTERFERER_DETECTION},		/*  TASK_INTERFERER_DETECTION */
	{&CoC_task,							TX_APP_QUEUE_SIZE_COC,						TX_APP_STACK_SIZE_COC,						TX_APP_PRIORITY_COC,					TX_APP_PREEMPT_THRSLD_COC,						"coc",			TASK_COC},						/* TASK_COC */
#endif
	{&LOGGER_Task,						TX_APP_QUEUE_SIZE_LOGGER,					TX_APP_STACK_SIZE_LOGGER,					TX_APP_PRIORITY_LOGGER,					TX_APP_PREEMPT_THRSLD_LOGGER,					"LOGGER",		TASK_LOGGER},					/*  TASK_LOGGER */
	{&RxManager_TaskEntry,				TX_APP_QUEUE_SIZE_RX_MANAGER,				TX_APP_STACK_SIZE_RX_MANAGER,				TX_APP_PRIORITY_RX_MANAGER,				TX_APP_PREEMPT_THRSLD_RX_MANAGER,				"RxManager",	TASK_RX_MANAGER},				/* TASK_RX MANAGER */
	{&TxManager_TaskEntry,				TX_APP_QUEUE_SIZE_TX_MANAGER,				TX_APP_STACK_SIZE_TX_MANAGER,				TX_APP_PRIORITY_TX_MANAGER,				TX_APP_PREEMPT_THRSLD_TX_MANAGER,				"TxManager",	TASK_TX_MANAGER},				/* TASK_TX MANAGER */
	{&TsManager_TaskEntry,				TX_APP_QUEUE_SIZE_TS_MANAGER,				TX_APP_STACK_SIZE_TS_MANAGER,				TX_APP_PRIORITY_TS_MANAGER,				TX_APP_PREEMPT_THRSLD_TS_MANAGER,				"TsManager",	TASK_TS_MANAGER},				/* TASK_TS_MANAGER */
	{&Qos_TaskEntry,					TX_APP_QUEUE_SIZE_QOS,						TX_APP_STACK_SIZE_QOS,						TX_APP_PRIORITY_QOS,					TX_APP_PREEMPT_THRSLD_QOS,						"Qos",			TASK_QOS},						/* TASK_QOS */
	{&vENC_Task,						TX_APP_QUEUE_SIZE_ENC,						TX_APP_STACK_SIZE_ENC,						TX_APP_PRIORITY_ENC,					TX_APP_PREEMPT_THRSLD_ENC,						"Enc",			TASK_ENCRYPTION},				/* TASK_ENCRYPTION */
#ifndef ENET_INC_ARCH_WAVE600	
	{&ChannelSwitchManager_TaskEntry,   TX_APP_QUEUE_SIZE_CHANNEL_SWITCH_MANAGER,	TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER,	TX_APP_PRIORITY_CHANNEL_SWITCH_MANAGER,	  TX_APP_PREEMPT_THRSLD_CHANNEL_SWITCH_MANAGER,	  "CSM", 		    TASK_CHANNEL_SWITCH_MANAGER},  /*  */
#endif
#ifdef USE_AGER_EMULATOR
	{&AgerEmulator_TaskEntry,			TX_APP_QUEUE_SIZE_AGER_EMULATOR,			TX_APP_STACK_SIZE_AGER_EMULATOR,			TX_APP_PRIORITY_AGER_EMULATOR,			TX_APP_PREEMPT_THRSLD_AGER_EMULATOR,			"AgerEmulator",	TASK_AGER_EMULATOR},			/* TASK_AGER_EMULATOR */
#endif //USE_AGER_EMULATOR
	{&statisticsManagerTaskEntry,		TX_APP_QUEUE_SIZE_STATS_MANAGER,			TX_APP_STACK_SIZE_STATS_MANAGER,			TX_APP_PRIORITY_STAT_MANAGER, 			  TX_APP_PREEMPT_THRSLD_STATS_MANAGER,            "Statistics",	    TASK_STATISTICS_MANAGER},	   /*  TASK_STATISTICS_MANAGER */				
#ifndef ENET_INC_ARCH_WAVE600	
	{&ProcessManager_TaskEntry,			TX_APP_QUEUE_SIZE_PROCESS_MANAGER,			TX_APP_STACK_SIZE_PROCESS_MANAGER_BLOCK,	TX_APP_PRIORITY_PROCESS_MANAGER,		TX_APP_PREEMPT_THRSLD_PROCESS_MANAGER,			"ProcessMngr",	TASK_PROCESS_MANAGER},			/* TASK_PROCESS_MANAGER */
	{&Dut_Task,							TX_APP_QUEUE_SIZE_DUT,						TX_APP_STACK_SIZE_DUT,						TX_APP_PRIORITY_DUT,					TX_APP_PREEMPT_THRSLD_DUT,						"Dut",			TASK_DUT},						/* TASK_DUT */
#endif
#ifdef PTA_BUILD_IN_PLAT
	{&PTA_Task, 						TX_APP_QUEUE_SIZE_PTA,						TX_APP_STACK_SIZE_PTA,						TX_APP_PRIORITY_PTA,					TX_APP_PREEMPT_THRSLD_PTA,						"PTA",			TASK_PTA},						/* PTA_TASK */
#endif	
	{&GroupManager_TaskEntry,			TX_APP_QUEUE_SIZE_GROUP_MANAGER,			TX_APP_STACK_SIZE_GROUP_MANAGER,			TX_APP_PRIORITY_GROUP_MANAGER, 			 TX_APP_PREEMPT_THRSLD_GROUP_MANAGER, 			  "GroupManager",	TASK_GROUP_MANAGER},		   /*  TASK_GROUP_MANAGER */		
   	{&Atf_TaskEntry,		        	TX_APP_QUEUE_SIZE_ATF,			            TX_APP_STACK_SIZE_ATF,		            	TX_APP_PRIORITY_ATF, 		        	 TX_APP_PREEMPT_THRSLD_ATF,         			 "ATF",             TASK_ATF},		               /*  TASK_ATF */
#ifdef TX_APP_INCLUDE_MODULE_HE_GROUP_MANAGER	
	{&HeGroupManager_TaskEntry,			TX_APP_QUEUE_SIZE_HE_GROUP_MANAGER,			TX_APP_STACK_SIZE_HE_GROUP_MANAGER,			TX_APP_PRIORITY_HE_GROUP_MANAGER,		TX_APP_PREEMPT_THRSLD_HE_GROUP_MANAGER,			 "HeGroupMngr", 	TASK_HE_GROUP_MANAGER},		   /*  TASK_HE_GROUP_MANAGER */
#endif
#ifdef TX_APP_INCLUDE_MODULE_PLAN_MANAGER		
	{&PlanManager_TaskEntry,			TX_APP_QUEUE_SIZE_PLAN_MANAGER,				TX_APP_STACK_SIZE_PLAN_MANAGER,				TX_APP_PRIORITY_PLAN_MANAGER,		  	TX_APP_PREEMPT_THRSLD_PLAN_MANAGER,		 		 "PlanMngr", 		TASK_PLAN_MANAGER},			   /*  TASK_PLAN_MANAGER */
#endif
#ifdef TX_APP_INCLUDE_MODULE_TWT_MANAGER
    {&TwtManager_TaskEntry,			    TX_APP_QUEUE_SIZE_TWT_MANAGER,				TX_APP_STACK_SIZE_TWT_MANAGER,				TX_APP_PRIORITY_TWT_MANAGER,		  	TX_APP_PREEMPT_THRSLD_TWT_MANAGER,		 		 "TwtMgr", 		    TASK_TWT_MANAGER},			   /*  TASK_TWT_MANAGER */
#endif
#ifdef ENET_INC_ARCH_WAVE600	
	{&HdkCdbManager_TaskEntry,			TX_APP_QUEUE_SIZE_HDK_CDB_MANAGER,			TX_APP_STACK_SIZE_HDK_CDB_MANAGER,			TX_APP_PRIORITY_HDK_CDB_MANAGER, 		  TX_APP_PREEMPT_THRSLD_HDK_CDB_MANAGER, 		"HdkCdbManager",	TASK_HDK_CDB_MANAGER},		   /*  TASK_HDK_CDB_MANAGER */		
#endif
#ifdef HDK_CDB_SUPPORT
	{&ProcessManagerCdb_TaskEntry,		TX_APP_QUEUE_SIZE_PROCESS_MANAGER_CDB,		TX_APP_STACK_SIZE_PROCESS_MANAGER_CDB,		TX_APP_PRIORITY_PROCESS_MANAGER_CDB, 	  TX_APP_PREEMPT_THRSLD_PROCESS_MANAGER_CDB, 	"ProcessManCdb",	TASK_PROCESS_MANAGER_CDB},	   /*  TASK_PROCESS_MANAGER_CDB */		
#endif
#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT
	{NULL,								TX_APP_QUEUE_SIZE_IDLE,						TX_APP_STACK_SIZE_IDLE,						TX_APP_PRIORITY_IDLE,					TX_APP_PREEMPT_THRSLD_IDLE,						"Idle",			TASK_INVALID},					/* TASK_LOGGER */
#endif 
};


																	
const TxApp_thread_e TxApp_translatationTableFromTaskIdToThreadId[NUM_OF_TASKS_IN_SYSTEM] = //holds translation from task to thread
{ 

	
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_TICK,
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_HIGH,
		TX_APP_THRD_NULL_VALUE,				//TASK_IPC_2,
		TX_APP_THRD_NULL_VALUE,				//TASK_LINK_ADAPTATION,
		TX_APP_THRD_NULL_VALUE,				//TASK_PAC_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_MID,
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_LOW,
		TX_APP_THRD_UM_IF,					//TASK_UM_IF_TASK,
		TX_APP_THRD_BSS,					//TASK_BSS_MANAGE,
		TX_APP_THRD_TS_MANAGER,				//TASK_TS_MANAGER,
		TX_APP_THRD_QOS,					//TASK_QOS,
		TX_APP_THRD_ENC,					//TASK_ENCRYPTION,
		Tx_App_THRD_Logger,					//TASK_LOGGER,
		TX_APP_THRD_IPC,					//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
		TX_APP_THRD_PTA,					//TASK_PTA
#endif
#if defined (ENET_INC_ARCH_WAVE600)	
		TX_APP_THRD_NULL_VALUE,				//TASK_DUT,
		TX_APP_THRD_NULL_VALUE,				//TASK_INTERFERER_DETECTION,
		TX_APP_THRD_NULL_VALUE,				//TASK_COC,			
		TX_APP_THRD_NULL_VALUE,				//TASK_HDK,
#else
		TX_APP_THRD_DUT,					//TASK_DUT,
		TX_APP_THRD_INTERFERER_DETECTION,	//TASK_INTERFERER_DETECTION,			
		TX_APP_THRD_CoC,					//TASK_COC,
		TX_APP_THRD_HDK,					//TASK_HDK,
#endif
		TX_APP_THRD_HIM,					//TASK_HIM,
		TX_APP_THRD_RX_MANAGER,				//TASK_RX_MANAGER,
		TX_APP_THRD_TX_MANAGER,				//TASK_TX_MANAGER,	
		TX_APP_THRD_BSSmanager,				//TASK_BSS_MANAGER,
#if defined (ENET_INC_ARCH_WAVE600)	
		TX_APP_THRD_NULL_VALUE, 			//TASK_CHANNEL_SWITCH_MANAGER,
#else
		TX_APP_THRD_CHANNEL_SWITCH_MANAGER, //TASK_CHANNEL_SWITCH_MANAGER,
#endif
#ifdef USE_AGER_EMULATOR
		TX_APP_THRD_AGER_EMULATOR,			//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
		TX_APP_THRD_STAT_MNGR,				//TASK_STATISTICS_MANAGER,
#if defined (ENET_INC_ARCH_WAVE600)	
		TX_APP_THRD_NULL_VALUE, 			//TASK_PROCESS_MANAGER,
#else	
		TX_APP_THRD_PROCESS_MNGR,			//TASK_PROCESS_MANAGER,
#endif		
		TX_APP_THRD_GROUP_MANAGER,			//TASK_GROUP_MANAGER,
		TX_APP_THRD_ATF,					//TASK_ATF
#if defined (ENET_INC_ARCH_WAVE600)	
		TX_APP_THRD_HE_GROUP_MANAGER,		//TASK_HE_GROUP_MANAGER,
		TX_APP_THRD_PLAN_MANAGER,			//TASK_PLAN_MANAGER,
		TX_APP_THRD_TWT_MANAGER,            //TASK_TWT_MANAGER,
#endif
#if defined (ENET_INC_ARCH_WAVE600)	
		TX_APP_THRD_HDK_CDB_MANAGER,		//TASK_HDK_CDB_MANAGER,
#else
		TX_APP_THRD_NULL_VALUE, 			//TASK_HDK_CDB_MANAGER,
#endif
#if defined(HDK_CDB_SUPPORT)
		TX_APP_THRD_PROCESS_MANAGER_CDB,	//TASK_PROCESS_MANAGER_CDB,
#endif
};


const K_TASKID taskConverterTable[NUM_OF_TASKS_IN_SYSTEM]=
{
	TASK_INVALID,					//TASK_KNL_TIMER_TICK,
	TASK_INVALID,					//TASK_KNL_TIMER_HIGH,
	TASK_INVALID,					//TASK_IPC_2,
	TASK_IPC,						//TASK_LINK_ADAPTATION,
	TASK_IPC,						//TASK_PAC_MANAGER,
	TASK_INVALID,					//TASK_KNL_TIMER_MID,
	TASK_INVALID,					//TASK_KNL_TIMER_LOW,
	TASK_UM_IF_TASK,				//TASK_UM_IF_TASK,
	TASK_BSS_MANAGE,				//TASK_BSS_MANAGE,
	TASK_TS_MANAGER,				//TASK_TS_MANAGER,
	TASK_QOS,						//TASK_QOS,
	TASK_ENCRYPTION,				//TASK_ENCRYPTION,
	TASK_LOGGER,					//TASK_LOGGER,
	TASK_IPC,						//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
	TASK_PTA,						//TASK_PTA,
#endif
#if defined (ENET_INC_ARCH_WAVE600)	
	TASK_IPC,						//TASK_DUT,
	TASK_IPC,						//TASK_INTERFERER_DETECTION,			
	TASK_IPC,						//TASK_COC,	
	TASK_IPC,						//TASK_HDK,
#else
	TASK_DUT,						//TASK_DUT,
	TASK_INTERFERER_DETECTION,		//TASK_INTERFERER_DETECTION,
	TASK_COC,						//TASK_COC,
	TASK_HDK,						//TASK_HDK,
#endif
	TASK_HIM,						//TASK_HIM,
	TASK_RX_MANAGER,				//TASK_RX_MANAGER,
	TASK_TX_MANAGER,				//TASK_TX_MANAGER,	
	TASK_BSS_MANAGER,				//TASK_BSS_MANAGER,
#if defined (ENET_INC_ARCH_WAVE600)	
	TASK_IPC,						//TASK_CHANNEL_SWITCH_MANAGER,
#else
	TASK_CHANNEL_SWITCH_MANAGER,	//TASK_CHANNEL_SWITCH_MANAGER,
#endif
#ifdef USE_AGER_EMULATOR
	TASK_AGER_EMULATOR, 			//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
	TASK_STATISTICS_MANAGER,		//TASK_STATISTICS_MANAGER,
#if defined (ENET_INC_ARCH_WAVE600)	
	TASK_IPC,						//TASK_PROCESS_MANAGER, 
#else
	TASK_PROCESS_MANAGER,			//TASK_PROCESS_MANAGER,
#endif	
	TASK_GROUP_MANAGER,				//TASK_GROUP_MANAGER,
	TASK_ATF,                       //TASK_ATF
#if defined (ENET_INC_ARCH_WAVE600)	
	TASK_HE_GROUP_MANAGER,			//TASK_HE_GROUP_MANAGER,
	TASK_PLAN_MANAGER,				//TASK_PLAN_MANAGER,
	TASK_TWT_MANAGER,               //TASK_TWT_MANAGER,
#endif
#if defined (ENET_INC_ARCH_WAVE600)	
	TASK_HDK_CDB_MANAGER,			//TASK_HDK_CDB_MANAGER,
#else
	TASK_IPC,						
#endif
#if defined(HDK_CDB_SUPPORT)
	TASK_PROCESS_MANAGER_CDB,		//TASK_PROCESS_MANAGER_CDB,
#endif	
};

#endif 



#if (defined ENET_INC_ARCH_WAVE600) && (defined ENET_INC_LMAC)

const TxApp_threadPeripheralInfo_t TxApp_threadPeripheralInfoArray[TX_APP_THRD_NUM] = //holds constant information about threads
{
	{&vIPC_2_TaskEntry,					TX_APP_QUEUE_SIZE_IPC,						TX_APP_STACK_SIZE_IPC , 					TX_APP_PRIORITY_IPC,					TX_APP_PREEMPT_THRSLD_IPC,						"ipc",			TASK_IPC},					/* TASK_IPC */
	{&LinkAdaptation_Task,			   	TX_APP_QUEUE_SIZE_LINK_ADAPTATION,		   	TX_APP_STACK_SIZE_LINK_ADAPTATION,		   	TX_APP_PRIORITY_LINK_ADAPTATION, 		TX_APP_PREEMPT_THRSLD_LINK_ADAPTATION,			"linkAdapt",	TASK_LINK_ADAPTATION},		/* TASK_LINK_ADAPTATION */
	{&PacManager_Task,			       	TX_APP_QUEUE_SIZE_PAC_MANAGER,		 	   	TX_APP_STACK_SIZE_PAC_MANAGER,		       	TX_APP_PRIORITY_PAC_MANAGER,			TX_APP_PREEMPT_THRSLD_PAC_MANAGER,				"PacMngr",		TASK_PAC_MANAGER}	,		/* TASK_PAC_MANAGER */
	{&InterfererDetection_TaskEntry,	TX_APP_QUEUE_SIZE_INTERFERER_DETECTION, 	TX_APP_STACK_SIZE_INTERFERER_DETECTION, 	TX_APP_PRIORITY_INTERFERER_DETECTION,	TX_APP_PREEMPT_THRSLD_INTERFERER_DETECTION,		"Interferer",	TASK_INTERFERER_DETECTION},	/*  TASK_INTERFERER_DETECTION */
	{&CoC_task, 						TX_APP_QUEUE_SIZE_COC,						TX_APP_STACK_SIZE_COC,						TX_APP_PRIORITY_COC,					  TX_APP_PREEMPT_THRSLD_COC,					  "coc",			TASK_COC},					   /*  TASK_COC */
	{&ProcessManager_TaskEntry, 		TX_APP_QUEUE_SIZE_PROCESS_MANAGER,			TX_APP_STACK_SIZE_PROCESS_MANAGER_BLOCK,	TX_APP_PRIORITY_PROCESS_MANAGER,		  TX_APP_PREEMPT_THRSLD_PROCESS_MANAGER,		  "ProcessMngr",	TASK_PROCESS_MANAGER},		   /*  TASK_PROCESS_MANAGER */		
	{&ChannelSwitchManager_TaskEntry,	TX_APP_QUEUE_SIZE_CHANNEL_SWITCH_MANAGER,	TX_APP_STACK_SIZE_CHANNEL_SWITCH_MANAGER,	TX_APP_PRIORITY_CHANNEL_SWITCH_MANAGER,   TX_APP_PREEMPT_THRSLD_CHANNEL_SWITCH_MANAGER,   "CSM",			TASK_CHANNEL_SWITCH_MANAGER},  /*  TASK_CHANNEL_SWITCH_MANAGER */
	{&HDK_Task, 						TX_APP_QUEUE_SIZE_HDK,						TX_APP_STACK_SIZE_HDK,						TX_APP_PRIORITY_HDK,					  TX_APP_PREEMPT_THRSLD_HDK,					  "HDK",			TASK_HDK},					   /*  Online Calibration scheduler SM task */
	{&Dut_Task, 						TX_APP_QUEUE_SIZE_DUT,						TX_APP_STACK_SIZE_DUT,						TX_APP_PRIORITY_DUT,					  TX_APP_PREEMPT_THRSLD_DUT,					  "Dut",			TASK_DUT},					   /*  TASK_DUT */		

#ifdef TX_APP_INCLUDE_MODULE_IDLE_COUNT
	{NULL,								TX_APP_QUEUE_SIZE_IDLE,						TX_APP_STACK_SIZE_IDLE,						TX_APP_PRIORITY_IDLE, 					TX_APP_PREEMPT_THRSLD_IDLE,			      		"Idle",			TASK_INVALID},				/*  TASK_LOGGER */		
#endif 
};
 																	
const TxApp_thread_e TxApp_translatationTableFromTaskIdToThreadId[NUM_OF_TASKS_IN_SYSTEM] = //holds translation from task to thread
{ 

	
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_TICK,
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_HIGH,
		TX_APP_THRD_IPC,					//TASK_IPC_2,
		TX_APP_THRD_LINK_ADAPTATION,		//TASK_LINK_ADAPTATION,
		TX_APP_THRD_PAC_MNGR,				//TASK_PAC_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_MID,
		TX_APP_THRD_NULL_VALUE,				//TASK_KNL_TIMER_LOW,
		TX_APP_THRD_NULL_VALUE,				//TASK_UM_IF_TASK,
		TX_APP_THRD_NULL_VALUE,				//TASK_BSS_MANAGE,
		TX_APP_THRD_NULL_VALUE,				//TASK_TS_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_QOS,
		TX_APP_THRD_NULL_VALUE,				//TASK_ENCRYPTION,
		TX_APP_THRD_NULL_VALUE,				//TASK_LOGGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
		TX_APP_THRD_NULL_VALUE, 			//TASK_PTA,
#endif		
		TX_APP_THRD_DUT,					//TASK_DUT,
		TX_APP_THRD_INTERFERER_DETECTION,	//TASK_INTERFERER_DETECTION,			
		TX_APP_THRD_CoC,					//TASK_COC,
		TX_APP_THRD_HDK,					//TASK_HDK,
		TX_APP_THRD_NULL_VALUE,				//TASK_HIM,
		TX_APP_THRD_NULL_VALUE,				//TASK_RX_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_TX_MANAGER,	
		TX_APP_THRD_NULL_VALUE,				//TASK_BSS_MANAGER,
		TX_APP_THRD_CHANNEL_SWITCH_MANAGER,	//TASK_CHANNEL_SWITCH_MANAGER,
#ifdef USE_AGER_EMULATOR
		TX_APP_THRD_NULL_VALUE,				//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
		TX_APP_THRD_NULL_VALUE,				//TASK_STATISTICS_MANAGER,
		TX_APP_THRD_PROCESS_MNGR,			//TASK_PROCESS_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_GROUP_MANAGER,
		TX_APP_THRD_NULL_VALUE,             //TASK_ATF
#if defined (ENET_INC_ARCH_WAVE600)	
		TX_APP_THRD_NULL_VALUE,				//TASK_HE_GROUP_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_PLAN_MANAGER,
		TX_APP_THRD_NULL_VALUE,				//TASK_TWT_MANAGER,
#endif
		TX_APP_THRD_NULL_VALUE, 			//TASK_HDK_CDB_MANAGER,
#if defined(HDK_CDB_SUPPORT)
		TX_APP_THRD_NULL_VALUE, 			//TASK_PROCESS_MANAGER_CDB,
#endif
};


const K_TASKID taskConverterTable[NUM_OF_TASKS_IN_SYSTEM]=
{
	TASK_INVALID,					//TASK_KNL_TIMER_TICK,
	TASK_INVALID,					//TASK_KNL_TIMER_HIGH,
	TASK_IPC_2,						//TASK_IPC_2,
	TASK_LINK_ADAPTATION,			//TASK_LINK_ADAPTATION,
	TASK_PAC_MANAGER,				//TASK_PAC_MANAGER,
	TASK_INVALID,					//TASK_KNL_TIMER_MID,
	TASK_INVALID,					//TASK_KNL_TIMER_LOW,
	TASK_IPC_2,						//TASK_UM_IF_TASK,
	TASK_IPC_2,						//TASK_BSS_MANAGE,
	TASK_IPC_2,						//TASK_TS_MANAGER,
	TASK_IPC_2,						//TASK_QOS,
	TASK_IPC_2,						//TASK_ENCRYPTION,
	TASK_IPC_2,						//TASK_LOGGER,
	TASK_INVALID,					//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
	TASK_IPC_2, 					//TASK_PTA,
#endif	
	TASK_DUT,						//TASK_DUT,
	TASK_INTERFERER_DETECTION,		//TASK_INTERFERER_DETECTION,			
	TASK_COC,						//TASK_COC,
	TASK_HDK,						//TASK_HDK,
	TASK_IPC_2,						//TASK_HIM,
	TASK_IPC_2,						//TASK_RX_MANAGER,
	TASK_IPC_2,						//TASK_TX_MANAGER,	
	TASK_IPC_2,						//TASK_BSS_MANAGER,
	TASK_CHANNEL_SWITCH_MANAGER,	//TASK_CHANNEL_SWITCH_MANAGER,
#ifdef USE_AGER_EMULATOR
	TASK_IPC_2, 					//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
	TASK_IPC_2,						//TASK_STATISTICS_MANAGER,
	TASK_PROCESS_MANAGER,			//TASK_PROCESS_MANAGER
	TASK_IPC_2,						//TASK_GROUP_MANAGER,
	TASK_IPC_2,             		//TASK_ATF
#if defined (ENET_INC_ARCH_WAVE600)	
	TASK_IPC_2,						//TASK_HE_GROUP_MANAGER,
	TASK_IPC_2,						//TASK_PLAN_MANAGER,
	TASK_IPC_2,						//TASK_TWT_MANAGER,
#endif
	TASK_IPC_2,						//TASK_HDK_CDB_MANAGER,
#if defined(HDK_CDB_SUPPORT)
	TASK_IPC_2,						//TASK_PROCESS_MANAGER_CDB,
#endif	
};


#endif 









