;/**************************************************************************/ 
;/*                                                                        */ 
;/*            Copyright (c) 1996-2015 by Express Logic Inc.               */
;/*                                                                        */ 
;/*  This software is copyrighted by and is the sole property of Express   */ 
;/*  Logic, Inc.  All rights, title, ownership, or other interests         */ 
;/*  in the software remain the property of Express Logic, Inc.  This      */ 
;/*  software may only be used in accordance with the corresponding        */ 
;/*  license agreement.  Any unauthorized use, duplication, transmission,  */ 
;/*  distribution, or disclosure of this software is expressly forbidden.  */ 
;/*                                                                        */
;/*  This Copyright notice may not be removed or modified without prior    */ 
;/*  written consent of Express Logic, Inc.                                */ 
;/*                                                                        */ 
;/*  Express Logic, Inc. reserves the right to modify this software        */ 
;/*  without notice.                                                       */ 
;/*                                                                        */ 
;/*  Express Logic, Inc.                     info@expresslogic.com         */
;/*  11423 West Bernardo Court               http://www.expresslogic.com   */
;/*  San Diego, CA  92127                                                  */
;/*                                                                        */
;/**************************************************************************/
;
;
;/**************************************************************************/
;/**************************************************************************/
;/**                                                                       */ 
;/** ThreadX Component                                                     */ 
;/**                                                                       */
;/**   Initialize                                                          */
;/**                                                                       */
;/**************************************************************************/
;/**************************************************************************/
;
;
;#define TX_SOURCE_CODE
;
;
;/* Include necessary system files.  */
;
;#include "tx_api.h"
;#include "tx_initialize.h"
;
;
;/**************************************************************************/ 
;/*                                                                        */ 
;/*  FUNCTION                                               RELEASE        */ 
;/*                                                                        */ 
;/*    _tx_initialize_fast_interrupt_setup               ARC_HS/MetaWare   */
;/*                                                           5.0          */
;/*  AUTHOR                                                                */ 
;/*                                                                        */ 
;/*    William E. Lamie, Express Logic, Inc.                               */ 
;/*                                                                        */ 
;/*  DESCRIPTION                                                           */ 
;/*                                                                        */ 
;/*    This function initializes register bank 1 for fast interrupt use.   */ 
;/*    The initialization includes setting the stack pointer to the value  */ 
;/*    supplied by the caller.                                             */ 
;/*                                                                        */ 
;/*  INPUT                                                                 */ 
;/*                                                                        */ 
;/*    stack_ptr                             Pointer to stack for bank 1   */
;/*                                                                        */ 
;/*  OUTPUT                                                                */ 
;/*                                                                        */ 
;/*    None                                                                */
;/*                                                                        */ 
;/*  CALLS                                                                 */ 
;/*                                                                        */ 
;/*    None                                                                */
;/*                                                                        */ 
;/*  CALLED BY                                                             */ 
;/*                                                                        */ 
;/*    Application                                                         */
;/*                                                                        */ 
;/*  RELEASE HISTORY                                                       */ 
;/*                                                                        */ 
;/*    DATE              NAME                      DESCRIPTION             */ 
;/*                                                                        */ 
;/*  10-10-2015     William E. Lamie         Initial version 5.0           */ 
;/*                                                                        */
;/**************************************************************************/
;VOID   _tx_initialize_fast_interrupt_setup(VOID *stack_ptr)
;{
    .global _tx_initialize_fast_interrupt_setup
    .type   _tx_initialize_fast_interrupt_setup, @function
_tx_initialize_fast_interrupt_setup:
;
;  /* Assume this routine is being called from initialization, with interrupts
;     disabled and from register bank 0. Also assume that the stack pointer 
;     input is valid, i.e., there is no error checking on the validity of
;     register_bank.  */
;
    sub     sp, sp, 8                                   ; Build a small stack frame to hold the setup information
    st      gp, [sp, 0]                                 ; Save gp in the frame
    st      r0, [sp, 4]                                 ; Save sp in the frame
    mov     ilink, sp                                   ; Move the stack frame into ilink
    mov     r1, 1                                       ; Select register bank 1
    asl     r2, r1, 16                                  ; Move the register bank bits over to proper location
    lr      r3, [status32]                              ; Pickup status32 register
    or      r3, r3, r2                                  ; Build new status32 register
    kflag   r3                                          ; Move to the hardware register bank
    mov     r0, ilink                                   ; Place stack pointer in r0
    ld      sp, [r0, 4]                                 ; Setup stack pointer for this hardware register bank
    mov     fp, 0                                       ; Setup fp
    ld      gp, [r0, 0]                                 ; Setup gp
    mov     blink, 0                                    ; Setup blink
    mov     r0, 0                                       ; Clear r0
    sub     sp, sp, 8                                   ; Reserve space for saving ilink and status32.p0 on thread preemption
    lr      r3, [status32]                              ; Pickup status32 register
    bclr    r3, r3, 16                                  ; Build register bank 0 value
    bclr    r3, r3, 17                                  ;
    bclr    r3, r3, 18                                  ;
    kflag   r3                                          ; Move back to register bank 0
    j_s.d   [blink]                                     ; Return to caller
    add     sp, sp, 8                                   ;
;}
    .end
