;/**************************************************************************/ 
;/*                                                                        */ 
;/*            Copyright (c) 1996-2015 by Express Logic Inc.               */
;/*                                                                        */ 
;/*  This software is copyrighted by and is the sole property of Express   */ 
;/*  Logic, Inc.  All rights, title, ownership, or other interests         */ 
;/*  in the software remain the property of Express Logic, Inc.  This      */ 
;/*  software may only be used in accordance with the corresponding        */ 
;/*  license agreement.  Any unauthorized use, duplication, transmission,  */ 
;/*  distribution, or disclosure of this software is expressly forbidden.  */ 
;/*                                                                        */
;/*  This Copyright notice may not be removed or modified without prior    */ 
;/*  written consent of Express Logic, Inc.                                */ 
;/*                                                                        */ 
;/*  Express Logic, Inc. reserves the right to modify this software        */ 
;/*  without notice.                                                       */ 
;/*                                                                        */ 
;/*  Express Logic, Inc.                     info@expresslogic.com         */
;/*  11423 West Bernardo Court               http://www.expresslogic.com   */
;/*  San Diego, CA  92127                                                  */
;/*                                                                        */
;/**************************************************************************/
;
;
;/**************************************************************************/
;/**************************************************************************/
;/**                                                                       */ 
;/** ThreadX Component                                                     */ 
;/**                                                                       */
;/**   Thread                                                              */
;/**                                                                       */
;/**************************************************************************/
;/**************************************************************************/
;
;
;#define TX_SOURCE_CODE
;
;
;/* Include necessary system files.  */
;
;#include "tx_api.h"
;#include "tx_thread.h"
;
;
;/**************************************************************************/ 
;/*                                                                        */ 
;/*  FUNCTION                                               RELEASE        */ 
;/*                                                                        */ 
;/*    _tx_thread_register_bank_assign                   ARC_HS/MetaWare   */
;/*                                                           5.0          */
;/*  AUTHOR                                                                */ 
;/*                                                                        */ 
;/*    William E. Lamie, Express Logic, Inc.                               */ 
;/*                                                                        */ 
;/*  DESCRIPTION                                                           */ 
;/*                                                                        */ 
;/*    This function builds a stack frame on the supplied thread's stack.  */
;/*    The stack frame results in a fake interrupt return to the supplied  */
;/*    function pointer.                                                   */ 
;/*                                                                        */ 
;/*  INPUT                                                                 */ 
;/*                                                                        */ 
;/*    thread_ptr                            Pointer to thread control blk */
;/*    register_bank                         Register bank number          */
;/*                                            (1 through max-1)           */ 
;/*                                                                        */ 
;/*  OUTPUT                                                                */ 
;/*                                                                        */ 
;/*    None                                                                */
;/*                                                                        */ 
;/*  CALLS                                                                 */ 
;/*                                                                        */ 
;/*    None                                                                */
;/*                                                                        */ 
;/*  CALLED BY                                                             */ 
;/*                                                                        */ 
;/*    Application                                                         */
;/*                                                                        */ 
;/*  RELEASE HISTORY                                                       */ 
;/*                                                                        */ 
;/*    DATE              NAME                      DESCRIPTION             */ 
;/*                                                                        */ 
;/*  10-10-2015     William E. Lamie         Initial version 5.0           */ 
;/*                                                                        */
;/**************************************************************************/
;VOID   _tx_thread_register_bank_assign(VOID *thread_ptr, UINT register_bank)
;{
    .global _tx_thread_register_bank_assign
    .type   _tx_thread_register_bank_assign, @function
_tx_thread_register_bank_assign:
;
;  /* Assume this routine is being called from initialization, with interrupts
;     disabled and from register bank 0. Also assume that the thread pointer and
;     register bank input is valid, i.e., there is no error checking on the validity of
;     the thread pointer or the register_bank.  
;
;     It is worth noting that if fast interrupts are being used, register bank 1 
;     is reserved for the fast interrupt processing, so thread register bank assignments
;     should begin at bank 2.  */
;
    mov     ilink, r0                                   ; Move the thread control block into ilink
    asl     r2, r1, 16                                  ; Move the register bank bits over to proper location
    lr      r3, [status32]                              ; Pickup status32 register
    or      r3, r3, r2                                  ; Build new status32 register
    ld      r4, [r0, 8]                                 ; Pickup stack pointer for the thread
    ld      r5, [r4, 164]                               ; Pickup initial status32 from stack area
    or      r5, r5, r2                                  ; Modify initial status32 with register bank number
    st      r5, [r4, 164]                               ; Store initial status32 in stack area
    kflag   r3                                          ; Move to the hardware register bank
    mov     r0, ilink                                   ; Place thread control block in r0


;	/* Change ARC HW Stack Check configuration to protect the stack of current thread.		*/
;	/* reg[KSTACK_TOP] = _tx_thread_current_ptr -> tx_thread_stack_start				*/
;	/* reg[KSTACK_BASE] = _tx_thread_current_ptr -> tx_thread_stack_end					*/


	lr      r3,[STATUS32]								; get current status32 register
	bclr_s  r3 ,r3, 14									; clear bit 14 (stack check enable)
	kflag	r3											; write status32 back (with bit 14 cleared)
	nop_s	
	ld		r5, [r0, 12]								; get tx_thread_stack_start
	sr		r5, [0x264]									; KSTACK_TOP = tx_thread_stack_start
	ld		r5, [r0, 16]								; get tx_thread_stack_end
	sr		r5, [0x265]									; KSTACK_BASE = tx_thread_stack_end 

    ld      sp, [r0, 8]                                 ; Setup stack pointer for this hardware register bank

	bset_s	r3, r3, 14									; set bit 14 (stack check enable)
	kflag	r3											; write status32 back (with bit 14 enabled)
	nop_s	
	
    ld      fp, [sp, 24]                                ; Setup fp
    ld      gp, [sp, 28]                                ; Setup gp
    ld      blink, [sp, 16]                             ; Setup blink
    ld      ilink, [sp, 20]                             ; Setup ilink
    lr      r3, [status32]                              ; Pickup status32 register
    bclr    r3, r3, 16                                  ; Build register bank 0 value
    bclr    r3, r3, 17                                  ;
    bclr    r3, r3, 18                                  ;
    kflag   r3                                          ; Move back to register bank 0
    mov     r5, 3                                       ; Build type for hardware interrupt context 
    j_s.d   [blink]                                     ; Return to caller
    st      r5, [r4, 0]                                 ; Set stack frame type
;}
    .end
