/*
	@file	sysdef.c

	@brief	Wave400 system wide definitions

	@date 11/2010

	@author Uri Shkolnik, Goeny Ltd

	<b> Copyright (c) 2009-2010 Goeny Ltd. </b>\n
	43 Hamelacha street, P.O. Box 8786, Poleg Industrial Park, Netanaya, ZIP 42505 Israel\n
	All rights reserved\n\n
	Proprietary rights of Goeny Ltd are involved in the
	subject matter of this material. All manufacturing, reproduction,
	use, and sales rights pertaining to this subject matter are governed
	by the license agreement. The recipient of this software implicitly
	accepts the terms of the license. This source code is the unpublished
	property and trade secret of Goeny Ltd.
	It is to be utilized solely under license from Goeny Ltd and it
	is to be maintained on a confidential basis for internal company use
	only. It is to be protected from disclosure to unauthorized parties,
	both within the Licensee company and outside, in a manner not less stringent
	than that utilized for Licensee's own proprietary internal information.
	No copies of the source or object code are to leave the premises of
	Licensee's business except in strict accordance with the license
	agreement signed by Licensee with Goeny Ltd.\n\n

	For more details - http://zoro-sw.com <or> http://goeny.com
	email: info@zoro-sw.com
*/


#ifndef __SYSDEF_H__
#define __SYSDEF_H__

#ifdef __cplusplus
extern "C" {
#endif

#define MS_TO_TICKS(ms) (ms/10)

#define TASK_TERM_MAX_WAIT_TICK	(100)

#define HW_CONFIGURATION_REG (0xA01800C0)

#if (VLSI_VERIFICATION == 1)

typedef union _HW_VALID_U_ {
	/** raw register data */
	uint32_t d32;
	/** register bits */
	struct {
		unsigned rom_exist :1;
		unsigned efuse_exist :1;
		unsigned eeprom_exist :1;
		unsigned sw_debug :1; // BIT 3
#define SW_DEBUG_BIT				3
		unsigned copy_to_ram_bypass :1; // BIT 4
	#define COPY_TO_RAM_BYPASS_BIT	4
		unsigned usb_desc_source : 2;
		unsigned usb_calib_source : 2;
		unsigned reserved: 22;
		unsigned sw_identification_done :1;
	} b;
} HW_VALID_UT;

#endif

#define BBCPU_REG_ADDR 			(0xA71C0020)
#define BBCPU_ROM_DBG_BIT		(BIT(3))


#ifdef __cplusplus
}
#endif

#endif /* __SYSDEF_H__ */
