/**
	@file	interrupt_eic.h

	@brief	External interrupt controller definitions and prototypes

	@date 10/2010

	@author Uri Shkolnik, Goeny Ltd

	<b> Copyright (c) 2009-2010 Goeny Ltd. </b>\n
	43 Hamelacha street, P.O. Box 8786, Poleg Industrial Park, Netanaya, ZIP 42505 Israel\n
	All rights reserved\n\n
	Proprietary rights of Goeny Ltd are involved in the
	subject matter of this material. All manufacturing, reproduction,
	use, and sales rights pertaining to this subject matter are governed
	by the license agreement. The recipient of this software implicitly
	accepts the terms of the license. This source code is the unpublished
	property and trade secret of Goeny Ltd.
	It is to be utilized solely under license from Goeny Ltd and it
	is to be maintained on a confidential basis for internal company use
	only. It is to be protected from disclosure to unauthorized parties,
	both within the Licensee company and outside, in a manner not less stringent
	than that utilized for Licensee's own proprietary internal information.
	No copies of the source or object code are to leave the premises of
	Licensee's business except in strict accordance with the license
	agreement signed by Licensee with Goeny Ltd.\n\n

	For more details - http://zoro-sw.com <or> http://goeny.com
	email: info@zoro-sw.com
*/

#ifndef __INT_EIC_H__
#define __INT_EIC_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "zr_common.h"

#define TOTAL_IRQ_NUM 32

// ISR pointers table
typedef void (*P_ISR)(void);
extern P_ISR irq_handlers[TOTAL_IRQ_NUM];


/* Input: Interrupt lines */
#define UNUSED_IRQ_NUM				0
#define INT_LINE_USB_CORE			3
#define INT_LINE_USB_RESUME			4


/* Output: Map IRQ number - these are the priorities of the IRQs (IPL), where 31 is the highest and 0 is lowest */
#define IRQ_MAP_USB					3




/*  External interrupt controller */

#define IRQ_EIC_REG_IRQ_ADDRESS		(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR + 0x140)
#define IRQ_EIC_IRQ_SS_ADDRESS		(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR + 0x144)
#define IRQ_EIC_MAP_BASE_ADDRESS	(UPPER_BBCPU_SYSTEM_IF_BASE_ADDR + 0x148)

#define IRQ_MAP_00	  				(EIC_IRQ_MAP_BASE_ADDRESS)
#define IRQ_MAP_01					(EIC_IRQ_MAP_BASE_ADDRESS + 0x4)
#define IRQ_MAP_02	   				(EIC_IRQ_MAP_BASE_ADDRESS + 0x8)
#define IRQ_MAP_03	   				(EIC_IRQ_MAP_BASE_ADDRESS + 0xc)
#define IRQ_MAP_04	   				(EIC_IRQ_MAP_BASE_ADDRESS + 0x10)
#define IRQ_MAP_05	   				(EIC_IRQ_MAP_BASE_ADDRESS + 0x14)
#define IRQ_MAP_06	   				(EIC_IRQ_MAP_BASE_ADDRESS + 0x18)
#define IRQ_MAP_REG_NUM				(7)
#define IRQ_LINE_PER_REG			(6)

#define IRQ_EIC_INT_MASK			(0x1F)
#define IRQ_EIC_INT_MASK_WIDTH		(5)

void intr_init(void);
void intr_enable_int(uint32 ic_line);
void intr_disable_int(uint32 ic_line);
int intr_eic_map_irq(uint32 ic_line, uint32 map_num);
int intr_register_isr(uint32 map_num, P_ISR isr_func);
void intr_enable_interrupts();
void intr_disable_interrupts();

/**
 * Register an NMI exception handler to be called immediately after the chip
 * resets.
 */
void register_nmi_handler(void (*handler)());

#ifdef __cplusplus
}
#endif

#endif /* __INT_EIC_H__ */
