#if 0

        mfc0    $10, $16, 1            /* # .word 0x400a8001 */
        nop
        /* # Isolate I$ Line Size */
        sll     $11, $10, 10
        srl     $11, 29

        /* # Skip ahead if No I$ */
        beq     $11, $0, no_icache
        nop
        li      $14, 2
        sllv    $11, $14, $11           /* # Now have true I$ line size in bytes */

        sll     $12, $10, 7
        srl     $12, 29
        li      $14, 64
        sllv    $12, $14, $12           /* # I$ Sets per way */

        sll     $13, $10, 13
        srl     $13, 29                 /* # I$ Assoc (-1) */
        add     $13, 1
        mul     $12, $12, $13           /* # Total number of sets */

        lui     $14, 0x8000             /* # Get a KSeg0 address for cacheops */

        /* # Clear TagLo/TagHi registers */
        mtc0    $0, $28
        mtc0    $0, $29
        mtc0    $0, $28, 2
        mtc0    $0, $29, 2

        move    $15, $12

        /* # Index Store Tag Cache Op */
        /* # Will invalidate the tag entry, clear the lock bit, and clear the LRF bit */
ic_clean_loop:    
        cache   0x8, 0($14)
        add     $15, -1                 /* # Decrement set counter */
        add     $14, $11                /* # Get next line address */
        bne     $15, $0, ic_clean_loop
        nop
		
#endif

#include "zr_common.h"

#pragma ghs section rodata=".const_rom"
#pragma ghs section text=".text_rom"
#pragma ghs nomips16

asm int __GetConfig1Reg( void )
{
%
	mfc0    $2, $16, 1
	nop
%error
}

asm void __SetCache( int s )
{
%reg s
	cache   0x8, s
    nop
%error
}


void invalidate_icache(void) {
	uint32 config1;
	uint32 val_11;
	uint32 val_12;
	uint32 val_13;
	uint32 val_14;
	uint32 i;

	// Get MIPS4KEc Config1 register, select 1
	config1 = __GetConfig1Reg();

	// I$ cache line size

	/* # Isolate I$ Line Size */
	val_11 = (config1 << 10) >> 29 ;
	/* # Skip ahead if No I$ */
	if (val_11 == 0)
			return;
	/* # Now have true I$ line size in bytes */
	val_11 = 2 << val_11;

	/* # I$ Sets per way */
	val_12 = (config1 << 7) >> 29 ;
	val_12 = 64 << val_12;

	/* # I$ Association (-1) */
	val_13 = ((config1 << 13) >> 29) + 1;
	val_13 = val_12 * val_13;

	val_14 = 0x80000000;

    /* # Index Store Tag Cache Op */
    /* # Will invalidate the tag entry, clear the lock bit, and clear the LRF bit */
	for (i = val_12 ; i != 0 ; i--)
	{
		__SetCache(val_14);
		val_14 = val_14 + val_11;
	}

}
		
#pragma ghs section
