/**
    @file    zr_memory.c

    @brief   Allocate/free memory implementation

    @date December, 2010

    @author Ishai Asa, Goeny Ltd

    <b> Copyright (c) 2009-2010 Goeny Ltd. </b>\n
    43 Hamelacha street, P.O. Box 8786, Poleg Industrial Park, Netanaya, ZIP 42505 Israel\n
    All rights reserved\n\n
    Proprietary rights of Goeny Ltd are involved in the
    subject matter of this material. All manufacturing, reproduction,
    use, and sales rights pertaining to this subject matter are governed
    by the license agreement. The recipient of this software implicitly
    accepts the terms of the license. This source code is the unpublished
    property and trade secret of Goeny Ltd.
    It is to be utilized solely under license from Goeny Ltd and it
    is to be maintained on a confidential basis for internal company use
    only. It is to be protected from disclosure to unauthorized parties,
    both within the Licensee company and outside, in a manner not less stringent
    than that utilized for Licensee's own proprietary internal information.
    No copies of the source or object code are to leave the premises of
    Licensee's business except in strict accordance with the license
    agreement signed by Licensee with Goeny Ltd.\n\n

    For more details - http://zoro-sw.com <or> http://goeny.com
    email: info@zoro-sw.com
*/
#include "tx_api.h"
#include "zr_memory.h"

extern char __ghsend_free_mem[], __ghsbegin_free_mem[];
extern char __ghssize_free_mem[];
extern char __ghs_ramend[];


TX_BYTE_POOL global_mem_pool;

void zr_memory_init(void)
{
	return;
}


void zr_memory_term(void)
{
	tx_byte_pool_delete(&global_mem_pool);
}


void *zr_malloc(size_t size)
{
	VOID *ptr;
	UINT ret = tx_byte_allocate(&global_mem_pool, &ptr, ALIGN_DWORD(size), TX_NO_WAIT);
	ZR_ASSERT(ret == TX_SUCCESS);
	if (ret != TX_SUCCESS)
		return NULL;

    return ptr;
}


void zr_free(void *ptr)
{
	UINT ret = tx_byte_release(ptr);
	ZR_ASSERT(ret == TX_SUCCESS);
}


uint32 zr_memory_available(void)
{
	ULONG available;
	tx_byte_pool_info_get(&global_mem_pool, NULL, &available,NULL, NULL, NULL, NULL);
	return (uint32)available;
}

void *zr_malloc_usb_master(size_t size)
{
	VOID *ptr;
	ptr = zr_malloc(size + (2 * (uint32)CACHE_WRITE_BURST_SIZE));
	if (ptr != NULL) {
		ptr = TO_UNCAC_PTR(ptr);
		ptr = (VOID *)((uint32)ptr + (uint32)CACHE_WRITE_BURST_SIZE);
	}
	return ptr;
}

void zr_free_usb_master(void *ptr) {
    void *real_ptr;

	real_ptr = (VOID *)((uint32)ptr - (uint32)CACHE_WRITE_BURST_SIZE);
	real_ptr = TO_CAC_PTR(real_ptr);
	zr_free(real_ptr);
}
