/*
 *                ThreadX C/C++ Library Support
 *
 *      Copyright 1983-2003 Green Hills Software,Inc.
 *
 *  This program is the property of Green Hills Software, Inc,
 *  its contents are proprietary information and no part of it
 *  is to be disclosed to anyone except employees of Green Hills
 *  Software, Inc., or as agreed in writing signed by the President
 *  of Green Hills Software, Inc.
 */

#ifndef _TX_GHS_H_
#define _TX_GHS_H_

#include <signal.h>
#include <stdio.h>
#include <time.h>
#include <setjmp.h>

typedef void (*SignalHandler)(int);

typedef struct
{
    int           Errno;                   /* errno.  */
    SignalHandler SignalHandlers[_SIGMAX]; /* signal() buffer.  */
    char          tmpnam_space[L_tmpnam];  /* tmpnam(NULL) buffer.  */
    char          asctime_buff[30];        /* .  */
    char          *strtok_saved_pos;       /* strtok() position.  */
    struct tm     gmtime_temp;             /* gmtime() and localtime() buffer.  */
    void          *__eh_globals;           /* Pointer for C++ exception handling.  */
} ThreadLocalStorage;

ThreadLocalStorage *GetThreadLocalStorage(void);

void __ghsLock(void);
void __ghsUnlock(void);

int  __ghs_SaveSignalContext(jmp_buf);
void __ghs_RestoreSignalContext(jmp_buf);

/* prototypes for FILE lock routines.  */
void __ghs_flock_file(void *);
void __ghs_funlock_file(void *);
int  __ghs_ftrylock_file(void *);
void __ghs_flock_create(void **);
void __ghs_flock_destroy(void *);

#endif /* _TX_GHS_H_ */
