/**
 * @file	DtAssert.c
 *
 * @brief	Assertion handler
 *
 * @date September, 2009
 * @author Uri Shkolnik, Zoro Software
 *
 * <b> Copyright (c) 2009 Zoro Software. </b>\n
 * P.O. Box 1607, Beit Yanay, Israel 40293. \n
 * All rights reserved\n\n
 * Proprietary rights of Zoro Software are involved in the
 * subject matter of this material. All manufacturing, reproduction,
 * use, and sales rights pertaining to this subject matter are governed
 * by the license agreement. The recipient of this software implicitly
 * accepts the terms of the license. This source code is the unpublished
 * property and trade secret of Zoro Software.
 * It is to be utilized solely under license from Zoro Software and it
 * is to be maintained on a confidential basis for internal company use
 * only. It is to be protected from disclosure to unauthorized parties,
 * both within the Licensee company and outside, in a manner not less stringent
 * than that utilized for Licensee's own proprietary internal information.
 * No copies of the source or object code are to leave the premises of
 * Licensee's business except in strict accordance with the license
 * agreement signed by Licensee with Zoro Software.\n\n
 *
 * For more details - http://zoro-sw.com
 * email: info@zoro-sw.com
 */

#include "zr_common.h"
 
#ifdef ZR_ASSERT_ACTIVE
 
#warning *******************************************************
#warning ** ZR_ASSERT_ACTIVE is defined, not for release mode **
#warning *******************************************************
 
/** Debug buffer */
#define DBG_BUF_SIZE (128)

void ZR_Assert(const char* Expression, const char* File, int Line) {
	uint8 buf[DBG_BUF_SIZE] = { 0 };
	uint32 head = 0;

	while ((head < DBG_BUF_SIZE) && *Expression != '\0') {
		buf[head] = *Expression;
		head++;
		Expression++;
	}

	while ((head < DBG_BUF_SIZE) && *File != '\0') {
		buf[head] = *File;
		head++;
		File++;
	}

	ZR_printf(buf, head);
	for (;;) {
		ZR_NOP;
	}
}

#else /* ZR_ASSERT_ACTIVE */
	void ZR_AssertStubFuncion(){}
#endif /* ZR_ASSERT_ACTIVE */
