/*! \addtogroup zoro_common_macros_group1
*  @{
*/

/**
 * @file	zr_macros.h
 *
 * @brief	Common macros
 *
 * @date September, 2009
 * @author Uri Shkolnik, Zoro Software
 *
 * <b> Copyright (c) 2009 Zoro Software. </b>\n
 * P.O. Box 1607, Beit Yanay, Israel 40293. \n
 * All rights reserved\n\n
 * Proprietary rights of Zoro Software are involved in the
 * subject matter of this material. All manufacturing, reproduction,
 * use, and sales rights pertaining to this subject matter are governed
 * by the license agreement. The recipient of this software implicitly
 * accepts the terms of the license. This source code is the unpublished
 * property and trade secret of Zoro Software.
 * It is to be utilized solely under license from Zoro Software and it
 * is to be maintained on a confidential basis for internal company use
 * only. It is to be protected from disclosure to unauthorized parties,
 * both within the Licensee company and outside, in a manner not less stringent
 * than that utilized for Licensee's own proprietary internal information.
 * No copies of the source or object code are to leave the premises of
 * Licensee's business except in strict accordance with the license
 * agreement signed by Licensee with Zoro Software.\n\n
 *
 * For more details - http://zoro-sw.com
 * email: info@zoro-sw.com
 */

#ifndef _ZR_MACROS_H_
#define _ZR_MACROS_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* Registers access */
#define	ADDR16(addr)	((volatile uint16 *) (addr))
#define	ADDR32(addr)	((volatile uint32 *) (addr))
#define	REG8(addr)		(*((volatile uint8 *) (addr)))
#define	REG16(addr)		(*((volatile uint16 *) (addr)))
#define	REG32(addr)		(*((volatile uint32 *) (addr)))

//! Minimum
#define MIN(a,b)    	(((a)<(b))?(a):(b))
//! Maximum
#define MAX(a,b)    	(((a)>(b))?(a):(b))
//! Absolute
#define ABS(x)			( (x>=0) ? (x) : (-1*(x)) )

//! Bit
#define BIT(BitOffset)      ((uint32)1 << (BitOffset))

//! Sets a bit in the pointed address
#define SET_BIT(pAddr,bitOffset)       (*(pAddr) |=  (1<<(bitOffset)))

//! Clears a bit in the pointed address
#define CLEAR_BIT(pAddr,bitOffset)     (*(pAddr) &= ~(1<<(bitOffset)))

//! Returns the value of a specific bit (0 or 1) shifted to bit zero
#define GET_BIT_VAL(pAddr,bitOffset)    ((*(pAddr) >> (bitOffset)) & 0x1)

/**
	Modify bit values in a register.  Using the
	algorithm:    (reg_contents & ~clear_mask) | set_mask
 */
#define REG32_MODIFY(addr, clear_mask, set_mask)	\
	(REG32(addr) = ( ( REG32(addr) & ~clear_mask ) | set_mask ))


//! Align to DWORD
#define ALIGN_DWORD(len) 		((len + 3)/4)*4

//! What is the build tool set inline?
#define ZR_INLINE	__inline
#define ZR_printf	printf
#define ZR_NOP		asm("nop")

#ifdef __cplusplus
}
#endif
#endif /* _ZR_MACROS_H_ */

/*! @} */
