/**
    @file    zr_timer.h

    @brief    Timer callback interface

    @date February, 2011

    @author Ishai Asa, Goeny Ltd

    <b> Copyright (c) 2009-2010 Goeny Ltd. </b>\n
    43 Hamelacha street, P.O. Box 8786, Poleg Industrial Park, Netanaya, ZIP 42505 Israel\n
    All rights reserved\n\n
    Proprietary rights of Goeny Ltd are involved in the
    subject matter of this material. All manufacturing, reproduction,
    use, and sales rights pertaining to this subject matter are governed
    by the license agreement. The recipient of this software implicitly
    accepts the terms of the license. This source code is the unpublished
    property and trade secret of Goeny Ltd.
    It is to be utilized solely under license from Goeny Ltd and it
    is to be maintained on a confidential basis for internal company use
    only. It is to be protected from disclosure to unauthorized parties,
    both within the Licensee company and outside, in a manner not less stringent
    than that utilized for Licensee's own proprietary internal information.
    No copies of the source or object code are to leave the premises of
    Licensee's business except in strict accordance with the license
    agreement signed by Licensee with Goeny Ltd.\n\n

    For more details - http://zoro-sw.com <or> http://goeny.com
    email: info@zoro-sw.com
*/

#ifndef __ZR_TIMER_H__
#define __ZR_TIMER_H__

#include "zr_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Registers a timer callback to be called on every system tick interrupt (10ms).
 * The callback may be NULL, which will disable calling the callback on timer INT.
 * The function is thread- and interrupt-safe.
 */
void register_timer_callback(patch_function timer_callback);

#ifdef __cplusplus
}
#endif

#endif /* __ZR_TIMER_H__ */
