/************************************************************************************
*	
*	File:		  TinyKernel_Api.h
*	Class/Module: 
*	Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef TINYKERNEL_API_H
#define TINYKERNEL_API_H

#include "System_GlobalDefinitions.h"


/****************************************************************************
 * Kernel Message Buffer
 ****************************************************************************/
typedef struct K_MSG_QUEUE
{
	K_MSG *psHead;
	K_MSG *psTail;
} K_MSG_QUEUE;


/****************************************************************************
 * Kernel State Machine Action
 ****************************************************************************/
typedef int32 K_TIME;

typedef void (*K_ACTION)(K_STATE*, K_MSG *);


/****************************************************************************
 * Kernel State Machine Transition
 ****************************************************************************/

typedef struct K_TRANS
{
	K_MSG_TYPE  tKMsgType;
	K_STATE	 bNextState;
	K_ACTION	rActionFunction;
} K_TRANS;

#define K_NULL_MSG		  (K_MSG_TYPE) 0
#define K_NULL_STATE		(K_STATE) 0xff
#define K_NULL_ROUTINE	  (K_ACTION) 0
#define K_NO_DATA					 0


/****************************************************************************
 * Kernel State Machine Handling
 ****************************************************************************/

void TinyKernel_StateMachine(const K_TRANS * const * psStateMachineTable,
						K_STATE * psStateData,
						K_MSG * psKernelMsg);
void	TinyKernel_InitQueue			( K_MSG_QUEUE *psQueue );
K_MSG	*TinyKernel_DequeueMsg			( K_MSG_QUEUE *psQueue);
bool	TinyKernel_IsQueueEmpty			( K_MSG_QUEUE *psQueue );
void	TinyKernel_QueueMsg				( K_MSG_QUEUE *psQueue, K_MSG *psMsg );
void	TinyKernel_InitPersistentMsg	(K_MSG *psMsg, K_LEN tK_LenLength);
void	TinyKernel_FreeMessage			(K_MSG *psMsg);
void 	TinyKernel_SendMessage(K_MSG_TYPE msgType, K_TASKID bTo, K_MSG *kMsg_p, uint8 vapId);
void	TinyKernel_IncMsgRefCount		(K_MSG * psMsg);
void	TinyKernel_DecMsgRefCount		(K_MSG * psMsg);
void	TinyKernel_SetMessageOriginator	(K_MSG *);
void	TinyKernel_GetMessageOriginator	(K_MSG *, K_TASKID *);
K_MSG	*TinyKernel_GetFastMessage		(K_LEN);
void	TinyKernel_StartScheduler		(void);
void	TinyKernel_InitMessages			(void);
void	TinyKernel_InitScheduler		(void);

#endif //TINYKERNEL_API_H

