/************************************************************************************
*	
*	File:		  TinyKernel_State.c
*	Class/Module: 
*	Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

/*************************************************************************/
/***						Include Files							  ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "TinyKernel_Api.h"
#include "TinyKernel_Scheduler.h"


/****************************************************************************
**
** NAME:		   TinyKernel_StateMachine
** 
** PARAMETERS:	 Pointers to state machine descriptor table, state machine
**				 state data and message to be actioned.
**
** RETURN VALUES:  none
**
** DESCRIPTION:	Generic state machine. Indexes into the task's state
**				 machine description table to access the current state
**				 table. Scans the state table looking for a match with
**				 the message. Sets the state to the new default state
**				 if not null, and executes the transition function if
**				 not null.
**
**
** DESIGN REF:	 
**
****************************************************************************/

void TinyKernel_StateMachine(const K_TRANS * const * psStateMachineTable
							,K_STATE * psStateData
							,K_MSG * psKernelMsg
							)
{
	/* Pointer to state table entry.									   */
	const K_TRANS * psStateTableEntry;
	
	/* Return if state machine not instatiated */
	if (*psStateData == K_NULL_STATE)
	{
		return;
	}

	/* Set pointer to start of the state table for the indicated state	 */
	psStateTableEntry = psStateMachineTable[*psStateData];

	/* Scan down the state table searching for the message to be actioned, */
	/* until either a match is found or the end of the table is reached.   */
	while((psStateTableEntry->tKMsgType != K_NULL_MSG) &&
		  (psStateTableEntry->tKMsgType != psKernelMsg->header.tKMsgType))
	{
		psStateTableEntry++;	
	}
	
	/* If the next state is not null, set the state						*/
	if (psStateTableEntry->bNextState != K_NULL_STATE)
	{
		OSAL_SET_STATE(psStateData, psStateTableEntry->bNextState);
	}
	
	/* If the transition function is not null, execute the function.	   */
	if (psStateTableEntry->rActionFunction != K_NULL_ROUTINE)
	{
		(*psStateTableEntry->rActionFunction)(psStateData, psKernelMsg);
	}
}
