/***********************************************************************************
 File:			TrainingManager_Api.h
 Module:		Group Id Management Action Frame Manager 
 Purpose: 		To handle Transmission of Group Id Management Action Frames
				for Multi-User MIMO transmissions
 Description:	
************************************************************************************/
#ifndef TRAINING_MANAGER_API_H_
#define TRAINING_MANAGER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Kmsg.h"
#include "HwGlobalDefinitions.h"
#include "SharedDbTypes.h"
#include "GroupManager_API.h"


//#define TRAININGMANAGER_DEBUG

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

typedef enum
{
	TRAINING_MANAGER_NDPA_STATUS_FAIL,
	TRAINING_MANAGER_NDPA_STATUS_SUCCESS,		
}	TrainingManagerNdpaCfmStatus_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct _TrainingManagerStaBitmap_t
{
	uint32 staBitmap[GROUP_MANAGER_SIZE_OF_STATION_BITMAP_IN_WORDS];
} TrainingManagerStaBitmap_t;


typedef struct _TrainingManagerLinkAdaptiveInfoCfm_t
{
	TrainingManagerStaBitmap_t activeStaBitmap;
#ifdef TRAINING_FIRST_PHASE_POOL
	Bandwidth_e maxWorkingBandwidth[HW_NUM_OF_VAPS];
#endif //TRAINING_FIRST_PHASE_POOL
} TrainingManagerLinkAdaptiveInfoCfm_t;


typedef struct _TrainingManagerNdpaCfm_t
{
       TrainingManagerNdpaCfmStatus_e status;
} TrainingManagerNdpaCfm_t;

typedef struct _TrainingManagerRemoveStaParams_t
{
       StaId staId;
} TrainingManagerRemoveStaParams_t;


typedef struct _TrainingManagerHaltStaParams_t
{
       StaId staId;
} TrainingManagerHaltStaParams_t;



typedef struct _TrainingManagerStopStaParams_t
{
       StaId staId;
} TrainingManagerStopStaParams_t;



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TrainingManagerStartTrainingReq(void);
void TrainingManagerStopTrainingReq(void);
void TrainingManagerAddStaReq(UMI_STA_ADD* pStaAdd);
void TrainingManagerRemoveStaReq(TrainingManagerRemoveStaParams_t* removeStaParams);
void TrainingManagerAddVapReq(K_MSG* trainingManagerMessage);
void TrainingManagerRemoveVapReq(K_MSG* trainingManagerMessage);
void TrainingManagerNdpaCfm(TrainingManagerNdpaCfm_t *ndpaCfmParams);
void TrainingManagerLaInfoCfm(K_MSG *trainingManagerMessage);
void TrainingManagerHaltStaReq(TrainingManagerHaltStaParams_t *haltStaParams);
void TrainingManagerStopStaReq(TrainingManagerStopStaParams_t *stopStaParams);
uint32* TrainingManagerGetStatisticsAddress(void);
void TrainingManager_Init(void);


#ifdef TRAINING_DEBUG_CLI

/*CLI APIs*/
void TrainingManagerSetGroupMarkWeights(uint8 phyThroughputWeight, uint8 numOfStationsWeight, uint8 numOfNstsWeight);
void TrainingManagerSetMinimalGroupMark(uint16 newMinimalGroupMark);

#endif //TRAINING_DEBUG_CLI

#ifdef TRAINING_FIRST_PHASE_POOL
void TrainingManagerSetMinimalMcsForFirstPhasePool(mcs_e minimalMcs);
void TrainingManagerSetMaximalNssForFirstPhasePool(SpatialStreamNum_e maximalNss);
#endif //TRAINING_FIRST_PHASE_POOL





#endif /* TRAINING_MANAGER_API_H_ */




