/***********************************************************************************
 File:		MuEffectiveRateDbRam.h
 Module:		Rx Classifier
 Purpose: 	Owner for all access to the Rx Classifier
 Description:	Rx Classifier Ram Description
************************************************************************************/
#ifndef MU_EFFECTIVE_RATE_RAM_H_
#define MU_EFFECTIVE_RATE_RAM_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"



/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/
#define MU_EFFECTIVE_RATE_DB_RAM_ADDR_OFFSET 			(0x1E000)
#define MU_EFFECTIVE_RATE_DB_RAM_NUM_ROWS 				(1024)

#define MU_EFFECTIVE_RATE_DB_INVALID_OUTPUT_VALUE 		(0xF)


/*---------------------------------------------------------------------------------
/							Data Type Definition												
/----------------------------------------------------------------------------------*/


/*This entry represents both input and output entries depends on when we use it. 
Before sending NDPA it will serve as input and after recieving BF results as output
Each entry is actually 19 bits, the higher bits are not exists and nothing will happen if will try to write there, 
the entries are aligned 32 bit (each entry starts from new word)
*/
typedef union
{
	uint32 val;
	struct
	{
		uint32 userStream0OrderIdx	:4;	//sta location in the training NDPA vector to check as Stream0
		uint32 userStream1OrderIdx	:4;	//sta location in the training NDPA vector to check as Stream1
		uint32 userStream2OrderIdx	:4;	//sta location in the training NDPA vector to check as Stream2
		uint32 userStream3OrderIdx	:4;	//sta location in the training NDPA vector to check as Stream3
		uint32 totalNsts			:2;	//total NSS for current group (tells which order indeces are valid)
		uint32 invalidEntry			:1; //do not check conbination if bit set
	} inputEntryBitFields;

	struct
	{
		uint32 userStream0EffectiveRate	:4; //MCS result for stream 0 (with 1 NSS)
		uint32 userStream1EffectiveRate	:4; //MCS result for stream 1 (with 1 NSS)
		uint32 userStream2EffectiveRate	:4;	//MCS result for stream 2 (with 1 NSS)
		uint32 userStream3EffectiveRate	:4; //MCS result for stream 3 (with 1 NSS)
		uint32 reserved					:3;		
	} outputEntryBitFields;
} MuEffectiveRateDbRamEntry_u;



typedef struct _MuEffectiveRateDbRam_t
{
	MuEffectiveRateDbRamEntry_u muEffectiveRateDbEntry[MU_EFFECTIVE_RATE_DB_RAM_NUM_ROWS];
} MuEffectiveRateDbRam_t;


#endif /* MU_EFFECTIVE_RATE_RAM_H_ */
