/***********************************************************************************
 File:			TsManager_API.h
 Module:		TS manager 
 Purpose: 		To handle opening/closing BA agreements and BA agreements packets
 Description:   This file is the API of the TS manager common part of the initiator
 				and recipient which is responsible of handling all external events 
 				and invoke the proper module (initiator or recipient)functions
************************************************************************************/
#ifndef TS_MANAGER_API_H_
#define TS_MANAGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"
#include "OSAL_Kmsg.h"//TBD check which include is needed 
#include "OSAL_Api.h" //TBD check which include is needed 
#include "frame.h"//TBD check which include is needed 
#include "PacketDescriptor.h"//TBD check which include is needed 
#include "database.h"//TBD check which include is needed 
#include "System_Timers.h"//TBD check which include is needed 
#include "StatisticsManager_api.h"
#include "ResourceManager_API.h"


/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/
#define TS_MANAGER_STA_DISCARD_BITMAP_SIZE	 ((CONVERT_BIT_INDEX_TO_WORDS(HW_NUM_OF_STATIONS - 1)) + 1)


#ifdef WORKAROUND_FOR_HW_BUG_IN_ADDBA_REQ_ENCRYPTED
#define PD_TYPE_ADDBA_REQ_ENC	(PD_TYPE_COLOR_SWITCH_ANNOUNCEMENT_ENC)
#endif



#ifdef ENET_INC_ARCH_WAVE600
#define TS_MANAGER_INITIATOR_PD_REQUEST_ID_WIDTH	(13)
#define TS_MANAGER_RECIPIENT_PD_REQUEST_ID_WIDTH	(13)
#define TS_MANAGER_INITIATOR_PD_OFFSET_WIDTH		(11)
#define TS_MANAGER_RM_REQUEST_SIZE					(13)
#else 
#define TS_MANAGER_INITIATOR_PD_REQUEST_ID_WIDTH	(11)
#define TS_MANAGER_RECIPIENT_PD_REQUEST_ID_WIDTH	(11)
#define TS_MANAGER_INITIATOR_PD_OFFSET_WIDTH		(8)
#define TS_MANAGER_RM_REQUEST_SIZE					(11)
#endif //ENET_INC_ARCH_WAVE600

#if (TS_MANAGER_INITIATOR_PD_REQUEST_ID_WIDTH != TS_MANAGER_RECIPIENT_PD_REQUEST_ID_WIDTH)
#error "TS_MANAGER_INITIATOR_PD_REQUEST_ID_WIDTH must be equal to TS_MANAGER_RECIPIENT_PD_REQUEST_ID_WIDTH"
#endif

/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/

typedef enum BaAgreementActionCode
{
	BA_AGREEMENT_ACTION_CODE_ADDBA_REQUEST = 0,
	BA_AGREEMENT_ACTION_CODE_ADDBA_RESPONSE = 1,
	BA_AGREEMENT_ACTION_CODE_DELBA = 2,
	BA_AGREEMENT_NUM_OF_ACTION_CODES,
	BA_AGREEMENT_MAX_NUM_OF_ACTION_CODES = MAX_UINT8
}BaAgreementActionCode_e; 

typedef enum BaAgreementDirection
{
	BA_AGREEMENT_DIRECTION_RECIPIENT = 0,
	BA_AGREEMENT_DIRECTION_INITIATOR = 1,
	BA_AGREEMENT_NUM_OF_DIRECTIONS,
	BA_AGREEMENT_MAX_NUM_OF_DIRECTIONS = MAX_UINT8
}BaAgreementDirection_e; 

typedef enum BaAgreementAllowedValues
{
	BA_AGREEMENT_ALLOWED_VALUE_NOT_ALLOWED = 0,
	BA_AGREEMENT_ALLOWED_VALUE_ALLOWED = 1,
	BA_AGREEMENT_NUM_OF_ALLOWED_VALUES,
	BA_AGREEMENT_MAX_NUM_OF_ALLOWED_VALUES = MAX_UINT8
}BaAgreementAllowedValues_e; 



typedef struct TsManagerPacketReceivedMessage
{
	Rd_t  *rxDescriptor;
}TsManagerPacketReceivedMessage_t;

typedef struct TsManagerActionPacketConfirmedMessage
{
	TxPd_t *packetDescriptor;
}TsManagerActionPacketConfirmedMessage_t;

typedef struct TsManagerBarConfirmedMessage
{
	TxPd_t *packetDescriptor;
}TsManagerBarConfirmedMessage_t;

typedef struct TsManagerBarStatusMessage
{
	
	uint32 pdOffset;
	uint8 isStatusAck;
	uint8 reserved[3];
}TsManagerBarStatusMessage_t;


typedef struct TsManagerDataPacketDiscardedMessage
{
	StaId stationId;
	uint8 tid;
	uint16 reserved;
}TsManagerDataPacketDiscardedMessage_t;

/*Message that aggregates Packet Discarded STAs in one message to prevent TS manager thread queue overflow
- e.g. when Ager discard list is handled*/
typedef struct TsManagerDataPacketDiscardedBitmapMessage
{
	uint8  tid;
	uint32 stationBitmap[TS_MANAGER_STA_DISCARD_BITMAP_SIZE];
}TsManagerDataPacketDiscardedBitmapMessage_t;


typedef struct TsManagerCloseTidMessage
{
	StaId stationId;
	uint8 tidsBitmap;
	uint8 initiator;
	uint8 reserved;
}TsManagerCloseTidMessage_t;

typedef struct TsManagerOpenTidsMessage
{
	StaId stationId;
	uint8 tidsBitmap;
	uint16 reserved;
}TsManagerOpenTidsMessage_t;

typedef struct TsManagerRecipientVapConfigurationParams
{
	uint8  amsduSupportPerTidArray[NUM_OF_TID];
	uint16  maxBufferSizePerTidArray[NUM_OF_TID];

	uint16 maxInactivityTimeout;
	uint16 maxBaAgreementsPerVap;
	
	uint8 maxBaAgreementsPerStation;
	uint8 reserved[3]; 
} TsManagerRecipientVapConfigurationParams_t;

typedef struct TsManagerInitiatorVapConfigurationParams
{
	uint8  amsduSupportPerTidArray[NUM_OF_TID];
	uint16  maxBufferSizePerTidArray[NUM_OF_TID];

	uint16 maxInactivityTimeout;
	uint16 maxBaAgreementsPerVap;
	
	uint16 addbaRequestTimeout;
	uint8 maxBaAgreementsPerStation;
	uint8 deleteBaAgreementOnInactivity; 
} TsManagerInitiatorVapConfigurationParams_t;

typedef struct TsManagerVapConfigurationParams
{
	TsManagerRecipientVapConfigurationParams_t recipientVapParameters;
	TsManagerInitiatorVapConfigurationParams_t initiatorVapParameters;
} TsManagerVapConfigurationParams_t;

typedef struct TsManagerAddbaParams_
{
	TsManPayload_t*	addbaPayload;
	uint32			payloadLength;
} TsManagerAddbaParams_t;



/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
void TsManager_Initialize(void);
void TsManager_PostInit(void);
void TsManager_SetTimer(void);
void TsManager_ConfigureVapParameters(uint8 vapIndex, TsManagerVapConfigurationParams_t *vapConfigurationParameters);
void TsManager_ChangeRecipientStationAllowed(StaId stationIndex, uint8 allowed);
void TsManager_CloseOrOpenStationBaAgreements(StaId stationIndex, uint8 direction, uint8 allowed);
#ifdef ENET_INC_ARCH_WAVE600
bool TsManager_IsStaHe(StaId staId);
uint16 TsManager_TsManagerRecipientGetMaxUlTids(StaId	staId); 
#endif //ENET_INC_ARCH_WAVE600

uint32* tsManagerGetInitiatorTidGlobalStatisticsAddress(void);
uint16* tsManagerGetInitiatorStationGlobalStatisticsAddress(void);
uint32* tsManagerGetRecipientTidGlobalStatisticsAddress(void);
uint16* tsManagerGetRecipientStationGlobalStatisticsAddress(void);



#endif /* TS_MANAGER_API_H_ */

