/***********************************************************************************
 File:			TsManager.h
 Module:		Ts Manager 
 Purpose: 		To handle BA agreements
 Description:	This file contains all definitions and the structures of the Ts manager  
 				which is responsible to configure the Ts manager recipeient and the 
 				Ts manager initiator
************************************************************************************/
#ifndef TS_MANAGER_H_
#define TS_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Kmsg.h"
#include "PacketDescriptor.h"
#include "TsManagerRecipient.h"
#include "TsManagerInitiator.h"
#include "TsManagerCommonDefinitions.h"
#include "CalendarWheel_Api.h"



//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define TS_MANAGER_NUMBER_OF_INITIATOR_AND_RECIPIENT_TIDS 16

#define TS_MANAGER_BUILD_RM_REQUEST(sid, tid, type) ((type << 10) | (sid << 3) | tid)
#define TS_MANAGER_RM_REQUEST_EXTRACT_SID(context)  ((context >> 3) & 0x7F)
#define TS_MANAGER_RM_REQUEST_EXTRACT_TID(context)  (context & 0x7)
#define TS_MANAGER_RM_REQUEST_EXTRACT_TYPE(context) (context >> 10)

#define TS_MANAGER_CONVERT_OFFSET_TO_PD(offset) (TsManagerPdBasePtr + (offset))
#define TS_MANAGER_CONVERT_PD_TO_OFFSET(packetDescriptor) (((uint32 *)(packetDescriptor)) - TsManagerPdBasePtr)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	TS_MANAGER_STATION_STATISTICS_EVENT_DELBA_WAS_RECEIVED_WITH_INVALID_TID,
	TS_MANAGER_NUM_OF_STATION_STATISTICS_EVENTS,
	TS_HANDLER_MAX_NUM_OF_STATION_STATISTICS_EVENT = 0xFF,	
} TsManagerStationStatisticsEvents_e;


typedef struct TsManagerGlobalDb
{
	bool enableBa;
	uint8 ppduTxModeNoAmpdu;
} TsManagerGlobalDb_t;

typedef enum 
{
	TS_MANAGER_RM_REQUEST_INITIATOR,
	TS_MANAGER_RM_REQUEST_RECIPIENT,
	TS_MANAGER_NUM_RM_REQUEST
} TsManagerRmType_e;

extern uint16 TsManagerBufferSizeToWindowSize[];
extern uint32 *TsManagerPdBasePtr;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void TsManager_TaskEntry(K_MSG *tsManagerMessage);
extern uint8 TsManagerConvertWinSizeToBufferSize(uint8 winSize);
void TsManager_TidMovedToIdleCallback(StaId stationIndex);
void TsManager_TransmitAddbaResponse(TsManagerRecipientStationTidParams_t *stationTidEntry, TxPd_t *pdPointer);
void TsManager_TransmitAddbaRequest(TsManagerInitiatorStationTidParams_t *stationTidEntry, TxPd_t *pdPointer, uint16 timeout);
void TsManager_TransmitDelba(TsManagerCommonParameters_t *stationTidEntry, TxPd_t *pdPointer);
void TsManager_TransmitBar(TsManagerCommonParameters_t *stationTidEntry, TxPd_t *pdPointer);
void TsManager_RemoveFromCalendarWheel (CalendarWheelParameters_t *calendarWheel, TsManagerCommonParameters_t *entry);
void TsManager_AddToCalendarWheel (CalendarWheelParameters_t *calendarWheel, TsManagerCommonParameters_t *entry, uint16 timeout);
void TsManager_RescheduleInCalendarWheel (CalendarWheelParameters_t *calendarWheel, TsManagerCommonParameters_t *entry, uint16 timeout);

#endif /* TS_MANAGER_H_ */

