/***********************************************************************************
 File:			TsManagerCommonDefinitions.h
 Module:		Ts Manager 
 Purpose: 		To handle BA agreements
 Description:	This file contains all common internal definitions of the Ts manager  
 				which is responsible to configure the Ts manager recipeient and the 
 				Ts manager initiator
************************************************************************************/
#ifndef TS_MANAGER_COMMON_DEFINITIONS_H_
#define TS_MANAGER_COMMON_DEFINITIONS_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "CalendarWheel_Api.h"
#include "TsManager_API.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
/* Calendar wheel definitions */
#define TS_MANAGER_CONVERT_TIME_UNITS_INTO_250_MILLISECONDS_UINTS(x) (((x)>>8) + 1)
#define TS_MANAGER_CONVERT_MILLISECONDS_INTO_250_MILLISECONDS_UNITS(x) ((x)/250)
#define TS_MANAGER_CONVERT_CALENDAR_WHEEL_UNITS_INTO_TIME_UINTS(x) ((x) << 8)
#define TS_MANAGER_MAX_INACTIVITY_TIMEOUT_IN_250_MILLISECONDS_UNITS 255
#define TS_MANAGER_CALENDAR_WHEEL_TIMER_IN_MILLISECONDS 250
#define TS_MANAGER_CALENDAR_WHEEL_SIZE 256
#define TS_MANAGER_CALENDAR_WHEEL_MAX_TIMEOUT (TS_MANAGER_CALENDAR_WHEEL_SIZE - 1)

/* ADDBA response status */
/*Internal status codes to hold it compressed*/
typedef enum {
	TS_MANAGER_SUCCESS_STATUS,
	TS_MANAGER_UNSPECIFIED_STATUS,
	TS_MANAGER_INVALID_PARAMETERS_STATUS,
	TS_MANAGER_NUM_STATUS
} TS_MANAGER_STATUS;

/*Standard Status code*/
#define TS_MANAGER_SUCCESS_STATUS_CODE 0
#define TS_MANAGER_UNSPECIFIED_STATUS_CODE 1
#define TS_MANAGER_REQUEST_DECLINED_STATUS_CODE 37
#define TS_MANAGER_INVALID_PARAMETERS_STATUS_CODE 38

/* DELBA reason */
/*Internal reason codes to hold it compressed*/
typedef enum
{
	TS_MANAGER_TIMEOUT_REASON,
	TS_MANAGER_END_BA_REASON,
	TS_MANAGER_UNKNOWN_BA_REASON,
	TS_MANAGER_NUM_REASON
} TS_MANAGER_REASON;

/*Standard Reason codes*/
#define TS_MANAGER_TIMEOUT_REASON_CODE 1
#define TS_MANAGER_END_BA_REASON_CODE 37
#define TS_MANAGER_UNKNOWN_BA_REASON_CODE 38

#define TS_MANAGER_CALENDAR_WHEEL_ENTRY_FREE  	 	(0)
#define TS_MANAGER_CALENDAR_WHEEL_ENTRY_ENQUEUED	(1)

typedef enum {
	TS_MANAGER_BUFFER_SIZE_2,
	TS_MANAGER_BUFFER_SIZE_4,
	TS_MANAGER_BUFFER_SIZE_8,
	TS_MANAGER_BUFFER_SIZE_16,
	TS_MANAGER_BUFFER_SIZE_32,
	TS_MANAGER_BUFFER_SIZE_64,
	TS_MANAGER_NUM_BUFFER_SIZE
} TS_MANAGER_BUFFER_SIZE;

#define TS_MANAGER_WINDOW_SIZE_2	2
#define TS_MANAGER_WINDOW_SIZE_4	4
#define TS_MANAGER_WINDOW_SIZE_8	8
#define TS_MANAGER_WINDOW_SIZE_16	16
#define TS_MANAGER_WINDOW_SIZE_32	32
#define TS_MANAGER_WINDOW_SIZE_64	64

#define TS_MANAGER_MAX_BUFFER_SIZE           TS_MANAGER_WINDOW_SIZE_64
#define TS_MANAGER_MIN_BUFFER_SIZE           TS_MANAGER_WINDOW_SIZE_2             /*Win size = 1 in RXPP means no BA Agreement!*/

#define TS_MANAGER_MAX_BA_AGREEMENT_RECIPIENT_DEFAULT_VALUE (HW_NUM_OF_STATIONS * NUM_TID)

#define TS_MANAGER_MAX_BA_AGREEMENT_INITIATOR_DEFAULT_VALUE (HW_NUM_OF_STATIONS * NUM_TID)

/*Value sent in ADDBA REQ & RSP to indicate infinite timeout*/
#define TS_MANAGER_INFINITE_TIMEOUT	0

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	TS_MANAGER_ENTRY_TYPE_RECIPIENT = 0,	
	TS_MANAGER_ENTRY_TYPE_INITIATOR,
	TS_MANAGER_NUM_OF_ENTRY_TYPE,
	TX_HANDLER_MAX_NUM_OF_ENTRY_TYPE = 0xFF,	
} TsManagerEntryType_e;

typedef struct TsManagerCommonParameters
{
	/* word 0 */
	CalendarWheelEntry_t calendarWheelEntry;
	
	/* word 1 */	
	uint32 stationId		:7;
	uint32 reason			:2;
	uint32 status 			:2;
	uint32 entryType		:1; 
	uint32 tid 				:3;
	uint32 amsduSupport		:1;
	uint32 allowed			:1;
	uint32 pbac				:1;
	uint32 entryState		:1;
	uint32 dialogToken		:8;
	uint32 bufferSize		:3;
	uint32 deleteBaAgreementOnInactivity :1;
	uint32 reserved			:1; 

	/* word 2 */	
	uint32 pdRequestId		:TS_MANAGER_INITIATOR_PD_REQUEST_ID_WIDTH; 
	uint32 pdOffset			:TS_MANAGER_INITIATOR_PD_OFFSET_WIDTH; //used only by initiator
	uint32 state			:5;   
	uint32 timeout			:8; 

}TsManagerCommonParameters_t;


#endif /* TS_MANAGER_COMMON_DEFINITIONS_H_ */



