/***********************************************************************************
 File:			TsManagerRecipient.h
 Module:		Ts Manager 
 Purpose: 		To handle BA agreements
 Description:	This file contains all definitions and the structures of the Ts manager recipient 
 				which is responsible of handling BA agreement from the recipient side
************************************************************************************/
#ifndef TS_MANAGER_RECIPIENT_H_
#define TS_MANAGER_RECIPIENT_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "RxDescriptor.h"
#include "PacketDescriptor.h"
#include "TsManagerCommonDefinitions.h"
#include "TsManager_API.h"
#include "frame.h"
#include "ieee80211.h"
#include "Statistics_Descriptors.h"
#include "StatisticsManager_api.h"



//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define TS_MANAGER_RECIPIENT_INVALID_REQUEST_ID		((1 << TS_MANAGER_RECIPIENT_PD_REQUEST_ID_WIDTH) - 1)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum
{
	TS_MANAGER_RECIPIENT_TID_STATE_IDLE = 0,
	TS_MANAGER_RECIPIENT_TID_STATE_CLOSED = 1,
	TS_MANAGER_RECIPIENT_TID_STATE_CLOSED_WAITING_FOR_MESSAGE_FROM_RESOURCE_MANAGER = 2,
	TS_MANAGER_RECIPIENT_TID_STATE_OPENING_WAITING_PD = 3,
	TS_MANAGER_RECIPIENT_TID_STATE_OPENING = 4,
	TS_MANAGER_RECIPIENT_TID_STATE_OPENED = 5,
	TS_MANAGER_RECIPIENT_TID_STATE_OPENED_SENDING = 6,
	TS_MANAGER_RECIPIENT_TID_STATE_OPENED_WAITING_PD = 7,
	TS_MANAGER_RECIPIENT_TID_STATE_CLOSING = 8,
	TS_MANAGER_RECIPIENT_TID_STATE_CLOSING_WAITING_PD_FOR_DELBA = 9,
	TS_MANAGER_RECIPIENT_TID_STATE_CLOSING_WAITING_PD_FOR_ADDBA_RESPONSE = 10,
	TS_MANAGER_RECIPIENT_TID_STATE_CLOSING_WAITING_FOR_CONFIRMATION_TO_SEND_DELBA = 11,
	TS_MANAGER_RECIPIENT_TID_STATE_REMOVING = 12,
	TS_MANAGER_RECIPIENT_NUM_OF_TID_STATES = 13,
	TS_HANDLER_RECIPIENT_MAX_NUM_OF_TID_STATES = 0xFF,	
} TsManagerRecipientTidState_e;

typedef enum
{
	TS_MANAGER_RECIPIENT_TID_EVENT_ADD_STA = 0,
	TS_MANAGER_RECIPIENT_TID_EVENT_REMOVE_STA,
	TS_MANAGER_RECIPIENT_TID_EVENT_ADDBA_REQ_RECEIVED,
	TS_MANAGER_RECIPIENT_TID_EVENT_DELBA_RECEIVED,
	TS_MANAGER_RECIPIENT_TID_EVENT_ADDBA_RSP_CONFIRMED,
	TS_MANAGER_RECIPIENT_TID_EVENT_DELBA_CONFIRMED,
	TS_MANAGER_RECIPIENT_TID_EVENT_BAR_RECEIVED,
	TS_MANAGER_RECIPIENT_TID_EVENT_ILLEGAL_PACKET,
	TS_MANAGER_RECIPIENT_TID_EVENT_PD_ALLOCATED,
	TS_MANAGER_RECIPIENT_TID_EVENT_TIMER,
	TS_MANAGER_RECIPIENT_TID_EVENT_CLOSE_TID,
	TS_MANAGER_RECIPIENT_NUM_OF_TID_EVENTS,
	TS_HANDLER_RECIPIENT_MAX_NUM_OF_TID_EVENTS = 0xFF,	
} TsManagerRecipientTidEvent_e;


typedef struct TsManagerRecipientStationTidParams
{
	/* word 0 - 2 */
	TsManagerCommonParameters_t commonPart;
}TsManagerRecipientStationTidParams_t;

typedef struct TsManagerRecipientVapParams
{
	uint8  amsduSupportPerTidArray[NUM_OF_TID];
	uint8  bufferSizePerTidArray[NUM_OF_TID];
	
	uint16 maxBaAgreementPerVap;
	uint16 openedBaAgreements;
	
	uint8  maxInactivityTimeout;
	uint8  maxBaAgreementsPerStation;
	uint16  reserved;
} TsManagerRecipientVapParams_t;

typedef struct TsManagerRecipientGlobalParams
{
	uint16 maxGlobalBaAgreements;
	uint16 numOfGlobalOpenBaAgreements;
} TsManagerRecipientGlobalParams_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TsManagerRecipient_Initialize(void);
void TsManagerRecipient_AddStation(StaId stationIndex, uint8 allowed, uint8 pbac);
void TsManagerRecipient_RemoveStation(StaId stationIndex);
void TsManagerRecipient_AddbaRequestReceived(StaId stationIndex, AddbaRequestFrame_t *addbaRequestFrame);
void TsManagerRecipient_DelbaReceived(StaId stationIndex, uint8 tid);
void TsManagerRecipient_BarReceived(Rd_t  *rxDescriptor);
void TsManagerRecipient_AddbaResponseConfirmation(TxPd_t *packetDescriptor);
void TsManagerRecipient_DelbaConfirmation(StaId stationIndex, uint8 tid);
void TsManagerRecipient_IlegalPacketReceived(K_MSG* psMsg);
void TsManagerRecipient_TimerExpired(void);
void TsManagerRecipient_PdAllocated(StaId stationIndex, uint8 tid, TxPd_t *packetDescriptor);
void TsManagerRecipient_CloseTids(StaId stationIndex, uint8 tidsBitmap);
void TsManagerRecipient_ConfigureVapParameters(uint8 vapIndex, TsManagerRecipientVapConfigurationParams_t *vapConfigurationParameters);

#endif /* TS_MANAGER_RECIPIENT_H_ */

