/***********************************************************************************
 File:			TsManager.h
 Module:		Ts Manager 
 Purpose: 		To handle BA agreements
 Description:	This file contains all definitions and the structures of the Ts manager  
 				which is responsible to configure the Ts manager recipeient and the 
 				Ts manager initiator
************************************************************************************/
#ifndef TS_MANAGER_H_
#define TS_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Kmsg.h"
#include "PacketDescriptor.h"
#include "TsManagerRecipient.h"
#include "TsManagerInitiator.h"
#include "TsManagerCommonDefinitions.h"
#include "CalendarWheel_Api.h"



//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define TS_MANAGER_NUMBER_OF_INITIATOR_AND_RECIPIENT_TIDS 16

#define TS_MANAGER_NON_HE_FRAGMENTED_MSDUS_ENABLED  0
#define TS_MANAGER_NON_HE_FRAGMENTED_MSDUS_DISABLED 1


#define TS_MANAGER_RM_REQUEST_TID_START_BIT			(0)
#define TS_MANAGER_RM_REQUEST_TID_FIELD_LENGTH		(3)
#define TS_MANAGER_RM_REQUEST_TID_FIELD_MASK		(0x7)

#define TS_MANAGER_RM_REQUEST_SID_START_BIT			(TS_MANAGER_RM_REQUEST_TID_START_BIT + TS_MANAGER_RM_REQUEST_TID_FIELD_LENGTH)
#define TS_MANAGER_RM_REQUEST_SID_FIELD_LENGTH		(9)
#define TS_MANAGER_RM_REQUEST_SID_FIELD_MASK		(0x1FF)

#define TS_MANAGER_RM_REQUEST_TYPE_START_BIT		(TS_MANAGER_RM_REQUEST_SID_START_BIT + TS_MANAGER_RM_REQUEST_SID_FIELD_LENGTH)
#define TS_MANAGER_RM_REQUEST_TYPE_FIELD_LENGTH		(1)
#define TS_MANAGER_RM_REQUEST_TYPE_FIELD_MASK		(0x1)

#define TS_MANAGER_RM_REQUEST_TOTAL_LENGTH			(TS_MANAGER_RM_REQUEST_TYPE_START_BIT + TS_MANAGER_RM_REQUEST_TYPE_FIELD_LENGTH)


#if (TS_MANAGER_RM_REQUEST_TOTAL_LENGTH > TS_MANAGER_RM_REQUEST_SIZE)
#error "TS_MANAGER_RM_REQUEST_SIZE must accomdate TS_MANAGER_RM_REQUEST_TOTAL_LENGTH"
#endif

#define TS_MANAGER_BUILD_RM_REQUEST(sid, tid, type) ((type << TS_MANAGER_RM_REQUEST_TYPE_START_BIT) | (sid << TS_MANAGER_RM_REQUEST_SID_START_BIT) | (tid << TS_MANAGER_RM_REQUEST_TID_START_BIT))
#define TS_MANAGER_RM_REQUEST_EXTRACT_SID(context)  ((context >> TS_MANAGER_RM_REQUEST_SID_START_BIT) & TS_MANAGER_RM_REQUEST_SID_FIELD_MASK) //bits 4:11 
#define TS_MANAGER_RM_REQUEST_EXTRACT_TID(context)  (context & TS_MANAGER_RM_REQUEST_TID_FIELD_MASK) //bits 0:2  
#define TS_MANAGER_RM_REQUEST_EXTRACT_TYPE(context) (context >> TS_MANAGER_RM_REQUEST_TYPE_START_BIT)// bit 12

#define TS_MANAGER_CONVERT_OFFSET_TO_PD(offset) (TsManagerPdBasePtr + (offset))
#define TS_MANAGER_CONVERT_PD_TO_OFFSET(packetDescriptor) (((uint32 *)(packetDescriptor)) - TsManagerPdBasePtr)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	TS_MANAGER_STATION_STATISTICS_EVENT_DELBA_WAS_RECEIVED_WITH_INVALID_TID,
	TS_MANAGER_NUM_OF_STATION_STATISTICS_EVENTS,
	TS_HANDLER_MAX_NUM_OF_STATION_STATISTICS_EVENT = 0xFF,	
} TsManagerStationStatisticsEvents_e;


typedef struct TsManagerGlobalDb
{
	bool enableBa;
	uint8 ppduTxModeNoAmpdu;
} TsManagerGlobalDb_t;

typedef enum 
{
	TS_MANAGER_RM_REQUEST_INITIATOR,
	TS_MANAGER_RM_REQUEST_RECIPIENT,
	TS_MANAGER_NUM_RM_REQUEST
} TsManagerRmType_e;

extern uint16 TsManagerBufferSizeToWindowSize[];
extern uint16 TsManagerBufferSizeToMaxTidInHeMuAgg[];
extern uint32 *TsManagerPdBasePtr;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void TsManager_TaskEntry(K_MSG *tsManagerMessage);
extern uint8 TsManagerConvertWinSizeToBufferSize(uint16 winSize);
void TsManager_TidMovedToIdleCallback(StaId stationIndex);
void TsManager_TransmitAddbaResponse(TsManagerRecipientStationTidParams_t *stationTidEntry, TxPd_t *pdPointer);
void TsManager_TransmitAddbaRequest(TsManagerInitiatorStationTidParams_t *stationTidEntry, TxPd_t *pdPointer, uint16 timeout);
void TsManager_TransmitDelba(TsManagerCommonParameters_t *stationTidEntry, TxPd_t *pdPointer);
void TsManager_TransmitBar(TsManagerCommonParameters_t *stationTidEntry, TxPd_t *pdPointer);
void TsManager_RemoveFromCalendarWheel (CalendarWheelParameters_t *calendarWheel, TsManagerCommonParameters_t *entry);
void TsManager_AddToCalendarWheel (CalendarWheelParameters_t *calendarWheel, TsManagerCommonParameters_t *entry, uint16 timeout);
void TsManager_RescheduleInCalendarWheel (CalendarWheelParameters_t *calendarWheel, TsManagerCommonParameters_t *entry, uint16 timeout);

#endif /* TS_MANAGER_H_ */

