/***********************************************************************************
 File:			TwtManager_API.h
 Module:		TWT manager 
 Purpose: 		To manage the TWT operation
 Description:   This file is the API of the TWT manager which is responsible of 
 				managing the TWT operation
************************************************************************************/
#ifndef TWT_MANAGER_API_H_
#define TWT_MANAGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "SharedDbTypes.h"
#include "System_Configuration.h"
#include "HwGlobalDefinitions.h"
#include "Rd_Descriptors.h"
#include "Statistics_Descriptors.h"

/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/

		
/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/
typedef struct _TwtManagerPacketReceivedMessage_t
{
    Rd_t*              rxDescriptor;
    TwtFramePayload_t* framePayload;
    StaId              stationId;  
} TwtManagerPacketReceivedMessage_t;


typedef struct _TwtManagerPacketConfirmedMessage_t
{
    TxPd_t* pd;   
} TwtManagerPacketConfirmedMessage_t;

typedef enum 
{
	TWT_AGREEMENT_TYPE_NONE,
	TWT_AGREEMENT_TYPE_INDIVIDUAL,
	TWT_AGREEMENT_TYPE_BROADCAST
} twtAgreementType_e;

typedef struct _twtOperation_t
{
	bool	isImplicit;
	bool	isAnnounced;
	bool	isTriggerEnabled;
} twtOperation_t;

typedef struct _twtStaIndividualParameters_t
{
	uint64    			wakeTime;
    uint32    			wakeInterval;
    uint16   			minWakeDuration;
	uint8				channel;
} twtStaIndividualParameters_t;

typedef struct _twtStaBroadcastParameters_t
{
    uint8    			targetBeacon;
    uint8   			listenInterval;
} twtStaBroadcastParameters_t;

typedef struct _twtStaParams_t
{
	twtAgreementType_e 	agreementType;
	twtOperation_t 		operation;
	union 
	{
		twtStaIndividualParameters_t individual;
		twtStaBroadcastParameters_t  broadcast;
	} agreement;
} twtStaParams_t;

/*---------------------------------------------------------------------------------
/						externals			
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
void TwtManager_Initialize(void);
void SpAvailabilityManager_Initialize(void);
void TwtManager_PostInit(void);
void TwtManager_TwtGetStaParameters(twtStaParams_t *twtParams, uint16 StaId);
void TwtManager_TwtGetDefaultParameters(twtStaParams_t *twtParams);



#endif /* TWT_MANAGER_API_H_ */

