/***********************************************************************************
 File:			TwtManager.h
 Module:		TWT Manager
 Purpose: 		
 Description:	This file contains all definitions and the structures of the TwtManager 
 			
************************************************************************************/
#ifndef TWT_MANAGER_H_
#define TWT_MANAGER_H_

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

#define TWT_MAX_AGREEMENTS_ALLOWED                              1 // for phase 0 only 1 agreement allowed

typedef enum
{
    TWT_MANAGER_FLOW_TYPE_ANNOUNCED   = 0,
    TWT_MANAGER_FLOW_TYPE_UNANNOUNCED = 1,   
} TwtManagerFlowType_e;

#ifdef TWT_SELECTOR_WORKAROUND
typedef struct _TwtCountRamRow_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 highLimit   : 19; //bits [0..18]
			uint32 lowLimitLsb : 13; //bits [19..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 lowLimitMsb : 6;  //bits [0..5]
			uint32 counter     : 20; //bits [6..25]
			uint32 highPhase   : 1;  //bit [26]
			uint32 rsvd0       : 5;  //bits [27..31]
		};
	};
} TwtCountRamRow_t;
#endif //TWT_SELECTOR_WORKAROUND


#endif 
