/***********************************************************************************
 File:			TxHandler_Api.h
 Module:		Tx Handler 
 Purpose: 		To create a Tx handler drivers which manage the transmission procedure
 Description:   This file is the API of the Tx handler modules 
				which are responsible of the transmission procedure.
************************************************************************************/
#ifndef TX_HANDLER_API_H_
#define TX_HANDLER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "ShramTxHandlerTimingParams.h"
#include "mhi_umi.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	TX_HANDLER_CTS_RESULT_NOT_VALID = 0,
	TX_HANDLER_CTS_RESULT_SUCCESS   = 1,
	TX_HANDLER_CTS_RESULT_FAIL      = 2,
	TX_HANDLER_CTS_NUM_OF_RESULTS,
	TX_HANDLER_CTS_MAX_NUM_OF_RESULTS = 0xFF,	
} TxHandlerCtsResultInformation_e;

typedef enum
{
	TX_HANDLER_TRANSMISSION_RESULT_NOT_VALID = 0,
	TX_HANDLER_TRANSMISSION_RESULT_SUCCESS   = 1,
	TX_HANDLER_TRANSMISSION_RESULT_FAIL      = 2,
	TX_HANDLER_TRANSMISSION_RESULT_MULTICAST = 3,
	TX_HANDLER_TRANSMISSION_NUM_OF_RESULTS,
	TX_HANDLER_TRANSMISSION_MAX_NUM_OF_RESULTS = 0xFF,
} TxHandlerTransmissionResultInformation_e;



typedef struct TxHandlerUnfreezeParams
{
	uint8 isCtsInformationValid;
	uint8 isTxResultValid;
	uint8 isLongPacket;
	TxHandlerCtsResultInformation_e ctsInformation;
	TxHandlerTransmissionResultInformation_e transmissionInformation;
} TxHandlerUnfreezeParams_t;

typedef struct TxHandlerVapTimingParams
{
	uint8 minimumContentionWindow;
	uint8 maximumContentionWindow;
	uint8 aifsn;
} TxHandlerVapTimingParams_t;





//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TxHandler_Initialize(void);
void TxHandler_UpdateVapTimingParameters(UMI_SET_WMM_PARAMETERS* setWmmMessageParameters);
void TxHandler_UpdateVapAcTimingParameters(uint8 vapId, uint8 ac ,TxHandlerVapTimingParams_t *configurationTimingParams);
void TxHandler_DisableTxh(void);
void TxHandler_Unfreeze (TxHandlerUnfreezeParams_t *unfreezeParams);

#ifndef ENET_INC_ARCH_WAVE600 
void TxHandlerNtd_DisableAutoResponses(uint8 line);
void TxHandlerNtd_DisableAllAutoResponses(void);
void TxHandlerNtd_EnableAutoResponsesInitMode(void);
#endif

#ifdef ENET_INC_LMAC
void TxHandler_SetVapAcTimingParameters(uint8 vapId, uint8 ac ,HwAcTimingParams_t *hwTimingParams_p);
void TxHandler_GetVapAcTimingParameters(uint8 vapId, uint8 ac, HwAcTimingParams_t *hwTimingParams_p);
#endif //ENET_INC_LMAC


#endif /* TX_HANDLER_API_H_ */

