/***********************************************************************************
 File:			TxHandlerMap.h
 Module:		Tx Handler 
 Purpose: 		To create Tx handler drivers which manage the transmission procedure
 Description:	This file contains all definitions and the structures of the Tx handler Map 
 				module which is responsible of managing the transmission procedure.
************************************************************************************/
#ifndef TX_HANDLER_MAP_H_
#define TX_HANDLER_MAP_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define TX_HANDLER_MAP_EPSILON_VALUE_IN_NS 	(500)
#define TX_HANDLER_MAP_CONTROL_ENABLE_ALL (0x3F)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TxHandlerMap_Initialize(void);


#endif /* TX_HANDLER_MAP_H_ */

