/***********************************************************************************
 File:			TxHanlderNtd.h
 Module:		Tx Handler 
 Purpose: 		To create Tx handler drivers which manage the transmission procedure
 Description:	This file contains all definitions and the structures of the Tx handler 
 				NTD module which is responsible of the transmission decision.
************************************************************************************/
#ifndef TX_HANDLER_NTD_H_
#define TX_HANDLER_NTD_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "Pac_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define NTD_TCS_ACK_INDEX 0x0
#define NTD_TCS_CTS_INDEX 0x1
#define NTD_TCS_BA_INDEX  0x2
#define NTD_TCS_BF_INDEX  0x3
#define NTD_TCS_ENABLE 0x8
#define NTD_TCS_ENTRY_SHIFT 2
#define NTD_TCS_RXD_LINE_MASK 0x7

#define NTD_TCS_ACK (NTD_TCS_ACK_INDEX | NTD_TCS_ENABLE)
#define NTD_TCS_CTS (NTD_TCS_CTS_INDEX | NTD_TCS_ENABLE)
#define NTD_TCS_BA  (NTD_TCS_BA_INDEX | NTD_TCS_ENABLE)
#define NTD_TCS_BF  (NTD_TCS_BF_INDEX | NTD_TCS_ENABLE)

/* there are 4 registers with 8 entris each. each entry is 4 bits. the code here calculate the location of each line in the RXD
   in the register : (line number modulo 8 )* 4 is equal to the number of starting bit of the entry. for example line 18 -> 18 module 8
   is 2.  2*4 (== (2<<2)) is 8 -> starting bit is 8 */
/* Register 0 */

/* register 0 */
#define NTD_ERR_CAT_ACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER  ((RCD_ERR_CAT_ACK & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)

/* Register 1 */
#define NTD_RTS_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER          ((RCD_RTS 	  & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_PS_POLL_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER      ((RCD_PSPOLL   & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_BAR_BACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER     ((RCD_BAR_BACK & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_BAR_ACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER      ((RCD_BAR_ACK  & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_NDP_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER          ((RCD_NDP      & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_BFPOLL_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER       ((RCD_BFPOLL   & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)


/* Register 2 */
#define NTD_UQDN_ACK_AGG_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER ((RCD_UQDN_ACK_AGG & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_UQDN_ACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER     ((RCD_UQDN_ACK & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_DATA_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER         ((RCD_UDATA & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_PROBE_RSP_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER    ((RCD_PROBE_RESPONSE & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)

/* Register 3 */
#define NTD_ACTION_LAST_IN_AGGR_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER ((RCD_ACTION_LAST_IN_AGG & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)
#define NTD_MGMT_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER                ((RCD_UMGMT & NTD_TCS_RXD_LINE_MASK) << NTD_TCS_ENTRY_SHIFT)

/* Register 4 */
/* Currently empty */


/* Configuration of lines */
#define NTD_AUTO_RESPONSE_RXD_LINES_0_TO_7_INIT_VALUE  (NTD_TCS_BA << NTD_ERR_CAT_ACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER)

#define NTD_AUTO_RESPONSE_RXD_LINES_8_TO_15_INIT_VALUE ((NTD_TCS_CTS << NTD_RTS_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
														(NTD_TCS_ACK << NTD_PS_POLL_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
													   	(NTD_TCS_BA  << NTD_BAR_BACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
													   	(NTD_TCS_ACK << NTD_BAR_ACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
													   	(NTD_TCS_BF  << NTD_NDP_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
													   	(NTD_TCS_BF  << NTD_BFPOLL_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER))
													   
 
#define NTD_AUTO_RESPONSE_RXD_LINES_16_TO_23_INIT_VALUE	((NTD_TCS_BA  << NTD_UQDN_ACK_AGG_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
														 (NTD_TCS_ACK << NTD_UQDN_ACK_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
														 (NTD_TCS_ACK << NTD_DATA_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
														 (NTD_TCS_ACK << NTD_PROBE_RSP_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER))

#define NTD_AUTO_RESPONSE_RXD_LINES_24_TO_31_INIT_VALUE ((NTD_TCS_BA  << NTD_ACTION_LAST_IN_AGGR_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER) | \
														  (NTD_TCS_ACK << NTD_MGMT_EVENT_LINE_LOCATION_IN_AUTO_RESPONSE_REGISTER))

#define NTD_AUTO_RESPONSE_RXD_LINES_32_TO_33_INIT_VALUE (0)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TxHandlerNtd_Initialize(void);


#endif /* TX_HANDLER_NTD_H_ */

