/***********************************************************************************
 File:			TxHanlderManager.c
 Module:		Tx Handler 
 Purpose: 		To create a Tx handler drivers which manage the transmission procedure
 Description:   This file is the implementation of the Tx handler manager 	which is responsible of the access
 				to the TXH modules which are responsibleof the transmission procedure.
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "TxHandler_Api.h"
#include "ShramTxHandlerTimingParams.h"
#include "TxHandlerMap.h"
#include "TxHandlerTxc.h"
#include "TxHandlerNtd.h"




/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_TX_HANDLER 
#define LOG_LOCAL_FID 0

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/


/**********************************************************************************

TxHandler_Initialize 


Description:
------------
initialize internal structures and registers of the Tx handler modules whose values are known in initialization

Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void TxHandler_Initialize(void)
{
	TxHandlerMap_Initialize();
	TxHandlerTxc_Initialize();
	TxHandlerNtd_Initialize();
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

