/***********************************************************************************
 File:			TxHandlerTxc.C
 Module:		Tx Handler 
 Purpose: 		To create Tx handler drivers which manage the transmission procedure
 Description:	This file is the implementation of the Tx handler Txc module 
				which is responsible of the transmission timing management.
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "TxHandler_Api.h"
#include "Pac_Api.h"
#include "TxHandlerTxc.h"
#include "RegAccess_Api.h"
#include "TxhTxcRegs.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_TX_HANDLER 
#define LOG_LOCAL_FID 3

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

TxHandlerTxc_Initialize 


Description:
------------
initialize internal structures and parameters of the Tx handler TXC 
Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void TxHandlerTxc_Initialize(void)
{
 	RegTxhTxcTxhTxcEnable_u enableReg;
	RegTxhTxcErrorIfs1_u  eifs11bReg;
	RegTxhTxcErrorIfs2_u  eifs11AgAnd11nReg;
	RegTxhTxcErrorIfs3_u  eifs11AcReg;
	RegTxhTxcSifsElement_u sifsElementReg;

	enableReg.val = 0;
	eifs11bReg.val = 0;
	eifs11AgAnd11nReg.val = 0;
	eifs11AcReg.val = 0;
	sifsElementReg.val = 0;

	/*	EIFS (EDCA) = aSIFSTime + AIFSN[AC] * aSlotTime + aSIFSTime + ACKTxTime = 2 * aSIFSTime + AIFSN[AC] * aSlotTime + ACKTxTime

							Sifs Time	Ack Time	Total	Reg Value
		=============================================================
		errorIfs11BShort	10			304 		314 	2512
		errorIfs11BLong		10			152 		162 	1296
		errorIfs11Ag		16			44			60		480
		errorIfs11N			16			44			60		480
		errorIfs11Ac		16			44			60		480

		One SIFS is counted is counted anyway after Rx 
		AIFSN[AC] * aSlotTime is counted by TXH 
		Reg Value = aSIFSTime  + ACKTxTime
		According to SAS  3.17.2.2.1 TXH-TXC configuration:
	*/
	eifs11bReg.bitFields.errorIfs11BShort = 2512;
	eifs11bReg.bitFields.errorIfs11BLong = 1296;
	RegAccess_Write(REG_TXH_TXC_ERROR_IFS1, eifs11bReg.val);

	eifs11AgAnd11nReg.bitFields.errorIfs11Ag = 480;
	eifs11AgAnd11nReg.bitFields.errorIfs11N = 480;
	RegAccess_Write(REG_TXH_TXC_ERROR_IFS2, eifs11AgAnd11nReg.val);

	eifs11AcReg.bitFields.errorIfs11Ac = 480;
	RegAccess_Write(REG_TXH_TXC_ERROR_IFS3, eifs11AcReg.val);

	/* This is the time (in resolution of 1/8 microseconds) which the TXC needs to count in order to complete to SIFS */
	sifsElementReg.bitFields.sifsElement = Pac_GetHwDelays(PAC_DELAY_TXC_SIFS_ELEMENT);
	RegAccess_Write(REG_TXH_TXC_SIFS_ELEMENT, sifsElementReg.val);
	
	enableReg.bitFields.txhTxcEnable = TRUE;
	RegAccess_Write(REG_TXH_TXC_TXH_TXC_ENABLE, enableReg.val);//should be fixed 
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


