/***********************************************************************************
 File:			TxHandlerTxc.C
 Module:		Tx Handler 
 Purpose: 		To create Tx handler drivers which manage the transmission procedure
 Description:	This file is the implementation of the Tx handler Txc module 
				which is responsible of the transmission timing management.
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "TxHandler_Api.h"
#include "Pac_Api.h"
#include "TxHandlerTxc.h"
#include "RegAccess_Api.h"
#include "TxhTxcRegs.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_TX_HANDLER 
#define LOG_LOCAL_FID 7

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

TxHandlerTxc_Initialize 


Description:
------------
initialize internal structures and parameters of the Tx handler TXC 
Input:
-----
	
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void TxHandlerTxc_Initialize(void)
{
 	RegTxhTxcTxhTxcEnable_u enableReg;
	RegTxhTxcSifsElement_u sifsElementReg;

	enableReg.val = 0;
	sifsElementReg.val = 0;

	/* This is the time (in resolution of 1/8 microseconds) which the TXC needs to count in order to complete to SIFS */
	sifsElementReg.bitFields.sifsElement = Pac_GetHwDelays(PAC_DELAY_TXC_SIFS_ELEMENT);
	RegAccess_Write(REG_TXH_TXC_SIFS_ELEMENT, sifsElementReg.val);
	
	enableReg.bitFields.txhTxcEnable = TRUE;
	RegAccess_Write(REG_TXH_TXC_TXH_TXC_ENABLE, enableReg.val);//should be fixed 
}


