/***************************************************************
 File:		TxHeaderConversion.c
 Module:	  	TxHeaderConversion
 Purpose: 	holds all the implementation of the TxHeaderConversion  API functions
 Description:  This module contains the implementation of the functions of the TxHeaderConversion module 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "TxHeaderConversion_Api.h"
#include "TxHeaderConversion.h"
#include "queue_utility.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "HwQManager_API.h"
#include "TxHandler_Api.h"
#include "DescriptorsDefinitions.h"
#include "OSAL_UpperMacMessages.h"
#include "MacTxHcRegs.h"
#include "ieee80211.h"
#include "VapDb_Descriptors.h"
#include "Utils_Api.h"
#include "RegAccess_Api.h"
#include "TxSender_ScratchPadApi.h"
#include "TxHcDoneReport_Descriptors.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define LOG_LOCAL_GID   GLOBAL_GID_TX_HW_ACCELERATORS
#define LOG_LOCAL_FID 	9


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Debug Section									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
						Static Variables									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

TxHeaderConversion_ConfigureVapModeBitmap  


Description:
------------
Configure the header conversion bitmap - each bit represent the VAP configuration - AP/STA

Input:
-----
	
		
Output:
-------
	
**********************************************************************************/
#ifndef ENET_INC_ARCH_WAVE600D2
void TxHeaderConversion_ConfigureVapModeBitmap(uint8 vapId, bool vapMode)
{

	RegMacTxHcVapModeBitmap_u txHcVapModeBitmap; 

 	RegAccess_Read(REG_MAC_TX_HC_VAP_MODE_BITMAP, &(txHcVapModeBitmap.val));
	if(vapMode == FALSE) //AP_MODE
	{
 		Utils_ZeroBitInBitmap(&(txHcVapModeBitmap.val), vapId); 
	}
	else //STA_MODE
	{
 		Utils_SetBitInBitmap(&(txHcVapModeBitmap.val), vapId); 
	}
	RegAccess_Write(REG_MAC_TX_HC_VAP_MODE_BITMAP, txHcVapModeBitmap.val);

}
#endif	

/**********************************************************************************

TxHeaderConversion_EnableDisableLogger


Description:
------------
Initialize the memory and internal registers of the OTF_Aggregator module

Input:
-----
	
		
Output:
-------
	
**********************************************************************************/
void TxHeaderConversion_EnableDisableLogger(bool isEnable)
{
	RegMacTxHcTxHcLoggerControl_u txHcLoggerReg;

	RegAccess_Read(REG_MAC_TX_HC_TX_HC_LOGGER_CONTROL, &(txHcLoggerReg.val));
	txHcLoggerReg.bitFields.txHcLoggerEn = isEnable;
	txHcLoggerReg.bitFields.txHcLoggerPriority = LOGGER_HW_DEFAULT_PRIORITY;
	RegAccess_Write(REG_MAC_TX_HC_TX_HC_LOGGER_CONTROL, txHcLoggerReg.val);
}
/**********************************************************************************

TxHeaderConversion_Initialize  


Description:
------------
Initialize the memory and internal registers of the OTF_Aggregator module

Input:
-----
	
		
Output:
-------
	
**********************************************************************************/
void TxHeaderConversion_Initialize(void)
{	
	RegMacTxHcVapDbParams_u 			macTxHcVapDbParams; 
	RegMacTxHcHcSenderDescFifoParams_u	txHcSenderFifoParams;  
#ifdef ENET_INC_ARCH_WAVE600B
    RegMacTxHcTxHcIntErrorEn_u          txHcIntErrorEn;
#endif

	macTxHcVapDbParams.val = 0x0; 
	macTxHcVapDbParams.bitFields.vapDbBssidOffset = (FM_STRUCT_OFFSET(VapDb_t,bssid) >> 0x2);
	RegAccess_Write(REG_MAC_TX_HC_VAP_DB_PARAMS, macTxHcVapDbParams.val);

	txHcSenderFifoParams.val = 0x0; 
	txHcSenderFifoParams.bitFields.hcSenderDescFifoBaseAddr = (SCPAD_BASE_ADDRESS+SCPAD_TOTAL_SIZE)-(TX_HC_DONE_REPORT_ENTRIES * CONVERT_BYTES_TO_WORDS(sizeof(TxHcDoneReport_t))); 

	txHcSenderFifoParams.bitFields.hcSenderDescFifoDepthMinusOne = TX_HC_DONE_REPORT_ENTRIES -1; 
	RegAccess_Write(REG_MAC_TX_HC_HC_SENDER_DESC_FIFO_PARAMS,txHcSenderFifoParams.val);

#ifdef ENET_INC_ARCH_WAVE600B
    txHcIntErrorEn.val = 0x0;
    txHcIntErrorEn.bitFields.txHcDmaLengthMismatchEn = TRUE;
    txHcIntErrorEn.bitFields.txHcMsduNonDataMismatchEn = TRUE;
    txHcIntErrorEn.bitFields.txHcMpduNotFirstMsduMismatchEn = TRUE;
    txHcIntErrorEn.bitFields.txHcJobFifoPushWhileFullEn = TRUE;
    RegAccess_Write(REG_MAC_TX_HC_TX_HC_INT_ERROR_EN, txHcIntErrorEn.val);
#endif
}

