/***********************************************************************************
 File:			TxManager_Api.h
 Module:		Tx manager 
 Purpose: 		To handle Tx packets whose transmission proccess was ended
 Description:   This file is the API of the Tx manager which is responsible of handle 
 				Tx packets whose transmission proccess was ended
************************************************************************************/
#ifndef TX_MANAGER_API_H_
#define TX_MANAGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "PacketDescriptor.h" 
#include "OSAL_Kmsg.h"
#include "InterruptManager_Api.h"

/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/

typedef struct TxManagerCtrlPacketConfirmedMessage
{
	TxPd_t *pd;
} TxManagerCtrlPacketConfirmedMessage_t;

/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
extern void TxManager_TaskEntry(K_MSG *txManagerMessage);
ISR_VOID  isr_TxManager_DisableListNotEmpty(void);
void TxManager_Init(void);

#if defined(ENET_INC_ARCH_WAVE600)
void HwEventsTxManager_TransmissionComplete_Band0(void);
void HwEventsTxManager_TransmissionComplete_Band1(void);
#else
ISR_VOID  isr_TxManager_TransmissionComplete(void);
#endif

#endif /* TX_MANAGER_API_H_ */

