/***********************************************************************************
 File:			TxManager.h
 Module:		Tx Manager 
 Purpose: 		To handle Tx packets whose transmission proccess was ended
 Description:	This file contains all definitions and the structures of the Tx 
 				manager	which is responsible to handle Tx packets whose transmission 
 				proccess was ended
************************************************************************************/
#ifndef TX_MANAGER_H_
#define TX_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define TX_MANAGER_INVALID_TID_NUMBER 0xFF

typedef void (*TxManagerListHandler)(TxPd_t *headPd, TxPd_t *tailPd);
typedef void (*TxManagerPdHandler)(TxPd_t *packetDescriptor);
typedef TxPd_t* (*TxManagerDiscardedPdHandler)(TxPd_t *packetDescriptor);

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------


#endif /* TX_MANAGER_H_ */

