/***********************************************************************************
 File:			TxManager.h
 Module:		Tx Manager 
 Purpose: 		To handle Tx packets whose transmission proccess was ended
 Description:	This file contains all definitions and the structures of the Tx 
 				manager	which is responsible to handle Tx packets whose transmission 
 				proccess was ended
************************************************************************************/
#ifndef TX_MANAGER_STA_MANAGER_H_
#define TX_MANAGER_STA_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void txManagerStaOpen(K_MSG* txManagerMessage);
void txManagerStaStopTraffic(K_MSG* txManagerMessage);
void txManagerStaPostStopTraffic(K_MSG* txManagerMessage);
void txManagerStaClose(K_MSG* txManagerMessage);
void txManagerStaLockEv(K_MSG* txManagerMessage);
void txManager_StaManagerInit(void);

#endif /* TX_MANAGER_STA_MANAGER_H_ */


