/***************************************************************
 File:		TxMulticastHandler_Api.h
 Module:	  	TxMulticastHandler interface
 Purpose: 	interface of the TxMulticastHandler
 Description:  This file is the API to the TxMulticastHandler module
***************************************************************/
#ifndef  _MULTICAST_HANDLER_API_H_
#define  _MULTICAST_HANDLER_API_H_


//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "OSAL_Api.h"
#include "PacketDescriptor.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum
{
	REGULAR_MULTICAST = 0,
	RELIABLE_MULTICAST,
	NUM_OF_MULTICAST_MODE
} MulticastMode_e; 


//---------------------------------------------------------------------------------
//						Externals
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

uint32* MulticastHandler_GetStatistics_Address(void);
void MulticastHandler_NewMulticastPacket(TxPd_t* pMulticastPacket);
void MulticastHandler_ClonePacketDone(TxPd_t* pPacketDesc);
void MulticastHandler_StaStopTraffic(K_MSG* multicastHandlerMessage);
void MulticastHandler_MulticastGroupActionReq(K_MSG* psMsg);
void MulticastHandler_SetVapMulticastMode(uint8 vapIndex, MulticastMode_e mcastMode);
uint8 MulticastHandler_GetVapMulticastMode(uint8 vapIndex);
void MulticastHandler_Init(void);






#endif // _MULTICAST_HANDLER_API_H_



