/***************************************************************
 File:		TxMulticastHandler.h
 Module:	  	TxMulticastHandler
 Purpose: 	holds the definions for the TxMulticastHandler module 
 Description:  This file contains the definions of the TxMulticastHandler module
***************************************************************/

#ifndef TX_MULTICAST_HANDLER_H_
#define TX_MULTICAST_HANDLER_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "PacketDescriptor.h"
#include "HwGlobalDefinitions.h"
#include "HwQManager_API.h"
#include "Statistics_Descriptors.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define GROUP_BITMAP_SIZE 				((MAX_NUM_OF_GROUPS + 7)>>3)
#define GROUP_BITMAP_SIZE_IN_WORDS 		((GROUP_BITMAP_SIZE +3)>>2)

#define STA_BITMAP_SIZE 				((HW_NUM_OF_STATIONS + 7)>>3)
#define STA_BITMAP_SIZE_IN_WORDS 		((STA_BITMAP_SIZE +3)>>2)

#define GROUP_INDEX_BROADCAST			(0)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum
{
	NOT_ENOUGH_CLONE_PDS 				= 0,
	ALL_CLONES_FINISHED_TRANSMISSION 	= 1,
	NO_STATIONS_IN_GROUP			 	= 2,	
	NUM_OF_MULTICAST_STATISTICS
} MulticastStatistics_e; 

typedef struct VapMcastDb_
{
	uint32 			StasInGroupBitmap[STA_BITMAP_SIZE_IN_WORDS];
} VapMcastDb_t;


typedef struct GroupMcastDb_
{
	VapMcastDb_t 	VapMcastDb[HW_NUM_OF_VAPS];
} GroupMcastDb_t;



typedef struct StaMcastDb_
{
	uint32 			GroupsOfStaBitmap[GROUP_BITMAP_SIZE_IN_WORDS];
} StaMcastDb_t;

typedef struct McastHandlerDb_
{
	GroupMcastDb_t	GroupMcastDb[MAX_NUM_OF_GROUPS];
	MulticastMode_e MulticastMode[HW_NUM_OF_VAPS];	
	StaMcastDb_t 	StaMcastDb[HW_NUM_OF_STATIONS];
} McastHandlerDb_t;


//---------------------------------------------------------------------------------
//						Function Declaration				
//---------------------------------------------------------------------------------
void MulticastHandler_ReleaseOriginPd(TxPd_t* pPacketDesc, RegInterfaceNum_e regIfNum);
void MulticastHandler_SendReliableMulticast(uint8 vapIndex, uint8 groupIndex, TxPd_t* pMulticastPacket);
void MulticastHandler_AddStaToGroup(uint8 vapIndex, uint8 groupIndex, StaId staIndex);
void MulticastHandler_RemoveStaFromGroup(uint8 vapIndex, uint8 groupIndex, StaId staIndex);
void MulticastHandler_RemoveStaFromAllGroups(uint8 vapIndex, StaId staIndex);


#endif /* TX_MULTICAST_HANDLER_H_ */

