/* TxPacketsClassifier_API.h */

#ifndef  _TX_PACKET_CLASSIFIER_H_
#define  _TX_PACKET_CLASSIFIER_H_




#include "PacketDescriptor.h"
#include "System_GlobalDefinitions.h"
#include "InterruptManager_Api.h"



#define BROADCAST_ADDRESS { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
#if defined	(WORKAROUND_FOR_HW_BUG_IN_TIM_IE)
void TxPacketsClassifier_SetNdpWasSentInd(StaId stationId, uint8 val);
uint8 TxPacketsClassifier_GetNdpWasSentInd(StaId stationId);
void TxPacketsClassifier_SendNdpPd(StaId stationId);
#endif
void TxPacketsClassifier_SendDataPacket(TxPd_t* pDesc);
void TxPacketsClassifier_SendManagementPacketFromFw(TxPd_t* pDesc);
void TxPacketsClassifier_SendManagementPacketFromHost(TxPd_t* pDesc);
void TxPacketsClassifier_SendDataPacketFromHost(TxPd_t *packetDescriptor);
void TxPacketsClassifier_SendBar(TxPd_t* pDesc);
//TBD should not be API functionss - fix when this file is fixed

void TxPacketClassifier_SendNdpaMessage(TxPd_t* trainingPd);
void TxPacketsClassifier_BuildNdpaHeader(TxPd_t *pDesc);
void TxPacketsClassifier_BuildManagementFrameHeader(TxPd_t* pDesc);
void TxPacketsClassifier_BuildBarHeader(TxPd_t* pDesc);

//till here

#if defined(ENET_INC_ARCH_WAVE600)
void HwEventsTxPacketsClassifier_ReadyPds(void);
#else // wave 500
ISR_VOID  isr_TxPacketsClassifier_ReadyPds(void);
#endif // ENET_INC_ARCH_WAVE600
#if defined (ENABLE_PIE_TEST)
void TxPacketClassifier_AddDelayStoreValue(uint32 data1,  uint32 data2, uint32 data3);
#endif
#endif // _TX_PACKET_CLASSIFIER_H_
