/************************************************************************************
*    
*    File:		 TxPkacketsClassifier.c
*    Class/Module: <Class/Module Name>
*    Description:  The purpose of this module is to claasify the packets between management / data /multicast packets
*                        
*		 	  
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/



#include "TxPacketsClassifier_API.h"
#include "TxMulticastHandler_API.h"
#include "stringLibApi.h"
#include "frame.h"
#include "HwQManager_API.h"
#include "VapDatabase_Api.h"
#include "ErrorHandler_Api.h"
#include "ResourceManager_API.h"
#include "HwMemoryMap.h"
#include "StaDatabase_Api.h"
#include "loggerAPI.h"
#include "protocol.h"
#include "HostInterfaceAcc_Api.h"
#include "Pac_Api.h"
#include "StatisticsManager_api.h"
#include "Atf_Api.h"
#include "HostInterface.h"
#include "ShramPacketDescriptors.h"
#include "Statistics_Api.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "ConfigurationManager_api.h"
#endif
#if defined (ENABLE_PIE_TEST)
#include "mt_sysrst.h"
#endif

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_WAVE500
#define LOG_LOCAL_FID 1

//#define TX_PACKET_CLASSIFIER_DEBUG

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
bool TxPacketsClassifier_IsCsaDeauthPacket(TxPd_t *pdPointer);
extern bool hostInterface_IsStaAtfBuffered(StaId sid);
extern bool hostInterface_IsStaTidAcmAllowed(StaId sid, uint8 tid);
#if defined (ENET_INC_ARCH_WAVE600)	
extern bool hostInterface_atfCheckAgeingCondition(uint8 ttlCount, uint8 bandId);
#else
extern bool hostInterface_atfCheckAgeingCondition(uint8 ttlCount);
#endif
extern bool HostInterface_IsRestrictedAc(uint8 tid);
extern PerClientStatistics_t PerClientStatistics;
/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
#if defined (ENABLE_PIE_TEST)
typedef struct TxPacketClassifierDelay
{
	bool	enabled;
	uint32	delayInUsec;
	uint32	reserved;
}TxPacketClassifierDelay_t;

TxPacketClassifierDelay_t txPacketClassifierDelay;

uint32 prevUnicastPds=0;

#endif

const uint8 TxClassierAcGlobalTids[NUM_OF_TID] =
{
    IEEE802_1D_BE_1,
    IEEE802_1D_BK_1,
    IEEE802_1D_BK_1, 
    IEEE802_1D_BE_1, 
	IEEE802_1D_VI_1,
	IEEE802_1D_VI_1,
	IEEE802_1D_VO_1,
	IEEE802_1D_VO_1,
};

uint32 isr_TxPacketsClassifierCount=0;
uint32 mcastPDs=0;
uint32 bcastPDs = 0;
uint32 unicastPds=0;
uint32 mangFw = 0;
uint32 SendManagementPacketCount = 0;
#if defined (TX_PACKET_CLASSIFIER_DEBUG)
uint32 tempCount = 0;
uint32 isrStart = 0;
#endif
#if defined	(WORKAROUND_FOR_HW_BUG_IN_TIM_IE)
uint8 NdpForMngWasSend[HW_NUM_OF_STATIONS] = {0};
#endif

#if defined (ENET_INC_ARCH_WAVE600)
void  HwEventsTxPacketsClassifier_ReadyPds(void)
{
#ifndef TX_DATA_UM_PATH
	/*When TX_DATA_UM_PATH is not defined only packets that need special handling are routed to UM lists - 
	e.g. Unicast data packets for a STA we are removing or Multicast data packets for a reliable Multicast VAP*/
	K_MSG *hostInterfaceMessage = NULL;
		
	/* Mask all not empty interrupts in HW event */
	EventManager_TurnOffEvent(EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY);
	hostInterfaceMessage = OSAL_GET_MESSAGE(K_NO_DATA); 
	OSAL_SEND_MESSAGE(HIM_DESCRIPTORS_ON_READY_LISTS, TASK_HIM, hostInterfaceMessage, VAP_ID_DO_NOT_CARE);
#else
	/*When TX_DATA_UM_PATH is defined all data packets are routed to UM list*/
#ifdef TX_DATA_THREAD_PATH
	/*When TX_DATA_THREAD_PATH is defined all data packets are handled in TX manager thread context*/

	/* Mask all not empty interrupts in HW event */
	EventManager_TurnOffEvent(EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY);
	OSAL_SEND_NO_DATA_MESSAGE(TX_MANAGER_DATA_LIST_NOT_EMPTY, TASK_TX_MANAGER, VAP_ID_DO_NOT_CARE);
#else

    HwQueueManagerRequestParams_t hwQueueManagerRequestParams;

    HwQManager_ClearTxListsInt(HW_Q_MANAGER_READY_LIST_UNICAST_PD);
	isr_TxPacketsClassifierCount++;
    memset(&hwQueueManagerRequestParams,0, sizeof(HwQueueManagerRequestParams_t));
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
    hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_READY_LIST_UNICAST_PD;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_TWO;
    HwQManager_FlushQ(&hwQueueManagerRequestParams);
	DEBUG_ASSERT(hwQueueManagerRequestParams.pHeadDesc != NULL_PD);
    ((TxPd_t*)hwQueueManagerRequestParams.pTailDesc)->nextPdPointer = NEXT_PD_NULL;
    TxPacketsClassifier_SendDataPacket((TxPd_t *)hwQueueManagerRequestParams.pHeadDesc);
#endif	
#endif	
}


#else // wave500
ISR_VOID  isr_TxPacketsClassifier_ReadyPds(void)
{
#ifndef TX_DATA_UM_PATH
	/*When TX_DATA_UM_PATH is not defined only packets that need special handling are routed to UM lists - 
	e.g. Unicast data packets for a STA we are removing or Multicast data packets for a reliable Multicast VAP*/
	K_MSG *hostInterfaceMessage = NULL;
		
	/* Mask all not empty interrupts in HW event */
	EventManager_TurnOffEvent(EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY);
	hostInterfaceMessage = OSAL_GET_MESSAGE(K_NO_DATA); 
	OSAL_SEND_MESSAGE(HIM_DESCRIPTORS_ON_READY_LISTS, TASK_HIM, hostInterfaceMessage, VAP_ID_DO_NOT_CARE);

#else
	/*When TX_DATA_UM_PATH is defined all data packets are routed to UM list*/
#ifdef TX_DATA_THREAD_PATH
	/*When TX_DATA_THREAD_PATH is defined all data packets are handled in TX manager thread context*/

	/* Mask all not empty interrupts in HW event */
	EventManager_TurnOffEvent(EVENT_ID_TX_LIST_READY_PDS_HIGH_PRI_NOT_EMPTY);
	OSAL_SEND_NO_DATA_MESSAGE(TX_MANAGER_DATA_LIST_NOT_EMPTY, TASK_TX_MANAGER, VAP_ID_DO_NOT_CARE);
#else
    HwQueueManagerRequestParams_t hwQueueManagerRequestParams;

    HwQManager_ClearTxListsInt(HW_Q_MANAGER_READY_LIST_UNICAST_PD);
	isr_TxPacketsClassifierCount++;
    memset(&hwQueueManagerRequestParams,0, sizeof(HwQueueManagerRequestParams_t));
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
    hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_READY_LIST_UNICAST_PD;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_TWO;
    HwQManager_FlushQ(&hwQueueManagerRequestParams);
	DEBUG_ASSERT(hwQueueManagerRequestParams.pHeadDesc != NULL_PD);
    ((TxPd_t*)hwQueueManagerRequestParams.pTailDesc)->nextPdPointer = NEXT_PD_NULL;
    TxPacketsClassifier_SendDataPacket((TxPd_t *)hwQueueManagerRequestParams.pHeadDesc);
#endif	
#endif	
}

#endif // ENET_INC_ARCH_WAVE600

#if defined (ENABLE_PIE_TEST)
void TxPacketClassifier_AddDelayStoreValue(uint32 data1,  uint32 data2, uint32 data3)
{
	txPacketClassifierDelay.enabled = data1;
	txPacketClassifierDelay.delayInUsec = data2;
	txPacketClassifierDelay.reserved = data3;
	ILOG0_DDD("[AGER_POC] TxPacketClassifier_AddDelayStoreValue enabled = %d dealy = %d [uSec] reserved = %d", txPacketClassifierDelay.enabled, txPacketClassifierDelay.delayInUsec, txPacketClassifierDelay.reserved);
}

uint32 TxPacketClassifier_AddDelay(void)
{
	uint32 garbage = 0;
	if (txPacketClassifierDelay.enabled == TRUE)
	{
		garbage = MT_Delay_PIE(txPacketClassifierDelay.delayInUsec);
	}
	return(garbage);
}
#endif

/********************************************************************************
TxPacketsClassifier_SendDataPacket

Description:
------------
This is API for the data  (unicast & multicast) packets 
Input:
-----
Packet descriptor address
Output:
-------
Returns:
--------
<Descriptions of the function return value>
********************************************************************************/
void TxPacketsClassifier_SendDataPacket(TxPd_t* pDesc)
{
	TxPd_t* pNextPd;
	HwQueueManagerRequestParams_t hwQueueManagerRequestParams;	
#if defined (ENET_INC_ARCH_WAVE600)	
	uint8 bandId;
#endif
#if defined (ENABLE_PIE_TEST)
	bool traced = FALSE;
#endif
#ifdef TX_DATA_THREAD_PATH
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE; 		
#else
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_TWO; 		
#endif

	while((TxPd_t*)NULL_PD != pDesc)
    {  
		pNextPd = (TxPd_t*)GET_NEXT_PD(pDesc);
		pDesc->nextPdPointer = NEXT_PD_NULL;
#if defined (ENET_INC_ARCH_WAVE600)	
		bandId = ConfigurationManager_GetBandForStation(pDesc->txQStaId);
#endif 		//ENET_INC_ARCH_WAVE600	
		if(pDesc->mcUnicast == UNICAST)
		{
#if defined (ENABLE_PIE_TEST)

			uint32 garbage = TxPacketClassifier_AddDelay();

			if ((traced == FALSE) && (txPacketClassifierDelay.enabled == TRUE) && (garbage > 3))
			{
				traced = TRUE;
				//ILOG0_D("TxPacketsClassifier_SendDataPacket delay = %d", txPacketClassifierDelay.delayInUsec);	
			}
#else	
			ILOG2_D("TxPacketsClassifier_SendDataPacket tid = %d", pDesc->Tid);
#endif
			unicastPds++;
			pDesc->txQGroupId = HW_TX_Q_TYPE_STA_TID;
			/*If STA is non-QoS override TID with 0*/
			if (hostInterface_IsStaQoS(pDesc->txQStaId) == FALSE)
			{
#ifdef ENET_INC_ARCH_WAVE600 
				// There length of this packet was increased in host-if counter per STA/TID. Since we are about to change the TID, we need to change the counters accordingly.
				hostInterfaceDecrementPdByteCount(pDesc->txQTid, pDesc->txQStaId, pDesc->dataLength);
				hostInterfaceIncrementPdByteCount(IEEE802_1D_BE_1,pDesc->txQStaId,pDesc->dataLength);					
#endif		
				pDesc->txQTid = IEEE802_1D_BE_1;
			}
			if ((hostInterface_IsStaOpen(pDesc->txQStaId) == TRUE) &&
				(hostInterface_IsStaTidAcmAllowed(pDesc->txQStaId, pDesc->txQTid) == TRUE) &&
				(HostInterface_IsRestrictedAc(pDesc->txQTid) == TRUE))
			{
                if (hostInterface_IsStaAtfBuffered(pDesc->txQStaId) == FALSE)
                {              
					hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
					hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID;
					hwQueueManagerRequestParams.primaryAddr = pDesc->txQStaId;
					hwQueueManagerRequestParams.secondaryAddr = pDesc->txQTid;
        			hwQueueManagerRequestParams.pHeadDesc = pDesc;

        			HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);                
                }
                else
                {
                    // check if PD will be aged. since gap of time is higher than criteria
#if defined (ENET_INC_ARCH_WAVE600)	
                    if ( hostInterface_atfCheckAgeingCondition(pDesc->ttlCount, bandId))
#else
					if ( hostInterface_atfCheckAgeingCondition(pDesc->ttlCount) )
#endif
                    {
                        /*Send to Liberator*/
                        hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
    			    	hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_DONE_LIST_LIBERATOR;
			    	    hwQueueManagerRequestParams.pHeadDesc = pDesc;
						pDesc->status = PD_STATUS_NACK;
						
#if defined (ENET_INC_ARCH_WAVE600)	
						GeneralStatistics.dropReasonClassifier[bandId]++;
						PerClientStatistics.dropCntReasonClassifier[pDesc->txQStaId]++;
#else
						GeneralStatistics.dropReasonClassifier++;
#endif //ENET_INC_ARCH_WAVE600
	        			/*Send to Liberator*/
        				HwQManager_PushPacketToTail(&hwQueueManagerRequestParams); 
                    } 
                    else
                    {
    				    /*Send to Atf Buffer list*/
        				Atf_Buffering_PushPacketToTail(pDesc); 
                    }
                }
			}
			else
			{
				hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
				hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_DONE_LIST_LIBERATOR;
				hwQueueManagerRequestParams.pHeadDesc = pDesc;
				pDesc->status = PD_STATUS_NACK;
#if defined (ENET_INC_ARCH_WAVE600)	
				GeneralStatistics.dropReasonClassifier[bandId]++;
#else
				GeneralStatistics.dropReasonClassifier++;
#endif //ENET_INC_ARCH_WAVE600
				/*Send to Liberator*/
				HwQManager_PushPacketToTail(&hwQueueManagerRequestParams); 
			}
		}
		else // multicast 
		{
			mcastPDs++;
			if(pDesc->txQStaId == 0)
			{
				bcastPDs++;				
			}
			pDesc->txQGroupId = HW_TX_Q_TYPE_VAP_TID;
			if ((hostInterface_IsVapEnabled(pDesc->txQVapId) == TRUE) &&
				(VapDb_GetVapMode(pDesc->txQVapId) == VAP_MODE_AP) &&
				(HostInterface_IsRestrictedAc(pDesc->txQTid) == TRUE))
			{
		    	MulticastHandler_NewMulticastPacket(pDesc);
			}
			else
			{
				hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
				hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_DONE_LIST_LIBERATOR;
				hwQueueManagerRequestParams.pHeadDesc = pDesc;
				/*Send to Liberator*/
				HwQManager_PushPacketToTail(&hwQueueManagerRequestParams); 
			}
		}
		pDesc = pNextPd;
    }
}

    
//***********************************************************************
// TxPacketsClassifier_IsCsaDeauthPacket
// 
// Description:
// This function checks if the PD us a unicast\multicast deauthentication packet or not 
// 
// Input:
// ------
// PD
// 
// Output:
// -------
// None
// 
// Returns:
// --------
// Is this a UC DEAUTHENTICATION packet
// 
//************************************************************************/
bool TxPacketsClassifier_IsCsaDeauthPacket(TxPd_t *pdPointer)
{
	bool uc = FALSE;

	if ((pdPointer->txQTid == MANAGEMENT_TID)																																		&&
		((pdPointer->mgmtFrameSubtype == MGMT_FRAME_SUBTYPE_DEAUTHENTICATION) && ((pdPointer->pdType == PD_TYPE_MANAGEMENT_ENC)||(pdPointer->pdType == PD_TYPE_MANAGEMENT_UNENC)))	&&
		(pdPointer->txQGroupId == HW_TX_Q_TYPE_GPHP))
	{
		uc = TRUE;
	}

	ILOG0_D("[CSA] TxPacketsClassifier_IsUcDeauthPacket uc = %d ", uc);

	return (uc);
}

/********************************************************************************
TxPacketsClassifier_SendManagementPacket

Description:
------------
 This is API for the management packets 

Input:
-----
Packet descriptor address
Output:
-------
Returns:
--------
<Descriptions of the function return value>
********************************************************************************/
void TxPacketsClassifier_SendManagementPacketFromFw(TxPd_t* pDesc)
{
	HwQueueManagerRequestParams_t hwQueueManagerRequestParams;
	uint32 currentTsf;

	
#if defined (ENET_INC_ARCH_WAVE600)
	/*Update statistics*/
	pBaaCounters->fwMngmntFramesConfirmed[ConfigurationManager_GetBandForVap(pDesc->txQVapId)]++;

	/* Set timestamp in PD */
	currentTsf = Pac_TimGetTsfLowPerBand(ConfigurationManager_GetBandForVap(pDesc->txQVapId));
#else
	/*Update statistics*/
	pBaaCounters->fwMngmntFramesConfirmed++;

	/* Set timestamp in PD */
	currentTsf = Pac_TimGetTsfLow();
#endif
	pDesc->ttlCount = HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(currentTsf);
	memset(&hwQueueManagerRequestParams,0,sizeof(HwQueueManagerRequestParams_t));

	/* Multicast Deauthentication packets are prepared by driver including frame header */
	if (!((pDesc->mcUnicast == MULTICAST) && (TxPacketsClassifier_IsCsaDeauthPacket(pDesc) == TRUE)))
	{
		TxPacketsClassifier_BuildManagementFrameHeader(pDesc);
	}

	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
	hwQueueManagerRequestParams.secondaryAddr = pDesc->txQTid;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
	if(pDesc->mcUnicast == MULTICAST)
	{
		hwQueueManagerRequestParams.primaryAddr = pDesc->txQVapId;
		if (TxPacketsClassifier_IsCsaDeauthPacket(pDesc) == TRUE)
		{
			hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_GPHP;
		}
		else
		{
			hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_VAP_TID;
		}		
	}
	else
	{
		if ((pDesc->pdType == PD_TYPE_CH_SWITCH_ANN) 
#if defined (ENET_INC_ARCH_WAVE600)
			|| (pDesc->pdType == PD_TYPE_CH_SWITCH_ANN_ENC) || (TxPacketsClassifier_IsCsaDeauthPacket(pDesc))
#endif
			)
		{
			hwQueueManagerRequestParams.primaryAddr = pDesc->txQVapId;
			hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_GPHP;  
		}
		else
		{
			hwQueueManagerRequestParams.primaryAddr = pDesc->txQStaId;
			hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID;  
		}
	}
	mangFw++;
	/* When sending MC DEAUTH frame do not modify the packet pointer since it is given by Driver (see WLANRTSYS-12518) */
	if (!((pDesc->mgmtFrameSubtype == MGMT_FRAME_SUBTYPE_DEAUTHENTICATION) && (pDesc->mcUnicast == MULTICAST)))
	{
		pDesc->packetPointer = CONVERT_ADDR_FOR_WLAN_HW(pDesc->packetPointer); 
	}
	hwQueueManagerRequestParams.pHeadDesc = pDesc;
	HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);	

#if defined	(WORKAROUND_FOR_HW_BUG_IN_TIM_IE)
	if (hwQueueManagerRequestParams.dplIndex == HW_TX_Q_TYPE_STA_TID )
	{
		TxPacketsClassifier_SendNdpPd(pDesc->txQStaId);		
	}
#endif
}

/********************************************************************************
TxPacketsClassifier_SendBar


Description:
------------
 This is API for the BAR packets 

Input:
-----
Packet descriptor address
Output:
-------
Returns:
--------
<Descriptions of the function return value>
********************************************************************************/
void TxPacketsClassifier_SendBar(TxPd_t* pDesc)
{
	HwQueueManagerRequestParams_t hwQueueManagerRequestParams;
	uint32 currentTsf;
	
	
#if defined (ENET_INC_ARCH_WAVE600)
	/*Update statistics*/
	pBaaCounters->fwctrlFramesSent[ConfigurationManager_GetBandForVap(pDesc->txQVapId)]++;

	currentTsf = Pac_TimGetTsfLowPerBand(ConfigurationManager_GetBandForVap(pDesc->txQVapId));
#else
	/*Update statistics*/
	pBaaCounters->fwctrlFramesSent++;

	currentTsf = Pac_TimGetTsfLow();
#endif
	pDesc->ttlCount = HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(currentTsf);
	memset(&hwQueueManagerRequestParams,0,sizeof(HwQueueManagerRequestParams_t));
	//("TxPacketsClassifier_SendBarPacket: station %d vap %d ",pDesc->txQStaId,pDesc->txQVapId);
	TxPacketsClassifier_BuildBarHeader(pDesc);
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
	hwQueueManagerRequestParams.secondaryAddr = pDesc->txQTid;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
	hwQueueManagerRequestParams.primaryAddr = pDesc->txQStaId;
	hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID; 
	pDesc->packetPointer = CONVERT_ADDR_FOR_WLAN_HW(pDesc->packetPointer);
	hwQueueManagerRequestParams.pHeadDesc = pDesc;
	HwQManager_PushPacketToHead(&hwQueueManagerRequestParams);	
}

void TxPacketsClassifier_SendManagementPacketFromHost(TxPd_t* pDesc)
{
	HwQueueManagerRequestParams_t hwQueueManagerRequestParams;
	uint32  currentTsf;
	bool 	unknownSidInd;

#ifdef ENET_INC_ARCH_WAVE600B
	unknownSidInd = pDesc->unknownSidInd;
#else
	unknownSidInd = pDesc->unnkownSid;
#endif
	
	
#if defined (ENET_INC_ARCH_WAVE600)	
	GeneralStatistics.txMngFromHost[ConfigurationManager_GetBandForVap(pDesc->txQVapId)]++;
#else
	GeneralStatistics.txMngFromHost++;
#endif //ENET_INC_ARCH_WAVE600
	
#if defined (ENET_INC_ARCH_WAVE600)
	currentTsf = Pac_TimGetTsfLowPerBand(ConfigurationManager_GetBandForVap(pDesc->txQVapId));
#else
	currentTsf = Pac_TimGetTsfLow();
#endif
	pDesc->ttlCount = HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(currentTsf);
	memset(&hwQueueManagerRequestParams,0,sizeof(HwQueueManagerRequestParams_t));
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
	hwQueueManagerRequestParams.secondaryAddr = pDesc->txQTid;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
//	ILOG0_D("SendManagementPacketFromHost = %d",SendManagementPacketCount);
	if(pDesc->mcUnicast == MULTICAST)
	{
		hwQueueManagerRequestParams.primaryAddr = pDesc->txQVapId;
		/*Broadcast Probe Requests are sent via GPLP during BG active scan*/
#ifdef ENET_INC_ARCH_WAVE600 
		if (pDesc->mgmtFrameSubtype == MGMT_FRAME_SUBTYPE_PROBE_REQ)
#else
		if (pDesc->mgmtSubtype == MGMT_FRAME_SUBTYPE_PROBE_REQ)
#endif
		{
			pDesc->txQGroupId = HW_TX_Q_TYPE_GPLP;
			hwQueueManagerRequestParams.secondaryAddr = IEEE802_1D_BE_1;
			hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_GPLP;  
		}
		else
		{
			pDesc->txQGroupId = HW_TX_Q_TYPE_VAP_TID;
			hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_VAP_TID;  
		}
	}
	else if (( unknownSidInd == FALSE)&&(pDesc->pdType != PD_TYPE_PROBE_RES) && (pDesc->mgmtFrameSubtype != MGMT_FRAME_SUBTYPE_AUTHENTICATION))	
	{
		pDesc->txQGroupId = HW_TX_Q_TYPE_STA_TID;
		hwQueueManagerRequestParams.primaryAddr = pDesc->txQStaId;
		hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID; 
		/*If STA is non-QoS override TID with 0*/
		if (hostInterface_IsStaQoS(pDesc->txQStaId) == FALSE)
		{
			pDesc->txQTid = IEEE802_1D_BE_1;
			hwQueueManagerRequestParams.secondaryAddr = IEEE802_1D_BE_1;
		}
	}
	else // STA is not in DB or this is AUTHENTICATION/PROB. Need to use global queue.
	{
		pDesc->txQGroupId = HW_TX_Q_TYPE_GLOBAL;
		hwQueueManagerRequestParams.primaryAddr = pDesc->txQVapId;
#ifdef ENET_INC_ARCH_WAVE600		
		if (pDesc->txQTid == MANAGEMENT_TID)
		{
			hwQueueManagerRequestParams.secondaryAddr = TxClassierAcGlobalTids[IEEE802_1D_VO_1]; 
		}
		else	
#endif
		{
			hwQueueManagerRequestParams.secondaryAddr = TxClassierAcGlobalTids[pDesc->txQTid]; 
		}
		hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_GLOBAL; 
	
		/*If packet is an AUTH or ASSOC to unassociated STA, send event to ERP*/
		if ((unknownSidInd == TRUE) && ((pDesc->pdType != PD_TYPE_PROBE_RES) && ((pDesc->mgmtFrameSubtype== MGMT_FRAME_SUBTYPE_AUTHENTICATION) || (pDesc->mgmtFrameSubtype== MGMT_FRAME_SUBTYPE_ASSOCIATION_RES))))
		{
			OSAL_SEND_NO_DATA_MESSAGE(HDK_ERP_BSS_TX, TASK_HDK, pDesc->txQVapId);
 		}
	
	}

	if (TRUE != ConfigurationManager_IsZwdfsVap(pDesc->txQVapId)) // Driver should block management Hd's  in case Zwdfs Vap is active
	{
		hwQueueManagerRequestParams.pHeadDesc = pDesc;
		SendManagementPacketCount++;
		HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);
	 		
	}
	else
	{	
	 ASSERT(0);       			
	}	
#if defined	(WORKAROUND_FOR_HW_BUG_IN_TIM_IE)
	if (hwQueueManagerRequestParams.dplIndex == HW_TX_Q_TYPE_STA_TID )
	{
		TxPacketsClassifier_SendNdpPd(pDesc->txQStaId);		
	}
#endif
}

void TxPacketsClassifier_SendDataPacketFromHost(TxPd_t *packetDescriptor)
{
	HwQueueManagerRequestParams_t hwQueueManagerRequestParams;
	uint32 currentTsf;
	
#if defined (ENET_INC_ARCH_WAVE600)	
	GeneralStatistics.txDataFromHost[ConfigurationManager_GetBandForVap(packetDescriptor->txQVapId)]++;
#else
	GeneralStatistics.txDataFromHost++;
#endif //ENET_INC_ARCH_WAVE600
	
#if defined (ENET_INC_ARCH_WAVE600)
	currentTsf = Pac_TimGetTsfLowPerBand(ConfigurationManager_GetBandForStation(packetDescriptor->txQStaId));
#else
	currentTsf = Pac_TimGetTsfLow();
#endif
	packetDescriptor->ttlCount = HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(currentTsf);
	memset(&hwQueueManagerRequestParams,0,sizeof(HwQueueManagerRequestParams_t));
	/* Currently only NDP and EAPOLs should pass here */
	ASSERT(packetDescriptor->mcUnicast != MULTICAST);
	packetDescriptor->txQGroupId = HW_TX_Q_TYPE_STA_TID;
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
	hwQueueManagerRequestParams.secondaryAddr = packetDescriptor->txQTid;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
	hwQueueManagerRequestParams.primaryAddr = packetDescriptor->txQStaId;
	hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID; 		
	hwQueueManagerRequestParams.pHeadDesc = packetDescriptor;
	HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);
}

void TxPacketClassifier_SendNdpaMessage(TxPd_t* pDesc)
{
	HwQueueManagerRequestParams_t hwQueueManagerRequestParams;
	uint32 currentTsf;
		
#if defined (ENET_INC_ARCH_WAVE600)
	currentTsf = Pac_TimGetTsfLowPerBand(ConfigurationManager_GetBandForVap(pDesc->txQVapId));
#else
	currentTsf = Pac_TimGetTsfLow();
#endif
	pDesc->ttlCount = HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(currentTsf);
	memset(&hwQueueManagerRequestParams,0,sizeof(HwQueueManagerRequestParams_t));
	TxPacketsClassifier_BuildNdpaHeader(pDesc);
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
	hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_GPLP; 
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
	hwQueueManagerRequestParams.primaryAddr = pDesc->txQVapId;
	pDesc->packetPointer = CONVERT_ADDR_FOR_WLAN_HW(pDesc->packetPointer);
	hwQueueManagerRequestParams.pHeadDesc = pDesc;
	HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);	
}

//TBD should not be API function - fix when this file is fixed
void TxPacketsClassifier_BuildManagementFrameHeader(TxPd_t* pDesc)
{
	uint32 control = 0;
	uint16 subType = 0;
	MANAGEMENT_BASIC_FRAME_HEADER *frameHeaderPointer = NULL;
	IEEE_ADDR *vapMacAddress = NULL;

#ifdef ENET_INC_ARCH_WAVE600 
	subType = pDesc->mgmtFrameSubtype;
#else
	subType = pDesc->mgmtSubtype;
#endif
    vapMacAddress = VapDB_GetMacAddress(pDesc->txQVapId);
	frameHeaderPointer = (MANAGEMENT_BASIC_FRAME_HEADER *)(pDesc->packetPointer);
	control = FM_CONTROL_FTYPE_MANAGEMENT << FM_CONTROL_FTYPE_SHIFT;
	control |= (subType << FM_CONTROL_SUBTYPE_SHIFT);
	/* The addresses are copied directly to the SHRAM since they are copied byte byte anyway */
	if (pDesc->txQGroupId == HW_TX_Q_TYPE_VAP_TID)
	{
		vIEEE_ADDR_CopyAddr(&(frameHeaderPointer->sIEEE_ADDRaddr1), &sIEEEaddrHW_Broadcast); 
	}
	else
	{
		ASSERT(pDesc->mcUnicast != TRUE);
		StaDB_GetMacAddress(pDesc->txQStaId,&(frameHeaderPointer->sIEEE_ADDRaddr1));
	}
	vIEEE_ADDR_CopyAddr(&(frameHeaderPointer->sIEEE_ADDRaddr2), vapMacAddress);	
	if (VapDb_GetVapMode(pDesc->txQVapId) == VAP_MODE_AP)
	{
		vIEEE_ADDR_CopyAddr(&(frameHeaderPointer->sIEEE_ADDRaddr3), vapMacAddress);
	}
	else
	{
		StaDB_GetMacAddress(pDesc->txQStaId,&(frameHeaderPointer->sIEEE_ADDRaddr3));
	}
    /* The control is copied as one word to the header since duration will be filled by aggregation builder,
       the sequence number isn't initialized since it will be written by the sender */
	memcpy32(frameHeaderPointer,&control,CONVERT_BYTES_TO_WORDS(sizeof(control)));
#ifdef DUT_LOGS_ON
	//(0, 0, MANAGEMENT_FRAME_HEADER, frameHeaderPointer);
#endif
}

//TBD should not be API function - fix when this file is fixed
void TxPacketsClassifier_BuildBarHeader(TxPd_t* pDesc)
{
	uint32 control = 0;
	BarFrame_t *barFrame = NULL;
	IEEE_ADDR *vapMacAddress = NULL;

    vapMacAddress = VapDB_GetMacAddress(pDesc->txQVapId);
	barFrame = (BarFrame_t *)pDesc->packetPointer;
	control = (FM_CONTROL_FTYPE_CONTROL << FM_CONTROL_FTYPE_SHIFT) |(BAR_SUBTYPE << FM_CONTROL_SUBTYPE_SHIFT);
	/* The addresses are copied directly to the SHRAM since they are copied byte byte anyway */
	StaDB_GetMacAddress(pDesc->txQStaId, &(barFrame->FrameHeader.sIEEE_ADDRaddr1));
	vIEEE_ADDR_CopyAddr(&(barFrame->FrameHeader.sIEEE_ADDRaddr2), vapMacAddress); 
	/* The frame control is copied as one word to the header since duration will be filled by aggregation builder */
	memcpy32((void *)&barFrame->FrameHeader,&control,CONVERT_BYTES_TO_WORDS(sizeof(control)));
}


void TxPacketsClassifier_BuildNdpaHeader(TxPd_t *pDesc)
{
	NDPA_FRAME_HEADER *frameHeaderPointer = NULL;
	IEEE_ADDR *vapMacAddress = NULL;
	uint32 control = 0;
	
    vapMacAddress = VapDB_GetMacAddress(pDesc->txQVapId);
	control = (FM_CONTROL_FTYPE_CONTROL << FM_CONTROL_FTYPE_SHIFT) |(NDPA_SUBTYPE << FM_CONTROL_SUBTYPE_SHIFT);
	frameHeaderPointer = &(((NdpaPktPayload_t *)(pDesc->packetPointer))->FrameHeader);
	/* if number of stations is more than 1 set addr1 (dest address) - to broadcast address,
	   if number of stations is 1 (passed in pd type as 0) - set addr1 to the mac addr of that station*/
#ifndef ENET_INC_ARCH_WAVE600 

	if(pDesc->numOfTrainingStas == 0)
	{
		NdpaFrame_t *ndpaFrame = (NdpaFrame_t *)pDesc->packetPointer;
		
		/* to extract station mac id need to provide SID to the function*/
		StaDB_GetMacAddress((ndpaFrame->ndpaPayload.stationsInfo[0].aid-1), &(frameHeaderPointer->sIEEE_ADDRaddr1));
	}
	else
	{
		vIEEE_ADDR_CopyAddr(&(frameHeaderPointer->sIEEE_ADDRaddr1), &sIEEEaddrHW_Broadcast); 
	}
#else
	{
		NdpaFrame_t *ndpaFrame = (NdpaFrame_t *)pDesc->packetPointer;
		/* to extract station mac id need to provide SID to the function*/
		StaDB_GetMacAddress((ndpaFrame->ndpaPayload.stationsInfo[0].aid-1), &(frameHeaderPointer->sIEEE_ADDRaddr1));
	}
#endif
	vIEEE_ADDR_CopyAddr(&(frameHeaderPointer->sIEEE_ADDRaddr2), vapMacAddress);	
    /* The control is copied as one word to the header since duration will be filled by aggregation builder,
       the sequence number isn't initialized since it will be written by the sender */
	memcpy32(frameHeaderPointer,&control,CONVERT_BYTES_TO_WORDS(sizeof(control)));
}




/**********************************************************************************
TxPacketsClassifier_SendNdpPd


Description:
------------
    prepares NDP PD and push it to the relevant Q. 
Input:
-----
    stationId
Output:
-------
    None
Returns:
--------
    none
**********************************************************************************/
#if defined	(WORKAROUND_FOR_HW_BUG_IN_TIM_IE)
void TxPacketsClassifier_SendNdpPd(StaId stationId)
{
    TxPd_t* pDesc;
    HwQueueManagerRequestParams_t hwQueueManagerRequestParams;
    uint8 vapId;
    uint32 currentTsf;
	uint8 NdpWasSend;

	NdpWasSend = TxPacketsClassifier_GetNdpWasSentInd(stationId);
	
	if (NdpWasSend == FALSE)
	{
		StaDb_GetVapId(stationId, &vapId);
		   
		/*Get PD from PS Settings Pool*/
		memset(&hwQueueManagerRequestParams,0, sizeof(HwQueueManagerRequestParams_t));
		hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
		hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_TX_POOL_LIST_PS_SETTINGTS_NDP_PD;
		hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
		HwQManager_PopPacket(&hwQueueManagerRequestParams);

		pDesc= hwQueueManagerRequestParams.pHeadDesc;	

		ASSERT((TxPd_t *)NULL_PD != pDesc); 

		ILOG0_D("TxPacketsClassifier_SendNdpPd - pd 0x%x",pDesc);

		pDesc->nextPdPointer = NEXT_PD_NULL;
		pDesc->aMsduTailPointer = 0;
		pDesc->pdCounter = 0;
		pDesc->mcUnicast = 0;
		pDesc->pdType = PD_TYPE_NDP;
		pDesc->retransmissionIndication = 0;
		pDesc->aggregationIndication = 0;
		pDesc->dataLength = 0;
		pDesc->ethType = 0;
		pDesc->packetPointer = 0;
		pDesc->txQTid = IEEE802_1D_BE_1;         
		pDesc->txQStaId = stationId;       
		pDesc->txQVapId = vapId ;       
		pDesc->txQGroupId = HW_TX_Q_TYPE_STA_TID;        
		currentTsf = Pac_TimGetTsfLowPerBand(ConfigurationManager_GetBandForVap(pDesc->txQVapId));
		pDesc->ttlCount = HOST_INTERFACE_ACCELERATOR_CONVERT_USEC_TO_TTL_UNITS(currentTsf);     
		pDesc->status = 0;      

		hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_DATA_DLM;
		hwQueueManagerRequestParams.dplIndex = HW_TX_Q_TYPE_STA_TID;
		hwQueueManagerRequestParams.pHeadDesc = pDesc;
		hwQueueManagerRequestParams.secondaryAddr = IEEE802_1D_BE_1;
		hwQueueManagerRequestParams.primaryAddr = stationId;
		hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;

		HwQManager_PushPacketToTail(&hwQueueManagerRequestParams);

		TxPacketsClassifier_SetNdpWasSentInd(stationId, TRUE);
	}
}
/**********************************************************************************
TxPacketsClassifier_SetNdpWasSendInd

Description:
------------
  
Input:
-----
    stationId
Output:
-------
    None
Returns:
--------
    none
**********************************************************************************/
void TxPacketsClassifier_SetNdpWasSentInd(StaId stationId, uint8 val)
{
	NdpForMngWasSend[stationId] = val;
}
/**********************************************************************************
TxPacketsClassifier_GetNdpWasSendInd

Description:
------------
  
Input:
-----
    stationId
Output:
-------
    None
Returns:
--------
    none
**********************************************************************************/
uint8 TxPacketsClassifier_GetNdpWasSentInd(StaId stationId)
{
	return NdpForMngWasSend[stationId];
}

#endif //#if defined	(WORKAROUND_FOR_HW_BUG_IN_TIM_IE)

