/***************************************************************
 File:		TxPdAcc.c
 Module:	  	TxHeadeTxPdAcc
 Purpose: 	holds all the implementation of the TxHeadeTxPdAcc  API functions
 Description:  This module contains the implementation of the functions of the TxHeadeTxPdAcc module 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "TxPdAcc.h"
#include "TxPdAcc_Api.h"
#include "TxPdAccRegs.h"
#include "TxpdLocalContext_Descriptors.h"
#include "queue_utility.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "HwQManager_API.h"
#include "TxHandler_Api.h"
#include "DescriptorsDefinitions.h"
#include "OSAL_UpperMacMessages.h"
#include "MacTxHcRegs.h"
#include "ieee80211.h"
#include "VapDb_Descriptors.h"
#include "Utils_Api.h"
#include "RegAccess_Api.h"
#include "TxSender_ScratchPadApi.h"
#include "Ptd_Descriptors.h"
#ifdef WORKAROUND_FOR_HW_BUG_IN_ADDBA_REQ_ENCRYPTED
#include "TsManager_API.h"
#include "PacManager_api.h"
#endif

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define LOG_LOCAL_GID   GLOBAL_GID_TX_HW_ACCELERATORS
#define LOG_LOCAL_FID 	10


#define TX_PD_ACC_LOCAL_CTX_DEFAULT_WORD_VALUE		0x44444444
#define TX_PD_ACC_LOCAL_CTX_COMMON_NUMBER_OF_WORDS	16
#define TX_PD_ACC_UNLIMITTED_RETRY_LIMIT			0x0
#define TX_PD_ACC_PROBE_RES_RETRY_LIMIT				0x2
#define TX_PD_ACC_TRAINING_RETRY_LIMIT				0x1
#define TX_PD_ACC_MAX_RETRY_LIMIT					0xF



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

#define SET_BIT_IN_PD_ACC_BITMAP(bitmap,offset)			(bitmap |=  (1 << (offset)))

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Debug Section									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
						Static Variables									
/----------------------------------------------------------------------------------*/
#ifndef ENET_INC_ARCH_WAVE600B
	static TxpdLocalContext_t* txPdAccLocalContextPtr;
#else // ENET_INC_ARCH_WAVE600B
#ifdef ENET_INC_LMAC0
	static TxpdLocalContextBand0_t* txPdAccLocalContextPtr;
#endif
#ifdef ENET_INC_LMAC1
	static TxpdLocalContextBand1_t* txPdAccLocalContextPtr;
#endif
#endif // ENET_INC_ARCH_WAVE600B


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/


/**********************************************************************************

TxPdAcc_SetMgmtRetryLimit


Description:
------------
configures retry limit for management pd types upon user request.

Input:
-----
	
		
Output:
-------
	
**********************************************************************************/
void TxPdAcc_SetMgmtRetryLimit(K_MSG* psMsg)
{
	UMI_SET_RETRY_LIMIT* setMgmtRetryLimitMsg = (UMI_SET_RETRY_LIMIT*)pK_MSG_DATA(psMsg);

	uint8 mgmtRetryLimit = (uint8)MIN(TX_PD_ACC_MAX_RETRY_LIMIT, (setMgmtRetryLimitMsg->txRetryLimit + 1)); //value in HW includes original packet, therefore increased by 1.

	TxpdLocalContextCommon_t    tempTxPdAccLocalCommon; 

	ILOG0_DDD("[TxPdAcc_SetMgmtRetryLimit]: Msg params: retry limit - %d, getSetOperation - %d (set-0), status - %d", setMgmtRetryLimitMsg->txRetryLimit, setMgmtRetryLimitMsg->getSetOperation, setMgmtRetryLimitMsg->Status);
	//mgmt pd types: 6,7,9,10,11,14,16,17,21,22,23,24 according to PdType_e
	memcpy32(&tempTxPdAccLocalCommon, txPdAccLocalContextPtr, TX_PD_ACC_LOCAL_CTX_COMMON_NUMBER_OF_WORDS);
	
	if(API_GET_OPERATION == setMgmtRetryLimitMsg->getSetOperation)
	{
		//short9 represets PD_TYPE_MANAGEMENT_UNEC retry limit. All management PD types have the same retry limit value for both short and long MPDU.
		setMgmtRetryLimitMsg->txRetryLimit = (uint8)MAX(TX_PD_ACC_UNLIMITTED_RETRY_LIMIT, (tempTxPdAccLocalCommon.short9 - 1)); //value in HW includes original packet, therefore decreased by 1.
	}
	else if(API_SET_OPERATION == setMgmtRetryLimitMsg->getSetOperation)
	{
		tempTxPdAccLocalCommon.long3 =  mgmtRetryLimit; // PD_TYPE_ADDBA_REQ
		tempTxPdAccLocalCommon.short3 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long5 =	mgmtRetryLimit; // PD_TYPE_CH_SWITCH_ANN 
		tempTxPdAccLocalCommon.short5 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long6 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_UNENC_DO_NOT_FRAG
		tempTxPdAccLocalCommon.short6 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long7 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_ENC_DO_NOT_FRAG 
		tempTxPdAccLocalCommon.short7 = mgmtRetryLimit;
		
		tempTxPdAccLocalCommon.long9 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_UNENC					
		tempTxPdAccLocalCommon.short9 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long10 =  mgmtRetryLimit; //	PD_TYPE_MANAGEMENT_MULTI_PD_UNENC_DO_NOT_FRA
		tempTxPdAccLocalCommon.short10 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long11 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_ENC						
		tempTxPdAccLocalCommon.short11 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long13 =  mgmtRetryLimit; // PD_TYPE_PROBE_RES							
		tempTxPdAccLocalCommon.short13 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long14 =  mgmtRetryLimit; // 	PD_TYPE_MANAGEMENT_SIGNED_BIP				
		tempTxPdAccLocalCommon.short14 = mgmtRetryLimit;
		
		tempTxPdAccLocalCommon.long15 =  mgmtRetryLimit; // PD_TYPE_CH_SWITCH_ANN_ENC					
		tempTxPdAccLocalCommon.short15 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long16 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_MULTI_PD_ENC_DO_NOT_FRAG 
		tempTxPdAccLocalCommon.short16 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long17 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_SIGNED_BIP_DO_NOT_FRAG	
		tempTxPdAccLocalCommon.short17 = mgmtRetryLimit;
		
		tempTxPdAccLocalCommon.long21 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_NO_RESPONSE_UNENC_NO_FRAG
		tempTxPdAccLocalCommon.short21=  mgmtRetryLimit;

		tempTxPdAccLocalCommon.long22 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_NO_RESPONSE_ENC_NO_FRAG	
		tempTxPdAccLocalCommon.short22 = mgmtRetryLimit;

		tempTxPdAccLocalCommon.long23 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_NO_RESPONSE_UNENC_FRAG	
		tempTxPdAccLocalCommon.short23 = mgmtRetryLimit;
		
		tempTxPdAccLocalCommon.long24 =  mgmtRetryLimit; // PD_TYPE_MANAGEMENT_NO_RESPONSE_ENC_FRAG 	
		tempTxPdAccLocalCommon.short24 = mgmtRetryLimit;

		memcpy32(txPdAccLocalContextPtr, &tempTxPdAccLocalCommon, TX_PD_ACC_LOCAL_CTX_COMMON_NUMBER_OF_WORDS);
		ILOG0_DD("[TxPdAcc_SetMgmtRetryLimit]: new retry limit: long - %d, short - %d, pdtype9", tempTxPdAccLocalCommon.long6, tempTxPdAccLocalCommon.short6 );
	}
	OSAL_SEND_MESSAGE(UMI_MC_SET_RETRY_LIMIT_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/**********************************************************************************

TxHeadeTxPdAcc_EnableDisableLogger


Description:
------------
Initialize the memory and internal registers of the TxHeadeTxPdAcc module

Input:
-----
	
		
Output:
-------
	
**********************************************************************************/
void TxHeadeTxPdAcc_EnableDisableLogger(bool isEnable)
{
	RegTxPdAccTxpdLoggerControl_u txPdAccLoggerReg;

	RegAccess_Read(REG_TX_PD_ACC_TXPD_LOGGER_CONTROL, &(txPdAccLoggerReg.val));
	txPdAccLoggerReg.bitFields.txpdLoggerEn = isEnable;
	txPdAccLoggerReg.bitFields.txpdLoggerPriority = LOGGER_HW_DEFAULT_PRIORITY;
	RegAccess_Write(REG_TX_PD_ACC_TXPD_LOGGER_CONTROL, txPdAccLoggerReg.val);

}
/**********************************************************************************

TxHeaderConversion_Initialize  


Description:
------------
Initialize the memory and internal registers of the OTF_Aggregator module

Input:
-----
	
		
Output:
-------
	
**********************************************************************************/
void TxPdAcc_Initialize(void)
{
	RegTxPdAccTxpdDmaMode_u 			txPdAccTxPdDmaModeReg;
	RegTxPdAccTxpdOpeartionParams_u 	txPdAccTxPdOperationParamsReg; 
	RegTxPdAccSppPerPdBitmap_u			txPdAccTxPdSppPerPdBitmapReg;
	RegTxPdAccTxpdSenderPtdFifoParams_u	txPdAccTxPdSenderPtdFifoParams;
	TxpdLocalContextCommon_t	tempTxPdAccLocalCommon; 
#if defined (DMA_BUG_SKIP_BIT_WORKAROUND)
	RegTxPdAccSkipDmaPerPdBitmap_u		txPdAccTxPdSkipDmaPerPdBitmap;  
#endif
	//RegTxPdAccAddMpduPerPdBitmap_u		txPdAccAddMpduPerPdBitmap;


#ifndef ENET_INC_ARCH_WAVE600B
		txPdAccLocalContextPtr = (TxpdLocalContext_t*)TX_PD_ACC_MEM_BASE_ADDR;
#else // ENET_INC_ARCH_WAVE600B
#ifdef ENET_INC_LMAC0
		txPdAccLocalContextPtr = (TxpdLocalContextBand0_t*)TX_PD_ACC_MEM_BASE_ADDR; 
#endif
#ifdef ENET_INC_LMAC1
		txPdAccLocalContextPtr = (TxpdLocalContextBand1_t*)TX_PD_ACC_MEM_BASE_ADDR;
#endif
    	RegTxPdAccTxpdIntErrorEn_u txPdAccTxpdIntErrorEn;
#endif // ENET_INC_ARCH_WAVE600B
	
	txPdAccTxPdDmaModeReg.val = 0x0; 
	txPdAccTxPdDmaModeReg.bitFields.dmaLastCtrl = 0x0; 
	RegAccess_Write(REG_TX_PD_ACC_TXPD_DMA_MODE, txPdAccTxPdDmaModeReg.val);

	RegAccess_Read(REG_TX_PD_ACC_TXPD_OPEARTION_PARAMS, &(txPdAccTxPdOperationParamsReg.val));
	txPdAccTxPdOperationParamsReg.bitFields.longMpduThreshold = 0x0; //currently there is no difference between short and long retry thresholds
	RegAccess_Write(REG_TX_PD_ACC_TXPD_OPEARTION_PARAMS, txPdAccTxPdOperationParamsReg.val);

	RegAccess_Read(REG_TX_PD_ACC_SPP_PER_PD_BITMAP, &(txPdAccTxPdSppPerPdBitmapReg.val));
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_BAR); 
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_CH_SWITCH_ANN);
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_CH_SWITCH_ANN_ENC); 
#ifdef WORKAROUND_FOR_HW_BUG_IN_ADDBA_REQ_ENCRYPTED
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_ADDBA_REQ_ENC); 
#else
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_COLOR_SWITCH_ANNOUNCEMENT_ENC); 
#endif
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_COLOR_SWITCH_ANNOUNCEMENT_UNENC); 
	SET_BIT_IN_PD_ACC_BITMAP(txPdAccTxPdSppPerPdBitmapReg.bitFields.sppPerPdBitmap,PD_TYPE_ADDBA_REQ); 
	RegAccess_Write(REG_TX_PD_ACC_SPP_PER_PD_BITMAP, txPdAccTxPdSppPerPdBitmapReg.val);

	/* Infrastructure for debug and bug fixes */
	//RegAccess_Read(REG_TX_PD_ACC_ADD_MPDU_PER_PD_BITMAP, &(txPdAccAddMpduPerPdBitmap.val));
	//txPdAccAddMpduPerPdBitmap.bitFields.addMpduPerPdBitmap = //TBD; 
	//RegAccess_Write(REG_TX_PD_ACC_ADD_MPDU_PER_PD_BITMAP, txPdAccAddMpduPerPdBitmap.val);

#if defined (DMA_BUG_SKIP_BIT_WORKAROUND)
	// Due to HW bug in DMA wrapper, we can't use the skip bit. Currently we only use it for NDP. The other types are not used.
	//So we turn it off for NDP. A Fake pyload will be copied instead of skipping.
	RegAccess_Read(REG_TX_PD_ACC_SKIP_DMA_PER_PD_BITMAP, &(txPdAccTxPdSkipDmaPerPdBitmap.val));
	txPdAccTxPdSkipDmaPerPdBitmap.bitFields.skipDmaPerPdBitmap &= ~((0x1 << PD_TYPE_NDP) | (0x1 << PD_TYPE_NDP_NO_RESPONSE));
	RegAccess_Write(REG_TX_PD_ACC_SKIP_DMA_PER_PD_BITMAP, txPdAccTxPdSkipDmaPerPdBitmap.val);
#endif
	
	//Set all TxpdLocalContextCommon_t words with the default retry limit (4)
	memset32(&tempTxPdAccLocalCommon,TX_PD_ACC_LOCAL_CTX_DEFAULT_WORD_VALUE,TX_PD_ACC_LOCAL_CTX_COMMON_NUMBER_OF_WORDS); 
	
	tempTxPdAccLocalCommon.short0 = TX_PD_ACC_UNLIMITTED_RETRY_LIMIT; //set short data retry with unlimited retry limit 
	tempTxPdAccLocalCommon.long0 =  TX_PD_ACC_UNLIMITTED_RETRY_LIMIT; //set long data retry with unlimited retry limit 

	tempTxPdAccLocalCommon.long8 =  TX_PD_ACC_TRAINING_RETRY_LIMIT;	//Set short MU training with its retry limit
	tempTxPdAccLocalCommon.short8= 	TX_PD_ACC_TRAINING_RETRY_LIMIT; 	//Set long MU training with its retry limit

	tempTxPdAccLocalCommon.long13 =  TX_PD_ACC_PROBE_RES_RETRY_LIMIT;	//Set short probe response with its retry limit
	tempTxPdAccLocalCommon.short13 = TX_PD_ACC_PROBE_RES_RETRY_LIMIT; //Set long probe response with its retry limit
	memcpy32(txPdAccLocalContextPtr,&tempTxPdAccLocalCommon,TX_PD_ACC_LOCAL_CTX_COMMON_NUMBER_OF_WORDS);

	txPdAccTxPdSenderPtdFifoParams.val = 0x0; 
	txPdAccTxPdSenderPtdFifoParams.bitFields.txpdSenderPtdFifoBaseAddr = STD_ADDRESS_START+ CONVERT_BYTES_TO_WORDS(sizeof(Std_t)); 

	txPdAccTxPdSenderPtdFifoParams.bitFields.txpdSenderPtdFifoDepthMinusOne = PTD_RING_SIZE -1; 
	txPdAccTxPdSenderPtdFifoParams.bitFields.ptdWordSize = CONVERT_BYTES_TO_WORDS(sizeof(Ptd_t)); 
	RegAccess_Write(REG_TX_PD_ACC_TXPD_SENDER_PTD_FIFO_PARAMS,txPdAccTxPdSenderPtdFifoParams.val);

#ifdef ENET_INC_ARCH_WAVE600B
    txPdAccTxpdIntErrorEn.val = 0x0;
    txPdAccTxpdIntErrorEn.bitFields.txpdGoWhileActiveMismatchEn = TRUE;
    txPdAccTxpdIntErrorEn.bitFields.txpdSymbolOverheadOverflowEn = TRUE;
    txPdAccTxpdIntErrorEn.bitFields.txpdLastInStaDlmMismatchEn = TRUE;
#ifndef ENET_INC_ARCH_WAVE600D2 	
    txPdAccTxpdIntErrorEn.bitFields.txpdNullPdNextPointerEn = FALSE; // This interrupt is incorrect and should be ignored, according to jira WLANVLSIIP-3476. It will be fixed for wave600-2
#endif    
    txPdAccTxpdIntErrorEn.bitFields.txpdOccupiedPtdUnderflowEn = TRUE;
    txPdAccTxpdIntErrorEn.bitFields.txpdSnSsnDiffOorEn = TRUE;
    RegAccess_Write(REG_TX_PD_ACC_TXPD_INT_ERROR_EN, txPdAccTxpdIntErrorEn.val);
#endif
}

