 /***********************************************************************************
  File: 		 TxSelectorRam.h
  Module:			 Tx Selector
  Purpose:		 Tx Selector Ram definitions
  Description:		 
 ************************************************************************************/

#ifndef TX_SELECTOR_RAM_H_
#define TX_SELECTOR_RAM_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define TX_SELECTOR_RAM_OFFSET_FROM_BASE_ADDRESS 	  		0x400

#define TX_SELECTOR_MU_BITMAP_OFFSET_FROM_RAM_START			0x0
#define TX_SELECTOR_STA_TID_BITMAP_OFFSET_FROM_RAM_START	0x400
#define TX_SELECTOR_VAP_TID_BITMAP_OFFSET_FROM_RAM_START	0x800
#define TX_SELECTOR_GLOBAL_BITMAP_OFFSET_FROM_RAM_START		0x840
#define TX_SELECTOR_GPLP_BITMAP_OFFSET_FROM_RAM_START		0x880
#define TX_SELECTOR_GPHP_BITMAP_OFFSET_FROM_RAM_START		0x8C0
#define TX_SELECTOR_BEACON_BITMAP_OFFSET_FROM_RAM_START		0x900



/* Sta Ram Definition */
#define TX_SELECTOR_NUM_OF_STATIONS_ENTRIES_IN_RAM			(HW_NUM_OF_STATIONS)
/* Vap Ram Definition */
#define TX_SELECTOR_NUM_OF_VAP_ENTRIES_IN_RAM				(HW_NUM_OF_VAPS)
/* Global Ram Definition */
#define TX_SELECTOR_NUM_OF_GLOBAL_ENTRIES_IN_RAM			(HW_NUM_OF_VAPS)
/* GPLP Ram Definition */
#define TX_SELECTOR_NUM_OF_GPLP_ENTRIES_IN_RAM				(HW_NUM_OF_VAPS)
/* GPHP Ram Definition */
#define TX_SELECTOR_NUM_OF_GPHP_ENTRIES_IN_RAM				(HW_NUM_OF_VAPS)
/* Beacon  Ram Definition */
#define TX_SELECTOR_NUM_OF_BEACON_ENTRIES_IN_RAM			(HW_NUM_OF_VAPS)
/* MU Group  Ram Definition */
#define TX_SELECTOR_NUM_OF_MU_GROUP_ENTRIES_IN_RAM			(HW_NUM_OF_MU_GROUPS)
#define TX_SELECTOR_NUM_OF_MU_STA_ENTRIES_IN_RAM			(HW_NUM_OF_STATIONS)


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

// structure of Tx Selector RAM

typedef union
{
	uint32 val;
	struct
	{
		uint32 dataTid0:1;
		uint32 lockTid0:1;

		uint32 dataTid1:1;
		uint32 lockTid1:1;

		uint32 dataTid2:1;
		uint32 lockTid2:1;

		uint32 dataTid3:1;
		uint32 lockTid3:1;

		uint32 dataTid4:1;
		uint32 lockTid4:1;

		uint32 dataTid5:1;
		uint32 lockTid5:1;

		uint32 dataTid6:1;
		uint32 lockTid6:1;
		
		uint32 dataTid7:1;
		uint32 lockTid7:1;

		uint32 ps		:1;
		uint32 request	:1;
		uint32 disable	:1;
		uint32 reserved :13;			
	} bitFields;
}TxSelectorVapTidRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 dataAc0:1;
		uint32 lockAc0:1;

		uint32 dataAc1:1;
		uint32 lockAc1:1;

		uint32 dataAc2:1;
		uint32 lockAc2:1;

		uint32 dataAc3:1;
		uint32 lockAc3:1;
	
		uint32 legacyPs:1;
		uint32 disable:1;
		uint32 reserved:22; 		
	} bitFields;
}TxSelectorGlobalRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 data:1;
		uint32 lock:1;
		uint32 disable:1;
		uint32 reserved:29; 		
	} bitFields;
}TxSelectorGplpGphpRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 data:1;
		uint32 lock:1;
		uint32 request:1;			
		uint32 disable:1;
		uint32 reserved:28;			
	} bitFields;
}TxSelectorBeaconRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 muGroupLineUp0StaNum:7;
		uint32 muGroupLineUp0Valid:1;

		uint32 muGroupLineUp1StaNum:7;
		uint32 muGroupLineUp1Valid:1;

		uint32 muGroupLineUp2StaNum:7;
		uint32 muGroupLineUp2Valid:1;

		uint32 muGroupLineUp3StaNum:7;
		uint32 muGroupLineUp3Valid:1;			
	} bitFields;
}TxSelectorMuRamWord0_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 muGroupLineGroupLock:1;
		uint32 muGroupLineTxMode:2;
		uint32 muStaLineGroupIdx:7;			
		uint32 muStaLineMuPrimaryEn:1;
		uint32 muStaLineMuTidEn:8;
		uint32 reserved:13;			
	} bitFields;
}TxSelectorMuRamWord1_u;



typedef struct TxSelectorStaTidRam_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 dataTid0 	:1;
			uint32 lockTid0 	:1;
			uint32 psRequestTid0:1;
			uint32 psTypeTid0	:1;
			uint32 psModeTid0	:1;
			
			uint32 dataTid1 	:1;
			uint32 lockTid1 	:1;
			uint32 psRequestTid1:1;
			uint32 psTypeTid1	:1;
			uint32 psModeTid1	:1;
			
			uint32 dataTid2 	:1;
			uint32 lockTid2 	:1;
			uint32 psRequestTid2:1;
			uint32 psTypeTid2	:1;
			uint32 psModeTid2	:1;
			
			uint32 dataTid3 	:1;
			uint32 lockTid3 	:1;
			uint32 psRequestTid3:1;
			uint32 psTypeTid3	:1;
			uint32 psModeTid3	:1;
			
			uint32 reserved0 	:12;
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 dataTid4 	:1;
			uint32 lockTid4 	:1;
			uint32 psRequestTid4:1;
			uint32 psTypeTid4	:1;
			uint32 psModeTid4	:1;
			
			uint32 dataTid5 	:1;
			uint32 lockTid5 	:1;
			uint32 psRequestTid5:1;
			uint32 psTypeTid5	:1;
			uint32 psModeTid5	:1;
			
			uint32 dataTid6 	:1;
			uint32 lockTid6 	:1;
			uint32 psRequestTid6:1;
			uint32 psTypeTid6	:1;
			uint32 psModeTid6	:1;
			
			uint32 dataTid7 	:1;
			uint32 lockTid7 	:1;
			uint32 psRequestTid7:1;
			uint32 psTypeTid7	:1;
			uint32 psModeTid7	:1;
			
			uint32 bfType		:1;
			uint32 bfRequest	:1;
			uint32 reserved1	:2;
			uint32 disable		:1;
			uint32 reserved2	:7;
		};
	};
} TxSelectorStaTidRam_t;


typedef struct TxSelectorVapTidRam
{
	TxSelectorVapTidRam_u vapTidRamWord0;	
	
} TxSelectorVapTidRam_t;


typedef struct TxSelectorGlobalRam
{
	TxSelectorGlobalRam_u globalRamWord0;
	
} TxSelectorGlobalRam_t;


typedef struct TxSelectorGplpGphpRam
{
	TxSelectorGplpGphpRam_u gplpGphpRamWord0;

} TxSelectorGplpGphpRam_t;


typedef struct TxSelectorBeaconRam
{
	TxSelectorBeaconRam_u beaconRamWord0;
	
} TxSelectorBeaconRam_t;


typedef struct TxSelectorMuRam
{
	TxSelectorMuRamWord0_u muRamWord0;
	TxSelectorMuRamWord1_u muRamWord1;
	
} TxSelectorMuRam_t;



typedef struct TxSelectorRam
{
	TxSelectorMuRam_t muBitmap[TX_SELECTOR_NUM_OF_MU_GROUP_ENTRIES_IN_RAM]; //TX_SELECTOR_NUM_OF_MU_GROUP_ENTRIES_IN_RAM should be same or bigger than TX_SELECTOR_NUM_OF_MU_STA_ENTRIES_IN_RAM, if not the array size should be swiched to the bigger one
	TxSelectorStaTidRam_t staTidBitmap[TX_SELECTOR_NUM_OF_STATIONS_ENTRIES_IN_RAM];
	TxSelectorVapTidRam_t vapTidBitmap[TX_SELECTOR_NUM_OF_VAP_ENTRIES_IN_RAM];
	TxSelectorGlobalRam_t globalBitmap[TX_SELECTOR_NUM_OF_GLOBAL_ENTRIES_IN_RAM];
	TxSelectorGplpGphpRam_t gplpBitmap[TX_SELECTOR_NUM_OF_GPLP_ENTRIES_IN_RAM];
	TxSelectorGplpGphpRam_t gphpBitmap[TX_SELECTOR_NUM_OF_GPHP_ENTRIES_IN_RAM];
	TxSelectorBeaconRam_t beaconBitmap[TX_SELECTOR_NUM_OF_BEACON_ENTRIES_IN_RAM];
} TxSelectorRam_t;


/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/

#endif // TX_SELECTOR_RAM_H_


