 /***********************************************************************************
  File: 		 TxSelectorRam.h
  Module:			 Tx Selector
  Purpose:		 Tx Selector Ram definitions
  Description:		 
 ************************************************************************************/

#ifndef TX_SELECTOR_RAM_H_
#define TX_SELECTOR_RAM_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define TX_SELECTOR_MU_GROUP_BITMAP_OFFSET_FROM_RAM_START	        0x0
#define TX_SELECTOR_MU_STA_BITMAP_OFFSET_FROM_RAM_START		        0x400
#define TX_SELECTOR_STA_TID_BITMAP_OFFSET_FROM_RAM_START	        0x600
#define TX_SELECTOR_VAP_TID_BITMAP_OFFSET_FROM_RAM_START	        0x1600
#define TX_SELECTOR_GLOBAL_BITMAP_OFFSET_FROM_RAM_START		        0x1680
#define TX_SELECTOR_GPLP_BITMAP_OFFSET_FROM_RAM_START		        0x1700
#define TX_SELECTOR_GPHP_BITMAP_OFFSET_FROM_RAM_START		        0x1780
#define TX_SELECTOR_BEACON_BITMAP_OFFSET_FROM_RAM_START		        0x1800
#define TX_SELECTOR_PLAN_LOCK_BITMAP_OFFSET_FROM_RAM_START	        0x1880
#define TX_SELECTOR_TWT_SP_GROUP_STA_BITMAP_OFFSET_FROM_RAM_START   0x1890
#define TX_SELECTOR_TWT_SP_GROUP_COUNT_BITMAP_OFFSET_FROM_RAM_START 0x1C90
#define TX_SELECTOR_END_OF_BITMAP_OFFSET_FROM_RAM_START             0x1D90

#define ALL_PLANS_LOCKED	(0xFFFFFFFF)



/* Sta Ram Definition */
#define TX_SELECTOR_NUM_OF_STATIONS_ENTRIES_IN_RAM			(HW_NUM_OF_STATIONS)
#define TX_SELECTOR_NUM_OF_VALID_STATIONS_ENTRIES_IN_RAM_B0	(HW_NUM_OF_STATIONS)
#define TX_SELECTOR_NUM_OF_VALID_STATIONS_ENTRIES_IN_RAM_B1	(HW_NUM_OF_STATIONS/2)

/* Vap Ram Definition */
#define TX_SELECTOR_NUM_OF_VAP_ENTRIES_IN_RAM				(HW_NUM_OF_VAPS)
/* Global Ram Definition */
#define TX_SELECTOR_NUM_OF_GLOBAL_ENTRIES_IN_RAM			(HW_NUM_OF_VAPS)
/* GPLP Ram Definition */
#define TX_SELECTOR_NUM_OF_GPLP_ENTRIES_IN_RAM				(HW_NUM_OF_VAPS)
/* GPHP Ram Definition */
#define TX_SELECTOR_NUM_OF_GPHP_ENTRIES_IN_RAM				(HW_NUM_OF_VAPS)
/* Beacon  Ram Definition */
#define TX_SELECTOR_NUM_OF_BEACON_ENTRIES_IN_RAM			(HW_NUM_OF_VAPS)
/* MU Group  Ram Definition */
#define TX_SELECTOR_NUM_OF_MU_GROUP_ENTRIES_IN_RAM			(HW_NUM_OF_MU_GROUPS)

#define TX_SELECTOR_NUM_OF_MU_STA_ENTRIES_IN_RAM			(HW_NUM_OF_STATIONS)
#define TX_SELECTOR_NUM_OF_VALID_MU_STA_ENTRIES_IN_RAM_B0	(HW_NUM_OF_STATIONS)
#define TX_SELECTOR_NUM_OF_VALID_MU_STA_ENTRIES_IN_RAM_B1	(HW_NUM_OF_STATIONS/2)

#define TX_SELECTOR_MASK_FOR_TWT_AVAIL                      (0x1)
#define TX_SELECTOR_MASK_FOR_TWT_SP                         (0x2)
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

// structure of Tx Selector RAM

typedef union
{
	uint32 val;
	struct
	{
		uint32 dataTid0:1;
		uint32 lockTid0:1;

		uint32 dataTid1:1;
		uint32 lockTid1:1;

		uint32 dataTid2:1;
		uint32 lockTid2:1;

		uint32 dataTid3:1;
		uint32 lockTid3:1;

		uint32 dataTid4:1;
		uint32 lockTid4:1;

		uint32 dataTid5:1;
		uint32 lockTid5:1;

		uint32 dataTid6:1;
		uint32 lockTid6:1;
		
		uint32 dataTid7:1;
		uint32 lockTid7:1;

		uint32 dataTid8:1;
		uint32 lockTid8:1;

		uint32 ps		:1;
		uint32 request	:1;
		uint32 disable	:1;
		uint32 reserved :11;			
	} bitFields;
}TxSelectorVapTidRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 dataAc0	:1;
		uint32 lockAc0	:1;

		uint32 dataAc1	:1;
		uint32 lockAc1	:1;

		uint32 dataAc2	:1;
		uint32 lockAc2	:1;

		uint32 dataAc3	:1;
		uint32 lockAc3	:1;
	
		uint32 legacyPs	:1;
		uint32 disable	:1;
		uint32 reserved:22; 		
	} bitFields;
}TxSelectorGlobalRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 data:1;
		uint32 lock:1;
		uint32 disable:1;
		uint32 reserved:29; 		
	} bitFields;
}TxSelectorGplpGphpRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 data:1;
		uint32 lock:1;
		uint32 request:1;			
		uint32 disable:1;
		uint32 reserved:28;			
	} bitFields;
}TxSelectorBeaconRam_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 muGroupLineUp0StaNum:8;
		uint32 muGroupLineUp1StaNum:8;
		uint32 muGroupLineUp2StaNum:8;
		uint32 muGroupLineUp3StaNum:8;		
	} bitFields;
}TxSelectorMuGroupRamWord0_u;


typedef union
{
	uint32 val;
	struct
	{
		uint32 muGroupLineUp0Valid:1;
		uint32 muGroupLineUp1Valid:1;
		uint32 muGroupLineUp2Valid:1;
		uint32 muGroupLineUp3Valid:1;
		uint32 muGroupLineGroupLock:1;
		uint32 muGroupLineTxMode:2;
	} bitFields;
}TxSelectorMuGroupRamWord1_u;


typedef union
{
	uint16 val;
	struct
	{
		uint32 muStaLineGroupIdx:7;
		uint32 muStaLineMuPrimaryEn:1;
		uint32 muStaLineMuTidEn:8;		
	} bitFields;
}TxSelectorMuStaRamWord0_u;



typedef struct TxSelectorStaTidRam_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 dataTid0 	:1;
			uint32 lockTid0 	:1;
			uint32 psRequestTid0:1;
			uint32 psTypeTid0	:1;
			uint32 psModeTid0	:1;
			uint32 DlHeMuEnTid0 :1;
			uint32 UlDataTid0	:1;
			uint32 reserved0	:1;
			
			uint32 dataTid1 	:1;
			uint32 lockTid1 	:1;
			uint32 psRequestTid1:1;
			uint32 psTypeTid1	:1;
			uint32 psModeTid1	:1;
			uint32 DlHeMuEnTid1 :1;
			uint32 UlDataTid1	:1;
			uint32 reserved1	:1;
			
			uint32 dataTid2 	:1;
			uint32 lockTid2 	:1;
			uint32 psRequestTid2:1;
			uint32 psTypeTid2	:1;
			uint32 psModeTid2	:1;
			uint32 DlHeMuEnTid2 :1;
			uint32 UlDataTid2	:1;
			uint32 reserved2	:1;
			
			uint32 dataTid3 	:1;
			uint32 lockTid3 	:1;
			uint32 psRequestTid3:1;
			uint32 psTypeTid3	:1;
			uint32 psModeTid3	:1;
			uint32 DlHeMuEnTid3 :1;
			uint32 UlDataTid3	:1;
			uint32 reserved3	:1;
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 dataTid4 	:1;
			uint32 lockTid4 	:1;
			uint32 psRequestTid4:1;
			uint32 psTypeTid4	:1;
			uint32 psModeTid4	:1;
			uint32 DlHeMuEnTid4 :1;
			uint32 UlDataTid4	:1;
			uint32 reserved4	:1;
			
			uint32 dataTid5 	:1;
			uint32 lockTid5 	:1;
			uint32 psRequestTid5:1;
			uint32 psTypeTid5	:1;
			uint32 psModeTid5	:1;
			uint32 DlHeMuEnTid5 :1;
			uint32 UlDataTid5	:1;
			uint32 reserved5	:1;
			
			uint32 dataTid6 	:1;
			uint32 lockTid6 	:1;
			uint32 psRequestTid6:1;
			uint32 psTypeTid6	:1;
			uint32 psModeTid6	:1;
			uint32 DlHeMuEnTid6 :1;
			uint32 UlDataTid6	:1;
			uint32 reserved6	:1;
			
			uint32 dataTid7 	:1;
			uint32 lockTid7 	:1;
			uint32 psRequestTid7:1;
			uint32 psTypeTid7	:1;
			uint32 psModeTid7	:1;
			uint32 DlHeMuEnTid7 :1;
			uint32 UlDataTid7	:1;
			uint32 reserved7	:1;
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 dataTid8 	:1;
			uint32 lockTid8 	:1;
			uint32 psRequestTid8:1;
			uint32 psTypeTid8	:1;
			uint32 psModeTid8	:1;
			uint32 DlHeMuEnTid8 :1;
			uint32 reserved8	:2;
			
			uint32 reserved9	:16;
			
			uint32 bfType		:1;
			uint32 bfReq		:1;
			uint32 disable		:1;
			uint32 reserved10	:5;
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 twtAvail 		:1;
			uint32 twtSp			:1;
			uint32 twtType			:1;
			uint32 dlPlanIdx		:7;
			uint32 ulPlanIdx		:7;
			uint32 omiValid 		:1;
			uint32 omiSupported 	:1;
			uint32 tomiUlHeMuDis	:1;
			uint32 tomiDlHeMuDis	:1;
			uint32 romiMaxNss		:3;
			uint32 omiBw			:2;
			uint32 tomiMaxNss		:3;
#ifdef ENET_INC_ARCH_WAVE600D2
			uint32 disableHeSuEr	:1;
			uint32 insertAControl	:1; 	
			uint32 UlHeMuEn 		:1;
#else
			uint32 insertAControl	:1; 	
			uint32 UlHeMuEn 		:1;
			uint32 reserved11		:1;
#endif
		};
	};
} TxSelectorStaTidRam_t;


typedef struct TxSelectorVapTidRam
{
	TxSelectorVapTidRam_u vapTidRamWord0;	
	
} TxSelectorVapTidRam_t;


typedef struct TxSelectorGlobalRam
{
	TxSelectorGlobalRam_u globalRamWord0;
	
} TxSelectorGlobalRam_t;


typedef struct TxSelectorGplpGphpRam
{
	TxSelectorGplpGphpRam_u gplpGphpRamWord0;

} TxSelectorGplpGphpRam_t;


typedef struct TxSelectorBeaconRam
{
	TxSelectorBeaconRam_u beaconRamWord0;
	
} TxSelectorBeaconRam_t;

typedef struct TxSelectorPlanLockRam
{
	uint32 planLockBitmapWord0;
	uint32 planLockBitmapWord1;
	uint32 planLockBitmapWord2;
	uint32 planLockBitmapWord3;
	
} TxSelectorPlanLockRam_t;


typedef struct TxSelectorMuGroupRam
{
	TxSelectorMuGroupRamWord0_u muGroupRamWord0;
	TxSelectorMuGroupRamWord1_u muGroupRamWord1;
	
} TxSelectorMuGroupRam_t;


typedef struct TxSelectorMuStaRam
{
	TxSelectorMuStaRamWord0_u muStaRamWord0;
	
} TxSelectorMuStaRam_t;




typedef struct TxSelectorRam
{
	TxSelectorMuGroupRam_t 	   muGroupBitmap[TX_SELECTOR_NUM_OF_MU_GROUP_ENTRIES_IN_RAM];
	TxSelectorMuStaRam_t       muStaBitmap[TX_SELECTOR_NUM_OF_MU_STA_ENTRIES_IN_RAM];
	TxSelectorStaTidRam_t      staTidBitmap[TX_SELECTOR_NUM_OF_STATIONS_ENTRIES_IN_RAM];
	TxSelectorVapTidRam_t 	   vapTidBitmap[TX_SELECTOR_NUM_OF_VAP_ENTRIES_IN_RAM];
	TxSelectorGlobalRam_t 	   globalBitmap[TX_SELECTOR_NUM_OF_GLOBAL_ENTRIES_IN_RAM];
	TxSelectorGplpGphpRam_t    gplpBitmap[TX_SELECTOR_NUM_OF_GPLP_ENTRIES_IN_RAM];
	TxSelectorGplpGphpRam_t    gphpBitmap[TX_SELECTOR_NUM_OF_GPHP_ENTRIES_IN_RAM];
	TxSelectorBeaconRam_t 	   beaconBitmap[TX_SELECTOR_NUM_OF_BEACON_ENTRIES_IN_RAM];
	TxSelectorPlanLockRam_t    planLockBitmap;
} TxSelectorRam_t;





/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/

#endif // TX_SELECTOR_RAM_H_


