/***********************************************************************************
 File:		TxSequencer_Api.h
 Module:		TxSequencer
 Purpose: 	Owner for all access to the Tx Sequencer
 Description:	This module is the API to the Tx Sequencer
************************************************************************************/
#ifndef TX_SEQUENCER_API_H_
#define TX_SEQUENCER_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "linkAdaptation_api.h"
#include "TxSequencer.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/
void TxSequencer_Init(void);
uint16 TxSequencer_GetFifoNumEntriesCount(void);
void TxSequencer_DecFifoNumEntriesCount(uint8 value);
void TxSequencer_GetFifoEntry(TxSequencerReport_t* pCurrentSequencerReport);
void TxSequencer_incrementFifoEntryPtr(void);
void TxSequencer_FillFifoEntry(TxSequencerReport_t* pCurrentSequencerReport);
uint32 TxSequencer_GetStationIndex(TxSequencerReport_t* CurrentSequencerReport);
void TxSequencer_SetMinimalTimeToSendCfEnd(uint8 band);

void TxSequencer_SetMinimalSuTxopTimeThreshold(uint16 txopTimeThreshold);
#if defined (ENET_INC_ARCH_WAVE600)
void TxSequencer_SetMinimalHeMuTxopTimeThreshold(uint16 txopTimeThreshold);
#endif //ENET_INC_ARCH_WAVE600

void TxSequencer_SetMinimalVhtMuTxopTimeThreshold(uint16 txopTimeThreshold);
#ifdef ENET_INC_ARCH_WAVE600B
void TxSequencer_SetAdditionEtsiFillerTxopTimeThreshold(uint16 additionEtsiFillerTimeTxopThreshold);
void TxSequencer_SetMinimalEtsiFillerTimeThreshold(uint16 EtsiFillerTimeThreshold);
void TxSequencer_SetEtsiMode(uint8 etsiModeEnable);
#endif

#define TX_SEQUENCER_MAX_NUM_OF_BF_ITER		(3)				/*In case of timeout*/



#endif /* TX_SEQUENCER_API_H_ */
