/***************************************************************
 File:		UlPostRx.h
 Module:	Ul post rx
 Purpose: 	
 Description:  
***************************************************************/
#ifndef _UL_POST_RX_H_
#define _UL_POST_RX_H_

#include "UlPostRx_Api.h"
#include "UlPostRxRegs.h"

typedef struct UlPostRxErrorCounters
{
	uint16 ulprUserFifoDropCounter;
	uint16 ulprPulse1CollisionCounter;
	uint16 ulprPulse2CollisionCounter;
	uint16 ulprNonUniqCtrlIdCounter;
}UlPostRxErrorCounters_t;

typedef struct UlPostRxHeCtrlCounters
{
	uint16 omiCounter; // omi control counter
	uint16 uphCounter; // UL power headroom counter
	uint16 umrsCounter; // UL MU response scheduling counter
	uint16 hlaCounter; //HE link Adaptation counter
	uint16 bsrCounter; //Buffer Status Report counter
	uint16 bqrCounter; // BW Query Report counter
	uint16 cciCounter; // Command Control Indication counter
}UlPostRxHeCtrlCounters_t;

typedef enum UlPostRxControlId
{
	UL_CONTROL_ID_UMRS, // UL MU response scheduling
	UL_CONTROL_ID_OM, // Operation Mode
	UL_CONTROL_ID_HLA, //HE link Adaptation
	UL_CONTROL_ID_BSR,//Buffer Status Report
	UL_CONTROL_ID_UPH, // UL Power Headroom
	UL_CONTROL_ID_BQR, //BW Query Report
	UL_CONTROL_ID_CCI, // Command Control Indication
	UL_CONTROL_ID_MAX
}UlPostRxControlId_e;

#endif
