/***************************************************************
 File:		  VapDatabase_Api.h
 Module:	  	  VapDatabase
 Purpose: 	 
 Description:     This module is the API to the VAP database module. Calls that access VAP database parameters 
 			  should be made through the api functions located in this file. Direct access(Not through the api) to the
 			  VAP database parameters 
 			  is not permitted.
***************************************************************/
#ifndef VapDatabase_Api_H_
#define VapDatabase_Api_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"

#include "mhi_ieee_address.h"
#include "database.h"
#include "SharedDbTypes.h"
#include "ShramSecurity.h"
#include "VapDb.h"
#include "Std.h"

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Defines 					
//---------------------------------------------------------------------------------
typedef enum VapState
{
	VAP_STATE_FREE = 0,
	VAP_STATE_ADDED,
	VAP_STATE_NUM_OF_STATES,
	VAP_STATE_MAX_STATE,
}	VapState_e;

typedef enum VapDbPpduTxMode
{
	VAP_DB_PPDU_TX_MODE_LEGACY_ONLY = 0,
	VAP_DB_PPDU_TX_MODE_LEGACY_AND_MPDU,
	VAP_DB_PPDU_TX_MODE_TWO_LEVEL_AGGR,
}	VapDbPpduTxMode_e;

#define FIRST_TID		 					0
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct VapDbActivateVap
{
	uint8		   bssIndex;   // index of bss ID (currently there is only one)	
	IEEE_ADDR      bssId;
	uint8		   vapMode		:1;
} VapDbActivateVap_t;

typedef struct VapDbSwInfo
{
	/* General parameters */
	VapState_e  state;
	uint8       connectedStationsNum;
    StaId 		firstConnectedStationIndex;	
	IEEE_ADDR   macAddress;
}	VapDbSwInfo_t;

typedef struct VapDbObject
{
	VapDbSwInfo_t vapDbSwEntries[HW_NUM_OF_VAPS];
	VapDb_t*      pVapDbHwEntries; // [NUM_VAP_DBASE_ENTRIES];
} VapDbObject_t;


//---------------------------------------------------------------------------------
//						Globals
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration 			
//---------------------------------------------------------------------------------
uint32 vapDbGetPsduMaxLengthLimit(bool vhtStation);
void VapDb_AddStationCounter(uint8 vapId);
void VapDb_DecreaseStationCounter(uint8 vapId);
void VapDb_SetFirstConnectedStaIndex(uint8 vapIndex, StaId staIndex);	
void VapDbCopyIeeeAddrToBssIdType(IEEE_ADDR* pMacAddress, VapDbBssid_t* pBssId);
StaId VapDb_GetFirstConnectedStaIndex(uint8 vapIndex);
#if defined (ENET_INC_UMAC)
void VapDb_AssignVap(UMI_ADD_VAP *vapInfoPtr); 
#endif
RetVal_e VapDb_AddVap(VapDbActivateVap_t* vapParams, uint8 vapId);
RetVal_e VapDb_ResetVapEntry(uint8 vapId);
RetVal_e VapDB_SetSecurityKey(uint8 vapIndex, bool rekeyDisableFlag, UMI_SET_KEY *pSetKey);
RetVal_e VapDB_SetDefaultKeyIndex(uint8 vapIndex, uint8 defaultKeyId);
uint32 VapDB_GetDefaultKeyIndex(uint8 vapId);
uint32 VapDB_GetKeyIndexValue(uint8 vapIndex, uint8 keyIndex);
RetVal_e VapDB_ClearSecurityKey(uint8 vapId);
void VapDb_InvalidateGroupKey(uint8 vapIndex, uint8 keyId);
bool VapDb_GroupKeyValid(uint8 vapIndex, uint8 keyId);
VapState_e VapDB_GetVapState(uint8 vapIndex);
RetVal_e VapDB_GetManagementPhyMode(uint8 vapId, PhyMode_e* pPhyMode);
uint32 VapDb_GetVapMode(uint32 vapIndex);
RetVal_e VapDB_Init(void);
IEEE_ADDR* VapDB_GetMacAddress(uint8 vapId);
uint32 VapDB_GetDataEncryptionType(uint8 vapId);
void VapDB_SetDataEncryptionType(uint8 vapId, uint32 dataEncryptionType);
uint8 VapDB_IsManagementEncryptionEnabled(uint8 vapId);
uint32 VapDB_GetManagementEncryptionType(uint8 vapId);
void VapDB_SetManagementEncryptionType(uint8 vapId, uint32 encryptionType);
void VapDB_DisableManagementEncryption(uint8 vapId);
uint8 VapDB_IsDataEncryptionEnabled(uint8 vapId);
void VapDB_SetDataEncryptionEnabled(uint8 vapId, uint8 dataEncryptionEnable);
void VapDB_SetManagementEncryptionEnabled(uint8 vapId, uint8 managementEncryptionEnable);
void VapDB_GetPn(uint8 vapId, uint8 *pnAddress);
void VapDB_SetPn(uint8 vapId, uint8 *pnAddress);
uint8 VapDB_FindCompatibleVap(IEEE_ADDR* macAddress);
uint8 VapDB_GetQosEnable(uint8 vapIndex);
VapDbTid_t* VapDB_GetTidParams(uint8 vapIndex , uint8 tid);
#ifdef DUT_LOGS_ON
uint8 VapDB_GetRfPower(uint8);
#endif
#ifdef MU_MIMO_STATIC_GROUP_SEND_AID_TO_STATION_ENABLED
void VapDB_SetAid(uint8 vapId, uint16 aid);
#endif
#endif //  VapDatabase_Api_H_
	

