CONSTANTS {PAS_BASE                = 0xA6C00000}
CONSTANTS {SYS_IF_BASE             = 0xA0180000}
CONSTANTS {HRC_BASE                = 0xA01B0000}
CONSTANTS {DUMMY_PHY_BASE          = 0xAf000000}
CONSTANTS {SHRAM_BASE              = 0xA6000000}
CONSTANTS {SHRAM_SIZE              = 0x00020000}
CONSTANTS {SHRAM_EXTENDED_SIZE     = 0x00060000}
CONSTANTS {SHARED_RAM_TX_RECIPES   = 0xA61C8000}
CONSTANTS {CALIBRATION_SIZE        = 0x00000004}
CONSTANTS {ADDR_SHARING_SIZE       = 0x00000018}
CONSTANTS {BCL_ON_EXCEPTION_SIZE   = 0x00000110}
CONSTANTS {SHRAM_END_SIZE   	   = 0x00000028}
CONSTANTS {VECTOR_INT_SIZE         = 0x20; VECTOR_INT_NUM = 0}
CONSTANTS {MT_EX_FPGA_CTRL_ADDRESS = 0xAA000000}
CONSTANTS {MT_EX_FPGA_CTRL_ADDRESS = 0xAA000000}
CONSTANTS {PHY_BE_BASE             = 0xAf400000}
CONSTANTS {PHY_RX_TD_BASE          = 0xAf300000}
CONSTANTS {PHY_TX_BASE             = 0xA01F2000}
#(504 + 8) * 2 = 1024
#1024 + 16 = 1040 = 0x410
CONSTANTS {SHARED_RAM_LOGGER_SIZE  = 0x00000410}
#CONSTANTS {SHARED_RAM_LOGGER_SIZE  = 0x00000610}
CONSTANTS {SHARED_RAM_LM_LOGGER_SIZE = 0x00000100}
CONSTANTS {SHARED_RAM_WATCHDOG_SIZE = 0x00000028}
CONSTANTS {SHARED_RAM_ERROR_HANDLER_SIZE = 0x00000074}
CONSTANTS {SHARED_RAM_STORE_CAL_RESULTS_BUFFER_SIZE = 0x00000334}
CONSTANTS {GENRISC_TX_SPRAM_BASE    = 0xA01F4000}
CONSTANTS {TX_HANDLER_TIMING_PARAMS_BASE    = 0xA6C34800}

SECTIONS
{
    .boot               0xbfc00000   size(24)                   :
    .base_inst          0x80000000                              :
    .exception          0x80000180                              :
    .vector             0x80000200                              :
    .vector_irq1        0x80000220                              :
    .vector_irq2        0x80000240                              :
    .vector_irq3        0x80000260                              :
    .vector_irq4        0x80000280                              :
    .vector_irq5        0x800002A0                              :
    .vector_irq6        0x800002C0                              :
    .vector_irq7        0x800002e0                              :
    .vector_irq8        0x80000300                              :
    .vector_irq9        0x80000320                              :
    .vector_irq10       0x80000340                              :
    .vector_irq11       0x80000360                              :
    .vector_irq12       0x80000380                              :
    .vector_irq13       0x800003A0                              :
    .vector_irq14       0x800003C0                              :
    .vector_irq15       0x800003E0                              :
    .vector_irq16       0x80000400                              :
    .vector_irq17       0x80000420                              :
    .vector_irq18       0x80000440                              :
    .vector_irq19       0x80000460                              :
    .vector_irq20       0x80000480                              :
    .vector_irq21       0x800004A0                              :
    .vector_irq22       0x800004C0                              :
    .vector_irq23       0x800004E0                              :
    .vector_irq24       0x80000500                              :
    .vector_irq25       0x80000520                              :
    .vector_irq26       0x80000540                              :
    .vector_irq27       0x80000560                              :
    .vector_irq28       0x80000580                              :
    .vector_irq29       0x800005A0                              :
    .vector_irq30       0x800005C0                              :
    .vector_irq31       0x800005E0                              :
    .shadow_file_init   0x80000600                              :
    .cacheclean         0x80000700                              :
##########################################################################
#                                                                        #
#  assumption : .initialization section adjacent to .initialization_data #
#  which is adjacent to .text section                                    #
#  otherwise change the implementation of "System_MainPreMemoryOverlay" #
#                                                                        #
##########################################################################
	.initialization_start                	:
    .initialization     align(4)            :
    .initialization_end           			:
    .text               align(4)          	:
	.text_rom			align(4)          	:
	.free_mem								:
# We have no ROM in the system	
#   .romsdata    ROM(.sdata)                : 
#   .dummy1      align(4)                   :
#   .romdata     ROM(.data)                 :
    .sdabase     align(4)                   :
    .stack       align(8)       pad(0x600) :
    .stack2      align(4)       pad(0x10)   :
    .sdata       align(4)                   :
    .data        align(4)                   :
    .rodata      align(4)                   :
    .sbss        align(4)                   :
#    .sbss_align2 align(4)                   :
    .bss         align(4)                   :
#    new stack for exception the stack need to
#    be 100byte i add some spare
    .Exc_stack 	 align(4)       pad(0x100)  :
#   .Exc_stack2  align(4)       pad(0x10)   :
    .secinfo                                :
    .heap                                   :
    .BRC_INT                                :
    .BRC_GPIO                               :
    .BRC_WDG                                :
    .BRC_MIR                                :
    .BRC_PHY                                :
# if the platform supports external DDR and the image is exceeds the ram size we can choose which functions and variables to place in the DDR	
#   .HRC_HRT    0xa01b0000                  :
#   .HRC_CFG    0xa01b1000                  :
    .HRC_HRT HRC_BASE                       :
    .HRC_CFG HRC_BASE + 0x1000              :
    .SHARED_RAM_BASE_ADDR SHRAM_BASE        :
    .SHARED_RAM_IPC_QUEUES             		: 
    .SHARED_RAM_IPC_MSGS                     	: 
    .SHARED_RAM_DRIVER_INTERFACE                : 
    .SHARED_RAM_HOST_IF_RINGS_BUFFERS 			:
	.SHARED_RAM_SHRAM_INT						:
    .SHARED_RAM_MAC_GENRISC_INIT_VECTORS 		align(4) :
	.SHARED_RAM_GENRISC_MAILBOXES				align(4) :
	.SHARED_RAM_GENRISC_NDPA_INFO				align(4) :
	.SHARED_RAM_RXHSNIFFER					align(4) :
	.SHARED_RAM_PS_SETTINGS					align(4) :
	.SHARED_RAM_RXF_A_MPDU_NO_BA_AGGREMENT_FIFO 		align(4) :
	.SHARED_RAM_RXPP_FRAGMENT_FIFO              		align(8) :
	.SHARED_RAM_BA_ANALYZER_STATUS_FIFO			align(4) :
	.SHRED_RAM_AGGR_BUILDER_DB				align(4) :
	.SHARED_RAM_TX_SEQUENCER_DATA_BASE 			align(4) :
#	.SHARED_RAM_NEW_DELIA_RECIPES 				align(4) :
	.SHARED_RAM_PHY_STAT_DB						align(4) :
	.SHARED_RAM_STATISTIC_MANAGER				align(4) :	
	.SHARED_RAM_GROUP_DATA_BASE 				align(4) :
	.SHARED_RAM_TX_BAA_REPORTS_FIFO 			align(4) :
	.SHARED_RAM_ATF					 			align(4) :
    .SHARED_RAM_STORE_CAL_RESULTS_BUFFER 		align(4) :
	.SHARED_RAM_TPC_DATABASE_BSS				align(4) :
    .SHARED_RAM_DMAC_WRAPPER 					align(4) :	
    .SHARED_RAM_BEAMFORMING						align(4) :
# The next section "SHARED_RAM_LM_UM_ALIGNMENT" is used for testing
# alignment between the upper and the lower cpu, don't remove. 
    .SHARED_RAM_LM_UM_ALIGNMENT                 :    
    .SHARED_RAM_START_OF_FREE_SPACE             :
    .SHARED_RAM_ERROR_HANDLER  SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE - ADDR_SHARING_SIZE - CALIBRATION_SIZE - SHARED_RAM_LM_LOGGER_SIZE - SHARED_RAM_LOGGER_SIZE - SHARED_RAM_ERROR_HANDLER_SIZE :
    .SHARED_RAM_LOGGER SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE - ADDR_SHARING_SIZE - CALIBRATION_SIZE - SHARED_RAM_LM_LOGGER_SIZE - SHARED_RAM_LOGGER_SIZE :
    .SHARED_RAM_LM_LOGGER SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE - ADDR_SHARING_SIZE - CALIBRATION_SIZE - SHARED_RAM_LM_LOGGER_SIZE :
    .SHARED_RAM_CALIBRATION SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE - ADDR_SHARING_SIZE - CALIBRATION_SIZE :
    # The section SHARED_RAM_ADDR_SHARING should be in a fixed position
    # (never change it), because both host and MIPSs use it for chipvar
    .SHARED_RAM_ADDR_SHARING SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE - ADDR_SHARING_SIZE :
    .SHARED_RAM_BCL_ON_EXCEPTION SHRAM_BASE + SHRAM_SIZE - BCL_ON_EXCEPTION_SIZE : 
    # End of section
    .SHARED_RAM_GENRISC_INIT_VECTOR_START_ADDR	       SHRAM_BASE +     0x20000  :
	.SHARED_RAM_DATA_TX_DESC align(4)   				 :
	.SHARED_RAM_TX_DESC	align(4)             			 :
	.SHARED_RAM_FW_TX_MANAGEMENT_PAYLOAD align(4)		 :	
    .SHARED_RAM_RX_DESCRIPTORS align(4)                  :
    .SHARED_RAM_FW_RX_DESCRIPTORS_PAYLOAD align(8)       :
    .SHARED_RAM_STATION_DATA_BASE align(4)  			 :
    .SHARED_RAM_VAP_DATA_BASE align(4)  			     :
    .SHARED_RAM_GPLP_DATA_BASE align(4)  			     :
    .SHARED_RAM_GPHP_DATA_BASE align(4)  			     :
    .SHARED_RAM_BEACON_DATA_BASE align(4)       	     :
    .SHARED_RAM_AGGREGATION_BUILDER align(4)       	     :
	.SHARED_RAM_SECURITY align(4)						 :    
    .SHARED_RAM_PACKET_DESCRIPTORS align(4)              :
    .SHARED_RAM_BEACON_HANDLER align(4)					 :
    .SHARED_RAM_HD_ADDR_RING align(4)					 :
    .SHARED_RAM_CLIENT_MODE_MCAST_FILTER align(4)   	 :    
    .SHARED_RAM_HW_LOGGER_BUFFERS 				align(4) :
    .SHARED_RAM_LOGGER_DESC						align(4) :
    .SHARED_RAM_END_ADDR	SHRAM_BASE + SHRAM_EXTENDED_SIZE - SHRAM_END_SIZE: 			
	
	.SHARED_RAM_SECURITY_NEW			align(8) SHARED_RAM_TX_RECIPES	:    
    .SHARED_RAM_DELIA_DESCRIPTORS		align(8)				:
    .SHARED_RAM_NEW_DELIA_RECIPES		align(8)				:
    .PAS_RXF                   PAS_BASE                  :      
    .PAS_RXD                   PAS_BASE +       0x100    :
    .PAS_DEL                   PAS_BASE +       0x200    :
    .PAS_RXC                   PAS_BASE +       0x300    :
    .PAS_DUR                   PAS_BASE +       0x400    :
    .PAS_NTD                   PAS_BASE +       0x500    :
    .PAS_TXC                   PAS_BASE +       0x600    :
    .PAS_TIM                   PAS_BASE +       0x700    :
    .PAS_EMW                   PAS_BASE +       0x10000  :
    .PAS_RAB                   PAS_BASE +       0x20000  :
    .PAS_CLC                   PAS_BASE +       0x30000  :
    .BRC_PHYE                  DUMMY_PHY_BASE            :
    .BRC_PHYE_METRICS          DUMMY_PHY_BASE + 0x200	 : 
    .BRC_MT_PHY_REG_BLOCK      DUMMY_PHY_BASE + 0x200	 : 
    .BRC_MT_PHY_RATE_TABLE     DUMMY_PHY_BASE + 0x400	 : 
    .IF_EXTERNAL_FPGA_ACC_CTRL MT_EX_FPGA_CTRL_ADDRESS   :
    .PHY_RXTD_GRTZL_MEM        PHY_RX_TD_BASE + 0x14C    :
    .PHY_RX_TD_DECORR_GAINS_0  PHY_RX_TD_BASE + 0x10028  :
    .PHY_RX_TD_DECORR_GAINS_1  PHY_RX_TD_BASE + 0x10030  :
    .PHY_RX_TD_DECORR_GAINS_2  PHY_RX_TD_BASE + 0x10038  :
    .PHY_RX_TD_EQ_TAPS_0       PHY_RX_TD_BASE + 0x190    :
    .PHY_RX_TD_EQ_TAPS_1       PHY_RX_TD_BASE + 0x390    :
    .PHY_RX_TD_EQ_TAPS_2       PHY_RX_TD_BASE + 0x590    :
    .PHY_RX_TD_EQ_COUNTERS_0   PHY_RX_TD_BASE + 0x20     :
    .PHY_RX_TD_EQ_COUNTERS_1   PHY_RX_TD_BASE + 0x220    :
    .PHY_RX_TD_EQ_COUNTERS_2   PHY_RX_TD_BASE + 0x420    :
    .PHY_RX_TD_RXIQ_CTRL_0     PHY_RX_TD_BASE + 0x30     :
    .PHY_RX_TD_RXIQ_CTRL_1     PHY_RX_TD_BASE + 0x230    :
    .PHY_RX_TD_RXIQ_CTRL_2     PHY_RX_TD_BASE + 0x430    :
    .PHY_TPC_TABLE             PHY_TX_BASE +    0x8000   :
	.PHY_MU_GROUP_USP_TABLE    PHY_BE_BASE +    0x8000   :
    .GENRISC_TX_STD            GENRISC_TX_SPRAM_BASE     :
    .TX_HANDLER_TIMING_PARAMS  TX_HANDLER_TIMING_PARAMS_BASE :
}                                                       
